/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.dimensions.GeneralRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.TextFormat;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.IdPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.NodeConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITTextAnnotation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class TextAnnotationConverter
implements NodeConverter<JSITTextAnnotation, TextAnnotation> {
    private FactoryManager factoryManager;

    public TextAnnotationConverter(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    @Override
    public Node<View<TextAnnotation>, ?> nodeFromDMN(JSITTextAnnotation dmn, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        Node node = this.factoryManager.newElement(dmn.getId(), BindableAdapterUtils.getDefinitionId(TextAnnotation.class)).asNode();
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        Text text = new Text(dmn.getText());
        TextFormat textFormat = new TextFormat(dmn.getTextFormat());
        TextAnnotation textAnnotation = new TextAnnotation(id, description, text, textFormat, new BackgroundSet(), new FontSet(), new GeneralRectangleDimensionsSet());
        ((View)node.getContent()).setDefinition((Object)textAnnotation);
        return node;
    }

    @Override
    public JSITTextAnnotation dmnFromNode(Node<View<TextAnnotation>, ?> node, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        TextAnnotation source = (TextAnnotation)((View)node.getContent()).getDefinition();
        JSITTextAnnotation result = new JSITTextAnnotation();
        result.setId(source.getId().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(source.getDescription()));
        description.ifPresent(arg_0 -> ((JSITTextAnnotation)result).setDescription(arg_0));
        result.setText(source.getText().getValue());
        result.setTextFormat(source.getTextFormat().getValue());
        return result;
    }
}

