/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import org.kie.workbench.common.dmn.api.definition.DMNViewDefinition;
import org.kie.workbench.common.dmn.api.definition.model.Association;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.AssociationConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.BusinessKnowledgeModelConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DecisionConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DecisionServiceConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DefinitionsConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.InputDataConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.KnowledgeSourceConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.TextAnnotationConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.dd.PointUtils;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.utils.DMNMarshallerUtils;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.utils.WrapperUtils;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.MainJs;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.di.JSIDiagramElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITArtifact;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAssociation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITBusinessKnowledgeModel;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecision;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecisionService;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInputData;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeSource;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITTextAnnotation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDI;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDiagram;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNEdge;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentsWidthsExtension;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@ApplicationScoped
public class DMNMarshallerKogitoMarshaller {
    public static final String PREFIX = "dmn";
    private InputDataConverter inputDataConverter;
    private DecisionConverter decisionConverter;
    private BusinessKnowledgeModelConverter bkmConverter;
    private KnowledgeSourceConverter knowledgeSourceConverter;
    private TextAnnotationConverter textAnnotationConverter;
    private DecisionServiceConverter decisionServiceConverter;

    protected DMNMarshallerKogitoMarshaller() {
        this(null);
    }

    @Inject
    public DMNMarshallerKogitoMarshaller(FactoryManager factoryManager) {
        this.inputDataConverter = new InputDataConverter(factoryManager);
        this.decisionConverter = new DecisionConverter(factoryManager);
        this.bkmConverter = new BusinessKnowledgeModelConverter(factoryManager);
        this.knowledgeSourceConverter = new KnowledgeSourceConverter(factoryManager);
        this.textAnnotationConverter = new TextAnnotationConverter(factoryManager);
        this.decisionServiceConverter = new DecisionServiceConverter(factoryManager);
    }

    @PostConstruct
    public void init() {
        MainJs.initializeJsInteropConstructors((JsPropertyMap)MainJs.getConstructorsMap());
    }

    public JSITDefinitions marshall(Graph<?, Node<View, ?>> graph) {
        HashMap<String, JSITDRGElement> nodes = new HashMap<String, JSITDRGElement>();
        HashMap<String, JSITTextAnnotation> textAnnotations = new HashMap<String, JSITTextAnnotation>();
        Node<?, ?> dmnDiagramRoot = DMNMarshallerUtils.findDMNDiagramRoot(graph);
        Definitions definitionsStunnerPojo = ((DMNDiagram)DefinitionUtils.getElementDefinition(dmnDiagramRoot)).getDefinitions();
        ArrayList<JSIDMNEdge> dmnEdges = new ArrayList<JSIDMNEdge>();
        this.cleanImportedItemDefinitions(definitionsStunnerPojo);
        JSITDefinitions definitions = DefinitionsConverter.dmnFromWB(definitionsStunnerPojo);
        if (Objects.isNull(definitions.getExtensionElements())) {
            JSITDMNElement.JSIExtensionElements jsiExtensionElements = new JSITDMNElement.JSIExtensionElements();
            definitions.setExtensionElements(jsiExtensionElements);
        }
        if (Objects.isNull(definitions.getDMNDI())) {
            definitions.setDMNDI(new JSIDMNDI());
        }
        JSIDMNDiagram dmnDDDMNDiagram = new JSIDMNDiagram();
        dmnDDDMNDiagram.setDMNDiagramElement(new ArrayList());
        definitions.getDMNDI().addDMNDiagram(dmnDDDMNDiagram);
        for (Node node : graph.nodes()) {
            PointUtils.convertToAbsoluteBounds(node);
        }
        if (Objects.isNull(dmnDDDMNDiagram.getExtension())) {
            dmnDDDMNDiagram.setExtension(new JSIDiagramElement.JSIExtension());
        }
        JSITComponentsWidthsExtension componentsWidthsExtension = new JSITComponentsWidthsExtension();
        JSIDiagramElement.JSIExtension extension = dmnDDDMNDiagram.getExtension();
        JSITComponentsWidthsExtension wrappedComponentsWidthsExtension = WrapperUtils.getWrappedJSITComponentsWidthsExtension(componentsWidthsExtension);
        extension.addAny((Object)wrappedComponentsWidthsExtension);
        Consumer<JSITComponentWidths> componentWidthsConsumer = cw -> componentsWidthsExtension.addComponentWidths(cw);
        for (Node node : graph.nodes()) {
            String namespaceURI;
            if (!(node.getContent() instanceof View)) continue;
            View view = (View)node.getContent();
            if (view.getDefinition() instanceof DRGElement) {
                DRGElement drgElement = (DRGElement)view.getDefinition();
                if (!drgElement.isAllowOnlyVisualChange()) {
                    nodes.put(drgElement.getId().getValue(), this.stunnerToDMN(node, componentWidthsConsumer));
                }
                namespaceURI = definitionsStunnerPojo.getDefaultNamespace();
                dmnDDDMNDiagram.addDMNDiagramElement((JSIDiagramElement)WrapperUtils.getWrappedJSIDMNShape((View<? extends DMNElement>)view, namespaceURI));
            } else if (view.getDefinition() instanceof TextAnnotation) {
                TextAnnotation textAnnotation = (TextAnnotation)view.getDefinition();
                textAnnotations.put(textAnnotation.getId().getValue(), this.textAnnotationConverter.dmnFromNode((Node<View<TextAnnotation>, ?>)node, componentWidthsConsumer));
                namespaceURI = definitionsStunnerPojo.getDefaultNamespace();
                dmnDDDMNDiagram.addDMNDiagramElement((JSIDiagramElement)WrapperUtils.getWrappedJSIDMNShape((View<? extends DMNElement>)view, namespaceURI));
                List<JSITAssociation> associations = AssociationConverter.dmnFromWB(node);
                for (int i = 0; i < associations.size(); ++i) {
                    JSITAssociation wrappedJSITAssociation = WrapperUtils.getWrappedJSITAssociation((JSITAssociation)Js.uncheckedCast((Object)associations.get(i)));
                    definitions.addArtifact((JSITArtifact)wrappedJSITAssociation);
                }
            }
            List inEdges = node.getInEdges();
            for (Edge e : inEdges) {
                View edgeView;
                DMNViewDefinition dmnViewDefinition;
                ViewConnector connectionContent;
                if (!(e.getContent() instanceof ViewConnector) || !(connectionContent = (ViewConnector)e.getContent()).getSourceConnection().isPresent() || !connectionContent.getTargetConnection().isPresent()) continue;
                Point2D sourcePoint = ((Connection)connectionContent.getSourceConnection().get()).getLocation();
                Point2D targetPoint = ((Connection)connectionContent.getTargetConnection().get()).getLocation();
                Node sourceNode = e.getSourceNode();
                View sourceView = (View)sourceNode.getContent();
                double xSource = PointUtils.xOfBound(PointUtils.upperLeftBound(sourceView));
                double ySource = PointUtils.yOfBound(PointUtils.upperLeftBound(sourceView));
                double xTarget = PointUtils.xOfBound(PointUtils.upperLeftBound(view));
                double yTarget = PointUtils.yOfBound(PointUtils.upperLeftBound(view));
                if (Objects.isNull(sourcePoint)) {
                    if (sourceView.getDefinition() instanceof DMNViewDefinition) {
                        dmnViewDefinition = (DMNViewDefinition)sourceView.getDefinition();
                        xSource += dmnViewDefinition.getDimensionsSet().getWidth().getValue() / 2.0;
                        ySource += dmnViewDefinition.getDimensionsSet().getHeight().getValue() / 2.0;
                    }
                    sourcePoint = Point2D.create((double)xSource, (double)ySource);
                } else {
                    sourcePoint = Point2D.create((double)(xSource + sourcePoint.getX()), (double)(ySource + sourcePoint.getY()));
                }
                if (Objects.isNull(targetPoint)) {
                    if (view.getDefinition() instanceof DMNViewDefinition) {
                        dmnViewDefinition = (DMNViewDefinition)view.getDefinition();
                        xTarget += dmnViewDefinition.getDimensionsSet().getWidth().getValue() / 2.0;
                        yTarget += dmnViewDefinition.getDimensionsSet().getHeight().getValue() / 2.0;
                    }
                    targetPoint = Point2D.create((double)xTarget, (double)yTarget);
                } else {
                    targetPoint = Point2D.create((double)(xTarget + targetPoint.getX()), (double)(yTarget + targetPoint.getY()));
                }
                JSIDMNEdge dmnEdge = new JSIDMNEdge();
                String uuid = e.getUUID();
                if (e.getContent() instanceof View && (edgeView = (View)e.getContent()).getDefinition() instanceof Association) {
                    uuid = ((Association)edgeView.getDefinition()).getId().getValue();
                }
                dmnEdge.setId("dmnedge-" + uuid);
                String namespaceURI2 = definitionsStunnerPojo.getDefaultNamespace();
                dmnEdge.setDmnElementRef(new QName(namespaceURI2, uuid, ""));
                dmnEdge.addWaypoint(PointUtils.point2dToDMNDIPoint(sourcePoint));
                for (ControlPoint cp : connectionContent.getControlPoints()) {
                    dmnEdge.addWaypoint(PointUtils.point2dToDMNDIPoint(cp.getLocation()));
                }
                dmnEdge.addWaypoint(PointUtils.point2dToDMNDIPoint(targetPoint));
                dmnEdges.add(dmnEdge);
            }
        }
        nodes.values().forEach(n -> {
            JSINodeLocalPartName localPart = JSINodeLocalPartName.UNKNOWN;
            if (JSITBusinessKnowledgeModel.instanceOf((Object)n)) {
                localPart = JSINodeLocalPartName.BUSINESS_KNOWLEDGE_MODEL;
            } else if (JSITDecision.instanceOf((Object)n)) {
                localPart = JSINodeLocalPartName.DECISION;
            } else if (JSITDecisionService.instanceOf((Object)n)) {
                localPart = JSINodeLocalPartName.DECISION_SERVICE;
            } else if (JSITInputData.instanceOf((Object)n)) {
                localPart = JSINodeLocalPartName.INPUT_DATA;
            } else if (JSITKnowledgeSource.instanceOf((Object)n)) {
                localPart = JSINodeLocalPartName.KNOWLEDGE_SOURCE;
            }
            JSITDRGElement toAdd = WrapperUtils.getWrappedJSITDRGElement(n, PREFIX, localPart.getLocalPart());
            definitions.addDrgElement(toAdd);
        });
        textAnnotations.values().forEach(text -> {
            JSITTextAnnotation wrappedText = WrapperUtils.getWrappedJSITTextAnnotation(text);
            definitions.addArtifact((JSITArtifact)wrappedText);
        });
        for (int i = 0; i < dmnEdges.size(); ++i) {
            dmnDDDMNDiagram.addDMNDiagramElement((JSIDiagramElement)WrapperUtils.getWrappedJSIDMNEdge((JSIDMNEdge)Js.uncheckedCast(dmnEdges.get(i))));
        }
        return definitions;
    }

    void cleanImportedItemDefinitions(Definitions definitions) {
        definitions.getItemDefinition().removeIf(ItemDefinition::isAllowOnlyVisualChange);
    }

    public JSITDRGElement stunnerToDMN(Node<?, ?> node, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        if (node.getContent() instanceof View) {
            View view = (View)node.getContent();
            if (view.getDefinition() instanceof InputData) {
                return this.inputDataConverter.dmnFromNode((Node<View<InputData>, ?>)node, componentWidthsConsumer);
            }
            if (view.getDefinition() instanceof Decision) {
                return this.decisionConverter.dmnFromNode((Node<View<Decision>, ?>)node, componentWidthsConsumer);
            }
            if (view.getDefinition() instanceof BusinessKnowledgeModel) {
                return this.bkmConverter.dmnFromNode((Node<View<BusinessKnowledgeModel>, ?>)node, componentWidthsConsumer);
            }
            if (view.getDefinition() instanceof KnowledgeSource) {
                return this.knowledgeSourceConverter.dmnFromNode((Node<View<KnowledgeSource>, ?>)node, componentWidthsConsumer);
            }
            if (view.getDefinition() instanceof DecisionService) {
                return this.decisionServiceConverter.dmnFromNode((Node<View<DecisionService>, ?>)node, componentWidthsConsumer);
            }
            throw new UnsupportedOperationException("Unsupported View type [" + view.getDefinition().getClass().getName() + "]");
        }
        throw new RuntimeException("wrong diagram structure to marshall");
    }

    public static enum JSINodeLocalPartName {
        UNKNOWN("UNKNOWN"),
        BUSINESS_KNOWLEDGE_MODEL("businessKnowledgeModel"),
        DECISION("decision"),
        DECISION_SERVICE("decisionService"),
        INPUT_DATA("inputData"),
        KNOWLEDGE_SOURCE("knowledgeSource");

        private String localPart;

        private JSINodeLocalPartName(String localPart) {
            this.localPart = localPart;
        }

        public String getLocalPart() {
            return this.localPart;
        }
    }
}

