/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.model.BuiltinAggregator;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTableOrientation;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DecisionRulePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.IdPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.InputClausePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.OutputClausePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.QNamePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITBuiltinAggregator;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecisionRule;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecisionTable;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecisionTableOrientation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITHitPolicy;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInputClause;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITOutputClause;

public class DecisionTablePropertyConverter {
    public static DecisionTable wbFromDMN(JSITDecisionTable dmn) {
        String orientation;
        String aggregation;
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        QName typeRef = QNamePropertyConverter.wbFromDMN(dmn.getTypeRef());
        DecisionTable result = new DecisionTable();
        result.setId(id);
        result.setDescription(description);
        result.setTypeRef(typeRef);
        List jsiInputClauses = dmn.getInput();
        for (int i = 0; i < jsiInputClauses.size(); ++i) {
            JSITInputClause input = (JSITInputClause)Js.uncheckedCast(jsiInputClauses.get(i));
            InputClause inputClauseConverted = InputClausePropertyConverter.wbFromDMN(input);
            if (!Objects.nonNull(inputClauseConverted)) continue;
            inputClauseConverted.setParent((DMNModelInstrumentedBase)result);
            result.getInput().add(inputClauseConverted);
        }
        List jsiOutputClauses = dmn.getOutput();
        for (int i = 0; i < jsiOutputClauses.size(); ++i) {
            JSITOutputClause output = (JSITOutputClause)Js.uncheckedCast(jsiOutputClauses.get(i));
            OutputClause outputClauseConverted = OutputClausePropertyConverter.wbFromDMN(output);
            if (!Objects.nonNull(outputClauseConverted)) continue;
            outputClauseConverted.setParent((DMNModelInstrumentedBase)result);
            result.getOutput().add(outputClauseConverted);
        }
        if (result.getOutput().size() == 1) {
            OutputClause outputClause = (OutputClause)result.getOutput().get(0);
            outputClause.setName(null);
            outputClause.setTypeRef(null);
        }
        List jsiDecisionRules = dmn.getRule();
        for (int i = 0; i < jsiDecisionRules.size(); ++i) {
            JSITDecisionRule dr = (JSITDecisionRule)Js.uncheckedCast(jsiDecisionRules.get(i));
            DecisionRule decisionRuleConverted = DecisionRulePropertyConverter.wbFromDMN(dr);
            if (Objects.nonNull(decisionRuleConverted)) {
                decisionRuleConverted.setParent((DMNModelInstrumentedBase)result);
            }
            result.getRule().add(decisionRuleConverted);
        }
        String hitPolicy = (String)Js.uncheckedCast((Object)dmn.getHitPolicy());
        if (Objects.nonNull(hitPolicy)) {
            result.setHitPolicy(HitPolicy.fromValue((String)hitPolicy));
        }
        if (Objects.nonNull(aggregation = (String)Js.uncheckedCast((Object)dmn.getAggregation()))) {
            result.setAggregation(BuiltinAggregator.fromValue((String)aggregation));
        }
        if (Objects.nonNull(orientation = (String)Js.uncheckedCast((Object)dmn.getPreferredOrientation()))) {
            result.setPreferredOrientation(DecisionTableOrientation.fromValue((String)orientation));
        }
        result.setOutputLabel(dmn.getOutputLabel());
        return result;
    }

    public static JSITDecisionTable dmnFromWB(DecisionTable wb) {
        JSITInputClause c;
        JSITDecisionTable result = new JSITDecisionTable();
        result.setId(wb.getId().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(wb.getDescription()));
        description.ifPresent(arg_0 -> ((JSITDecisionTable)result).setDescription(arg_0));
        QNamePropertyConverter.setDMNfromWB(wb.getTypeRef(), arg_0 -> ((JSITDecisionTable)result).setTypeRef(arg_0));
        for (InputClause input : wb.getInput()) {
            c = InputClausePropertyConverter.dmnFromWB(input);
            result.addInput(c);
        }
        for (InputClause input : wb.getOutput()) {
            c = OutputClausePropertyConverter.dmnFromWB((OutputClause)input);
            result.addOutput((JSITOutputClause)c);
        }
        if (result.getOutput().size() == 1) {
            JSITOutputClause at = (JSITOutputClause)Js.uncheckedCast(result.getOutput().get(0));
            at.setName(null);
            at.setTypeRef(null);
        }
        for (DecisionRule dr : wb.getRule()) {
            c = DecisionRulePropertyConverter.dmnFromWB(dr);
            result.addRule((JSITDecisionRule)c);
        }
        if (Objects.nonNull(wb.getHitPolicy())) {
            switch (wb.getHitPolicy()) {
                case ANY: {
                    result.setHitPolicy((JSITHitPolicy)Js.uncheckedCast((Object)JSITHitPolicy.ANY.value()));
                    break;
                }
                case COLLECT: {
                    result.setHitPolicy((JSITHitPolicy)Js.uncheckedCast((Object)JSITHitPolicy.COLLECT.value()));
                    break;
                }
                case FIRST: {
                    result.setHitPolicy((JSITHitPolicy)Js.uncheckedCast((Object)JSITHitPolicy.FIRST.value()));
                    break;
                }
                case UNIQUE: {
                    result.setHitPolicy((JSITHitPolicy)Js.uncheckedCast((Object)JSITHitPolicy.UNIQUE.value()));
                    break;
                }
                case PRIORITY: {
                    result.setHitPolicy((JSITHitPolicy)Js.uncheckedCast((Object)JSITHitPolicy.PRIORITY.value()));
                    break;
                }
                case RULE_ORDER: {
                    result.setHitPolicy((JSITHitPolicy)Js.uncheckedCast((Object)JSITHitPolicy.RULE_ORDER.value()));
                    break;
                }
                case OUTPUT_ORDER: {
                    result.setHitPolicy((JSITHitPolicy)Js.uncheckedCast((Object)JSITHitPolicy.OUTPUT_ORDER.value()));
                }
            }
        }
        if (Objects.nonNull(wb.getAggregation())) {
            String wbBuiltinAggregator = wb.getAggregation().value();
            result.setAggregation((JSITBuiltinAggregator)Js.uncheckedCast((Object)wbBuiltinAggregator));
        }
        if (Objects.nonNull(wb.getPreferredOrientation())) {
            String wbPreferredOrientation = wb.getPreferredOrientation().value();
            result.setPreferredOrientation((JSITDecisionTableOrientation)Js.uncheckedCast((Object)wbPreferredOrientation));
        }
        result.setOutputLabel(wb.getOutputLabel());
        return result;
    }
}

