/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.dimensions.GeneralRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DMNExternalLinksToExtensionElements;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.IdPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.InformationItemPrimaryPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.NodeConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationItem;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInputData;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public class InputDataConverter
implements NodeConverter<JSITInputData, InputData> {
    private FactoryManager factoryManager;

    public InputDataConverter(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    @Override
    public Node<View<InputData>, ?> nodeFromDMN(JSITInputData dmn, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        Node node = this.factoryManager.newElement(dmn.getId(), BindableAdapterUtils.getDefinitionId(InputData.class)).asNode();
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        Name name = new Name(dmn.getName());
        InformationItemPrimary informationItem = InformationItemPrimaryPropertyConverter.wbFromDMN(dmn.getVariable(), dmn);
        InputData inputData = new InputData(id, description, name, informationItem, new BackgroundSet(), new FontSet(), new GeneralRectangleDimensionsSet());
        ((View)node.getContent()).setDefinition((Object)inputData);
        if (Objects.nonNull(informationItem)) {
            informationItem.setParent((DMNModelInstrumentedBase)inputData);
        }
        DMNExternalLinksToExtensionElements.loadExternalLinksFromExtensionElements((JSITDRGElement)dmn, (DRGElement)inputData);
        return node;
    }

    @Override
    public JSITInputData dmnFromNode(Node<View<InputData>, ?> node, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        InputData source = (InputData)DefinitionUtils.getElementDefinition(node);
        JSITInputData result = new JSITInputData();
        result.setId(source.getId().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(source.getDescription()));
        description.ifPresent(arg_0 -> ((JSITInputData)result).setDescription(arg_0));
        result.setName(source.getName().getValue());
        JSITInformationItem variable = InformationItemPrimaryPropertyConverter.dmnFromWB(source.getVariable(), (DMNModelInstrumentedBase)source);
        result.setVariable(variable);
        DMNExternalLinksToExtensionElements.loadExternalLinksIntoExtensionElements((DRGElement)source, (JSITDRGElement)result);
        return result;
    }
}

