/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.dimensions.GeneralRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.KnowledgeSourceType;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DMNExternalLinksToExtensionElements;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.HrefBuilder;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.IdPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.NodeConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAuthorityRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElementReference;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeSource;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public class KnowledgeSourceConverter
implements NodeConverter<JSITKnowledgeSource, KnowledgeSource> {
    private FactoryManager factoryManager;

    public KnowledgeSourceConverter(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    @Override
    public Node<View<KnowledgeSource>, ?> nodeFromDMN(JSITKnowledgeSource dmn, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        Node node = this.factoryManager.newElement(dmn.getId(), BindableAdapterUtils.getDefinitionId(KnowledgeSource.class)).asNode();
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        Name name = new Name(dmn.getName());
        KnowledgeSourceType ksType = new KnowledgeSourceType(dmn.getType());
        LocationURI locationURI = new LocationURI(dmn.getLocationURI());
        KnowledgeSource ks = new KnowledgeSource(id, description, name, ksType, locationURI, new BackgroundSet(), new FontSet(), new GeneralRectangleDimensionsSet());
        ((View)node.getContent()).setDefinition((Object)ks);
        DMNExternalLinksToExtensionElements.loadExternalLinksFromExtensionElements((JSITDRGElement)dmn, (DRGElement)ks);
        return node;
    }

    @Override
    public JSITKnowledgeSource dmnFromNode(Node<View<KnowledgeSource>, ?> node, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        KnowledgeSource source = (KnowledgeSource)DefinitionUtils.getElementDefinition(node);
        JSITKnowledgeSource result = new JSITKnowledgeSource();
        result.setId(source.getId().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(source.getDescription()));
        description.ifPresent(arg_0 -> ((JSITKnowledgeSource)result).setDescription(arg_0));
        result.setName(source.getName().getValue());
        result.setType(source.getType().getValue());
        result.setLocationURI(source.getLocationURI().getValue());
        result.setAuthorityRequirement(new ArrayList());
        DMNExternalLinksToExtensionElements.loadExternalLinksIntoExtensionElements((DRGElement)source, (JSITDRGElement)result);
        List inEdges = node.getInEdges();
        for (Edge e : inEdges) {
            JSITDMNElementReference ri;
            JSITAuthorityRequirement iReq;
            View view;
            Node sourceNode = e.getSourceNode();
            if (!(sourceNode.getContent() instanceof View) || !((view = (View)sourceNode.getContent()).getDefinition() instanceof DRGElement)) continue;
            DRGElement drgElement = (DRGElement)view.getDefinition();
            if (drgElement instanceof Decision) {
                iReq = new JSITAuthorityRequirement();
                iReq.setId(e.getUUID());
                ri = new JSITDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredDecision(ri);
                result.addAuthorityRequirement(iReq);
                continue;
            }
            if (drgElement instanceof KnowledgeSource) {
                iReq = new JSITAuthorityRequirement();
                iReq.setId(e.getUUID());
                ri = new JSITDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredAuthority(ri);
                result.addAuthorityRequirement(iReq);
                continue;
            }
            if (drgElement instanceof InputData) {
                iReq = new JSITAuthorityRequirement();
                iReq.setId(e.getUUID());
                ri = new JSITDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredInput(ri);
                result.addAuthorityRequirement(iReq);
                continue;
            }
            throw new UnsupportedOperationException("wrong model definition.");
        }
        return result;
    }
}

