/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.utils;

import java.util.Objects;
import javax.xml.namespace.QName;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.dd.ColorUtils;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.dd.PointUtils;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIBounds;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIColor;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dc.JSIPoint;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.di.JSIStyle;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAssociation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITContext;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecisionTable;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITFunctionDefinition;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInvocation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITList;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITLiteralExpression;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITRelation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITTextAnnotation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDecisionServiceDividerLine;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNEdge;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNLabel;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNShape;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNStyle;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITAttachment;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentsWidthsExtension;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JSIName;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class WrapperUtils {
    public static JSITAssociation getWrappedJSITAssociation(JSITAssociation toWrap) {
        JSITAssociation toReturn = (JSITAssociation)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)toWrap));
        JSIName jsiName = JSITTextAnnotation.getJSIName();
        WrapperUtils.updateJSIName(jsiName, "dmn", "association");
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSITTextAnnotation getWrappedJSITTextAnnotation(JSITTextAnnotation toWrap) {
        JSITTextAnnotation toReturn = (JSITTextAnnotation)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)toWrap));
        JSIName jsiName = JSITTextAnnotation.getJSIName();
        WrapperUtils.updateJSIName(jsiName, "dmn", "textAnnotation");
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSIDMNStyle getWrappedJSIDMNStyle(JSIDMNStyle toWrap) {
        JSIDMNStyle toReturn = (JSIDMNStyle)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)toWrap));
        JSIName jsiName = JSIDMNStyle.getJSIName();
        WrapperUtils.updateJSIName(jsiName, "dmndi", "DMNStyle");
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSITDecisionTable getWrappedJSITDecisionTable(JSITDecisionTable toWrap, String prefix, String localPart) {
        JSITDecisionTable toReturn = (JSITDecisionTable)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)toWrap));
        JSIName jsiName = JSITDecisionTable.getJSIName();
        WrapperUtils.updateJSIName(jsiName, prefix, localPart);
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSITFunctionDefinition getWrappedJSITFunctionDefinition(JSITFunctionDefinition toWrap, String prefix, String localPart) {
        JSITFunctionDefinition toReturn = (JSITFunctionDefinition)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)toWrap));
        JSIName jsiName = JSITFunctionDefinition.getJSIName();
        WrapperUtils.updateJSIName(jsiName, prefix, localPart);
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSITInvocation getWrappedJSITInvocation(JSITInvocation toWrap, String prefix, String localPart) {
        JSITInvocation toReturn = (JSITInvocation)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)toWrap));
        JSIName jsiName = JSITInvocation.getJSIName();
        WrapperUtils.updateJSIName(jsiName, prefix, localPart);
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSITList getWrappedJSITList(JSITList toWrap, String prefix, String localPart) {
        JSITList toReturn = (JSITList)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)toWrap));
        JSIName jsiName = JSITList.getJSIName();
        WrapperUtils.updateJSIName(jsiName, prefix, localPart);
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSITRelation getWrappedJSITRelation(JSITRelation toWrap, String prefix, String localPart) {
        JSITRelation toReturn = (JSITRelation)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)toWrap));
        JSIName jsiName = JSITRelation.getJSIName();
        WrapperUtils.updateJSIName(jsiName, prefix, localPart);
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSITContext getWrappedJSITContext(JSITContext toWrap, String prefix, String localPart) {
        JSITContext toReturn = (JSITContext)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)toWrap));
        JSIName jsiName = JSITContext.getJSIName();
        WrapperUtils.updateJSIName(jsiName, prefix, localPart);
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSITLiteralExpression getWrappedJSITLiteralExpression(JSITLiteralExpression toWrap, String prefix, String localPart) {
        JSITLiteralExpression toReturn = (JSITLiteralExpression)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)toWrap));
        JSIName jsiName = JSITLiteralExpression.getJSIName();
        WrapperUtils.updateJSIName(jsiName, prefix, localPart);
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSIDMNEdge getWrappedJSIDMNEdge(JSIDMNEdge toWrap) {
        JSIDMNEdge toReturn = (JSIDMNEdge)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)toWrap));
        JSIName jsiName = JSIDMNEdge.getJSIName();
        WrapperUtils.updateJSIName(jsiName, "dmndi", "DMNEdge");
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSIDMNShape getWrappedJSIDMNShape(View<? extends DMNElement> v, String namespaceURI) {
        JSIDMNShape unwrappedJSIDMNShape = WrapperUtils.stunnerToDDExt(v, namespaceURI);
        JSIDMNShape toReturn = (JSIDMNShape)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)unwrappedJSIDMNShape));
        JSIName jsiName = JSIDMNShape.getJSIName();
        WrapperUtils.updateJSIName(jsiName, "dmndi", "DMNShape");
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSITAttachment getWrappedJSITAttachment(JSITAttachment attachment) {
        JSITAttachment toReturn = (JSITAttachment)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)attachment));
        JSIName jsiName = JSITAttachment.getJSIName();
        WrapperUtils.updateJSIName(jsiName, "kie", "attachment");
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSITComponentsWidthsExtension getWrappedJSITComponentsWidthsExtension(JSITComponentsWidthsExtension componentsWidthsExtension) {
        JSITComponentsWidthsExtension toReturn = (JSITComponentsWidthsExtension)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)componentsWidthsExtension));
        JSIName jsiName = JSITComponentsWidthsExtension.getJSIName();
        WrapperUtils.updateJSIName(jsiName, "kie", "ComponentsWidthsExtension");
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static JSITDRGElement getWrappedJSITDRGElement(JSITDRGElement toWrap, String prefix, String localPart) {
        JSITDRGElement toReturn = (JSITDRGElement)Js.uncheckedCast((Object)JsUtils.getWrappedElement((Object)toWrap));
        JSIName jsiName = JSITDRGElement.getJSIName();
        WrapperUtils.updateJSIName(jsiName, prefix, localPart);
        JsUtils.setNameOnWrapped((Object)toReturn, (JSIName)jsiName);
        return toReturn;
    }

    public static void updateJSIName(JSIName toUpdate, String prefix, String localPart) {
        toUpdate.setPrefix(prefix);
        toUpdate.setLocalPart(localPart);
        String key = "{" + toUpdate.getNamespaceURI() + "}" + toUpdate.getLocalPart();
        toUpdate.setKey(key);
        prefix = !StringUtils.isEmpty((String)toUpdate.getPrefix()) ? toUpdate.getPrefix() + ":" : "";
        String string = "{" + toUpdate.getNamespaceURI() + "}" + prefix + toUpdate.getLocalPart();
        toUpdate.setString(string);
    }

    private static JSIDMNShape stunnerToDDExt(View<? extends DMNElement> v, String namespaceURI) {
        JSIDMNShape result = new JSIDMNShape();
        result.setId("dmnshape-" + ((DMNElement)v.getDefinition()).getId().getValue());
        result.setDmnElementRef(new QName(namespaceURI, ((DMNElement)v.getDefinition()).getId().getValue(), ""));
        JSIBounds bounds = new JSIBounds();
        result.setBounds(bounds);
        bounds.setX(PointUtils.xOfBound(PointUtils.upperLeftBound(v)));
        bounds.setY(PointUtils.yOfBound(PointUtils.upperLeftBound(v)));
        result.setDMNLabel(new JSIDMNLabel());
        result.setIsCollapsed(false);
        JSIDMNStyle style = new JSIDMNStyle();
        if (v.getDefinition() instanceof Decision) {
            Decision d = (Decision)v.getDefinition();
            WrapperUtils.applyBounds((RectangleDimensionsSet)d.getDimensionsSet(), bounds);
            WrapperUtils.applyBackgroundStyles(d.getBackgroundSet(), style);
            WrapperUtils.applyFontStyle(d.getFontSet(), style);
        } else if (v.getDefinition() instanceof InputData) {
            InputData d = (InputData)v.getDefinition();
            WrapperUtils.applyBounds((RectangleDimensionsSet)d.getDimensionsSet(), bounds);
            WrapperUtils.applyBackgroundStyles(d.getBackgroundSet(), style);
            WrapperUtils.applyFontStyle(d.getFontSet(), style);
        } else if (v.getDefinition() instanceof BusinessKnowledgeModel) {
            BusinessKnowledgeModel d = (BusinessKnowledgeModel)v.getDefinition();
            WrapperUtils.applyBounds((RectangleDimensionsSet)d.getDimensionsSet(), bounds);
            WrapperUtils.applyBackgroundStyles(d.getBackgroundSet(), style);
            WrapperUtils.applyFontStyle(d.getFontSet(), style);
        } else if (v.getDefinition() instanceof KnowledgeSource) {
            KnowledgeSource d = (KnowledgeSource)v.getDefinition();
            WrapperUtils.applyBounds((RectangleDimensionsSet)d.getDimensionsSet(), bounds);
            WrapperUtils.applyBackgroundStyles(d.getBackgroundSet(), style);
            WrapperUtils.applyFontStyle(d.getFontSet(), style);
        } else if (v.getDefinition() instanceof TextAnnotation) {
            TextAnnotation d = (TextAnnotation)v.getDefinition();
            WrapperUtils.applyBounds((RectangleDimensionsSet)d.getDimensionsSet(), bounds);
            WrapperUtils.applyBackgroundStyles(d.getBackgroundSet(), style);
            WrapperUtils.applyFontStyle(d.getFontSet(), style);
        } else if (v.getDefinition() instanceof DecisionService) {
            DecisionService d = (DecisionService)v.getDefinition();
            WrapperUtils.applyBounds((RectangleDimensionsSet)d.getDimensionsSet(), bounds);
            WrapperUtils.applyBackgroundStyles(d.getBackgroundSet(), style);
            WrapperUtils.applyFontStyle(d.getFontSet(), style);
            JSIDMNDecisionServiceDividerLine dl = new JSIDMNDecisionServiceDividerLine();
            JSIPoint leftPoint = new JSIPoint();
            leftPoint.setX(v.getBounds().getUpperLeft().getX().doubleValue());
            double dlY = v.getBounds().getUpperLeft().getY() + d.getDividerLineY().getValue();
            leftPoint.setY(dlY);
            dl.addWaypoint(leftPoint);
            JSIPoint rightPoint = new JSIPoint();
            rightPoint.setX(v.getBounds().getLowerRight().getX().doubleValue());
            rightPoint.setY(dlY);
            dl.addWaypoint(rightPoint);
            result.setDMNDecisionServiceDividerLine(dl);
        }
        result.setStyle((JSIStyle)WrapperUtils.getWrappedJSIDMNStyle(style));
        return result;
    }

    private static void applyFontStyle(FontSet fontSet, JSIDMNStyle style) {
        JSIColor fontColor = ColorUtils.dmnFromWB(fontSet.getFontColour().getValue());
        style.setFontColor(fontColor);
        if (Objects.nonNull(fontSet.getFontFamily().getValue())) {
            style.setFontFamily(fontSet.getFontFamily().getValue());
        }
        if (Objects.nonNull(fontSet.getFontSize().getValue())) {
            style.setFontSize(fontSet.getFontSize().getValue().doubleValue());
        }
    }

    private static void applyBounds(RectangleDimensionsSet dimensionsSet, JSIBounds bounds) {
        if (null != dimensionsSet.getWidth().getValue() && null != dimensionsSet.getHeight().getValue()) {
            bounds.setWidth(dimensionsSet.getWidth().getValue().doubleValue());
            bounds.setHeight(dimensionsSet.getHeight().getValue().doubleValue());
        }
    }

    private static void applyBackgroundStyles(BackgroundSet bgset, JSIDMNStyle style) {
        if (Objects.nonNull(bgset.getBgColour().getValue())) {
            style.setFillColor(ColorUtils.dmnFromWB(bgset.getBgColour().getValue()));
        }
        if (Objects.nonNull(bgset.getBorderColour().getValue())) {
            style.setStrokeColor(ColorUtils.dmnFromWB(bgset.getBorderColour().getValue()));
        }
    }
}

