/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.ContextEntryPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.IdPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.QNamePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITContext;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITContextEntry;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITExpression;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITFunctionDefinition;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;

public class ContextPropertyConverter {
    public static Context wbFromDMN(JSITContext dmn, JSITExpression parent, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        JSITFunctionDefinition functionDefinition;
        String sKind;
        FunctionDefinition.Kind kind;
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        QName typeRef = QNamePropertyConverter.wbFromDMN(dmn.getTypeRef());
        Context result = new Context(id, description, typeRef);
        List jsiContextEntries = dmn.getContextEntry();
        for (int i = 0; i < jsiContextEntries.size(); ++i) {
            JSITContextEntry jsiContextentry = (JSITContextEntry)Js.uncheckedCast(jsiContextEntries.get(i));
            ContextEntry ceConverted = ContextEntryPropertyConverter.wbFromDMN(jsiContextentry, hasComponentWidthsConsumer);
            if (!Objects.nonNull(ceConverted)) continue;
            ceConverted.setParent((DMNModelInstrumentedBase)result);
            result.getContextEntry().add(ceConverted);
        }
        if (JSITFunctionDefinition.instanceOf((Object)parent) && !Objects.equals(FunctionDefinition.Kind.FEEL, kind = FunctionDefinition.Kind.fromValue((String)(sKind = (String)Js.uncheckedCast((Object)(functionDefinition = (JSITFunctionDefinition)Js.uncheckedCast((Object)parent)).getKind()))))) {
            return result;
        }
        int contextEntriesCount = result.getContextEntry().size();
        if (contextEntriesCount == 0) {
            result.getContextEntry().add(new ContextEntry());
        } else if (!Objects.isNull(((ContextEntry)result.getContextEntry().get(contextEntriesCount - 1)).getVariable())) {
            result.getContextEntry().add(new ContextEntry());
        }
        return result;
    }

    public static JSITContext dmnFromWB(Context wb, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        JSITContext result = new JSITContext();
        result.setId(wb.getId().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(wb.getDescription()));
        description.ifPresent(arg_0 -> ((JSITContext)result).setDescription(arg_0));
        QNamePropertyConverter.setDMNfromWB(wb.getTypeRef(), arg_0 -> ((JSITContext)result).setTypeRef(arg_0));
        for (ContextEntry ce : wb.getContextEntry()) {
            JSITContextEntry ceConverted = ContextEntryPropertyConverter.dmnFromWB(ce, componentWidthsConsumer);
            result.addContextEntry(ceConverted);
        }
        int contextEntriesCount = result.getContextEntry().size();
        if (contextEntriesCount > 0 && Objects.isNull(((ContextEntry)wb.getContextEntry().get(contextEntriesCount - 1)).getExpression())) {
            result.removeContextEntry(contextEntriesCount - 1);
        }
        return result;
    }
}

