/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.appformer.kogito.bridge.client.pmmleditor.marshaller.model.PMMLDocumentData;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLModelMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLParameterMetadata;

public class PMMLMarshallerConverter {
    public static final String ACTIVE = "active";

    private PMMLMarshallerConverter() {
    }

    public static PMMLDocumentMetadata fromJSInteropToMetadata(String pmmlFilePath, PMMLDocumentData pmmlDocumentData) {
        ArrayList models = new ArrayList();
        pmmlDocumentData.getModels().stream().forEach(pmmlModelData -> {
            String modelName = pmmlModelData.getModelName();
            Set fields = pmmlModelData.getFields().stream().filter(field -> PMMLMarshallerConverter.isValidInputField(field.getUsageType())).map(field -> new PMMLParameterMetadata(field.getFieldName())).collect(Collectors.toSet());
            models.add(new PMMLModelMetadata(modelName, fields));
        });
        return new PMMLDocumentMetadata(pmmlFilePath, DMNImportTypes.PMML.getDefaultNamespace(), models);
    }

    private static boolean isValidInputField(String usageType) {
        return usageType == null || ACTIVE.equals(usageType);
    }
}

