/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import java.util.Objects;
import org.kie.workbench.common.dmn.api.editors.types.RangeValue;

public class FEELRangeParser {
    private static final String SEPARATOR = "..";
    private static final int SEPARATOR_LENGTH = "..".length();
    private static final String INCLUDE_START = "[";
    private static final String EXCLUDE_START = "(";
    private static final String INCLUDE_END = "]";
    private static final String EXCLUDE_END = ")";

    public static RangeValue parse(String input) {
        if (Objects.isNull(input)) {
            return new RangeValue();
        }
        String trimmedInput = input.trim();
        if (!FEELRangeParser.hasLeadingAndEndingParenthesis(trimmedInput)) {
            return new RangeValue();
        }
        boolean includeStartValue = trimmedInput.startsWith(INCLUDE_START);
        boolean includeEndValue = trimmedInput.endsWith(INCLUDE_END);
        boolean inQuotes = false;
        String startValue = "";
        String endValue = "";
        for (int current = 0; current < trimmedInput.length(); ++current) {
            if (trimmedInput.charAt(current) == '\"') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (!FEELRangeParser.isSeparator(current, inQuotes, trimmedInput)) continue;
            startValue = trimmedInput.substring(1, current).trim();
            endValue = trimmedInput.substring(current + SEPARATOR_LENGTH, trimmedInput.length() - 1).trim();
            if (!FEELRangeParser.isRangeValueValid(startValue) || !FEELRangeParser.isRangeValueValid(endValue)) continue;
            RangeValue rangeValue = new RangeValue();
            rangeValue.setIncludeStartValue(includeStartValue);
            rangeValue.setStartValue(startValue);
            rangeValue.setIncludeEndValue(includeEndValue);
            rangeValue.setEndValue(endValue);
            return rangeValue;
        }
        return new RangeValue();
    }

    private static boolean isSeparator(int current, boolean inQuotes, String trimmedInput) {
        if (inQuotes) {
            return false;
        }
        if (current > trimmedInput.length() - SEPARATOR_LENGTH) {
            return false;
        }
        return trimmedInput.substring(current, current + SEPARATOR_LENGTH).equals(SEPARATOR);
    }

    private static boolean hasLeadingAndEndingParenthesis(String input) {
        if (!input.startsWith(INCLUDE_START) && !input.startsWith(EXCLUDE_START)) {
            return false;
        }
        return input.endsWith(INCLUDE_END) || input.endsWith(EXCLUDE_END);
    }

    private static boolean isRangeValueValid(String input) {
        if (input.length() > 0) {
            return input.charAt(0) != '.' && input.charAt(input.length() - 1) != '.';
        }
        return false;
    }
}

