/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.providers;

import elemental2.dom.DOMRect;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourCustomSelectorPositionProvider;
import org.appformer.kogito.bridge.client.guided.tour.service.api.Rect;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.common.GuidedTourUtils;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.providers.PositionProviderFactory;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;

public class GraphElementsPositionProviderFactory
implements PositionProviderFactory {
    private final DMNGraphUtils dmnGraphUtils;
    private final GuidedTourUtils guidedTourUtils;
    private final Elemental2DomUtil elemental2DomUtil;

    @Inject
    public GraphElementsPositionProviderFactory(DMNGraphUtils dmnGraphUtils, GuidedTourUtils guidedTourUtils, Elemental2DomUtil elemental2DomUtil) {
        this.dmnGraphUtils = dmnGraphUtils;
        this.guidedTourUtils = guidedTourUtils;
        this.elemental2DomUtil = elemental2DomUtil;
    }

    @Override
    public GuidedTourCustomSelectorPositionProvider.PositionProviderFunction createPositionProvider() {
        return selector -> this.getGraphNodes().map(this.guidedTourUtils::asNodeImpl).filter(node -> Objects.equals(this.getName((NodeImpl<View>)node), selector)).findFirst().map(this::calculateNodeRelativePosition).orElse(Rect.NONE());
    }

    private Rect calculateNodeRelativePosition(NodeImpl<View> node) {
        Bounds bounds = ((View)node.getContent()).getBounds();
        Optional<DOMRect> containerRect = this.getContainerRect();
        double canvasLeft = containerRect.map(rect -> rect.left).orElse(0.0);
        double canvasTop = containerRect.map(rect -> rect.top).orElse(0.0);
        int left = (int)(canvasLeft + bounds.getX());
        int top = (int)(canvasTop + bounds.getY());
        int height = (int)bounds.getHeight();
        int width = (int)bounds.getWidth();
        return this.makeRect(left, top, height, width);
    }

    Rect makeRect(int left, int top, int height, int width) {
        Rect rect = new Rect();
        rect.setLeft(left);
        rect.setTop(top);
        rect.setHeight(height);
        rect.setWidth(width);
        rect.setRight(left + width);
        rect.setBottom(top + height);
        return rect;
    }

    private Optional<DOMRect> getContainerRect() {
        Optional<HTMLElement> containerElement = this.getWiresCanvas().map(wiresCanvas -> this.elemental2DomUtil.asHTMLElement((com.google.gwt.dom.client.Element)wiresCanvas.getView().getElement()));
        return containerElement.map(Element::getBoundingClientRect);
    }

    private Optional<WiresCanvas> getWiresCanvas() {
        CanvasHandler canvasHandler = this.getCanvasHandler();
        if (canvasHandler != null && canvasHandler.getCanvas() instanceof WiresCanvas) {
            return Optional.of((WiresCanvas)canvasHandler.getCanvas());
        }
        return Optional.empty();
    }

    private String getName(NodeImpl<View> node) {
        return this.guidedTourUtils.getName(node);
    }

    private CanvasHandler getCanvasHandler() {
        return this.dmnGraphUtils.getCanvasHandler();
    }

    private Stream<Node> getGraphNodes() {
        return this.dmnGraphUtils.getNodeStream();
    }
}

