/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.util;

import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.screens.datamodeller.model.persistence.CachingType;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceUnitModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.Property;
import org.kie.workbench.common.screens.datamodeller.model.persistence.TransactionType;
import org.kie.workbench.common.screens.datamodeller.model.persistence.ValidationMode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DOM2PersistenceDescriptorVisitor {
    PersistenceDescriptorModel descriptorModel;
    Document document;

    public DOM2PersistenceDescriptorVisitor(Document document) {
        this.document = document;
    }

    public PersistenceDescriptorModel visit() {
        this.visitPersistence(this.document.getDocumentElement());
        return this.descriptorModel;
    }

    private void visitPersistence(Element element) {
        this.descriptorModel = new PersistenceDescriptorModel();
        this.descriptorModel.setVersion(element.getAttribute("version"));
        NodeList children = element.getElementsByTagName("persistence-unit");
        if (children != null && children.getLength() > 0) {
            for (int i = 0; i < children.getLength(); ++i) {
                this.visitPersistenceUnit((Element)children.item(i));
            }
        }
    }

    private void visitPersistenceUnit(Element element) {
        PersistenceUnitModel persistenceUnit = new PersistenceUnitModel();
        this.descriptorModel.setPersistenceUnit(persistenceUnit);
        persistenceUnit.setName(element.getAttribute("name"));
        String transactionType = element.getAttribute("transaction-type");
        persistenceUnit.setTransactionType(this.parseTransactionType(transactionType));
        this.visitDescription(persistenceUnit, element.getElementsByTagName("description"));
        this.visitProvider(persistenceUnit, element.getElementsByTagName("provider"));
        this.visitJTADataSource(persistenceUnit, element.getElementsByTagName("jta-data-source"));
        this.visitNonJTADataSource(persistenceUnit, element.getElementsByTagName("non-jta-data-source"));
        this.visitMappingFile(persistenceUnit, element.getElementsByTagName("mapping-file"));
        this.visitJarFile(persistenceUnit, element.getElementsByTagName("jar-file"));
        this.visitClass(persistenceUnit, element.getElementsByTagName("class"));
        this.visitExcludeUnlistedClasses(persistenceUnit, element.getElementsByTagName("exclude-unlisted-classes"));
        this.visitSharedCacheMode(persistenceUnit, element.getElementsByTagName("shared-cache-mode"));
        this.visitValidationMode(persistenceUnit, element.getElementsByTagName("validation-mode"));
        this.visitProperties(persistenceUnit, element.getElementsByTagName("properties"));
    }

    private void visitDescription(PersistenceUnitModel persistenceUnit, NodeList nodes) {
        persistenceUnit.setDescription(this.parseSimpleTextElement(nodes));
    }

    private void visitProvider(PersistenceUnitModel persistenceUnit, NodeList nodes) {
        persistenceUnit.setProvider(this.parseSimpleTextElement(nodes));
    }

    private void visitJTADataSource(PersistenceUnitModel persistenceUnit, NodeList nodes) {
        persistenceUnit.setJtaDataSource(this.parseSimpleTextElement(nodes));
    }

    private void visitNonJTADataSource(PersistenceUnitModel persistenceUnit, NodeList nodes) {
        persistenceUnit.setNonJtaDataSource(this.parseSimpleTextElement(nodes));
    }

    private void visitMappingFile(PersistenceUnitModel persistenceUnit, NodeList nodes) {
        persistenceUnit.setMappingFile(this.parseSimpleTextElementList(nodes));
    }

    private void visitJarFile(PersistenceUnitModel persistenceUnit, NodeList nodes) {
        persistenceUnit.setJarFile(this.parseSimpleTextElementList(nodes));
    }

    private void visitClass(PersistenceUnitModel persistenceUnit, NodeList nodes) {
        persistenceUnit.setClasses(this.parseSimpleTextElementList(nodes));
    }

    private void visitExcludeUnlistedClasses(PersistenceUnitModel persistenceUnit, NodeList nodes) {
        persistenceUnit.setExcludeUnlistedClasses(Boolean.parseBoolean(this.parseSimpleTextElement(nodes)));
    }

    private void visitSharedCacheMode(PersistenceUnitModel persistenceUnit, NodeList nodes) {
        String value = this.parseSimpleTextElement(nodes);
        persistenceUnit.setSharedCacheMode(value != null ? CachingType.valueOf(value) : null);
    }

    private void visitValidationMode(PersistenceUnitModel persistenceUnit, NodeList nodes) {
        String value = this.parseSimpleTextElement(nodes);
        persistenceUnit.setValidationMode(value != null ? ValidationMode.valueOf(value) : null);
    }

    private void visitProperties(PersistenceUnitModel persistenceUnit, NodeList nodes) {
        Element element;
        NodeList propertyNodes;
        ArrayList<Property> properties = new ArrayList<Property>();
        persistenceUnit.setProperties(properties);
        if (nodes != null && nodes.getLength() > 0 && (propertyNodes = (element = (Element)nodes.item(0)).getElementsByTagName("property")) != null && propertyNodes.getLength() > 0) {
            for (int i = 0; i < propertyNodes.getLength(); ++i) {
                this.visitProperty(properties, (Element)propertyNodes.item(i));
            }
        }
    }

    private void visitProperty(List<Property> properties, Element item) {
        Property property = new Property(item.getAttribute("name"), item.getAttribute("value"));
        properties.add(property);
    }

    private List<String> parseSimpleTextElementList(NodeList nodes) {
        ArrayList<String> result = new ArrayList<String>();
        if (nodes != null && nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                result.add(element.getTextContent());
            }
        }
        return result;
    }

    private String parseSimpleTextElement(NodeList nodes) {
        String result = null;
        if (nodes != null && nodes.getLength() > 0) {
            Element element = (Element)nodes.item(0);
            result = element.getTextContent();
        }
        return result;
    }

    private TransactionType parseTransactionType(String value) {
        if (value != null) {
            try {
                return TransactionType.valueOf(value.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

