/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.util;

import java.util.List;
import org.kie.workbench.common.screens.datamodeller.model.persistence.CachingType;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistableDataObject;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceUnitModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.Property;
import org.kie.workbench.common.screens.datamodeller.model.persistence.ValidationMode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PersistenceDescriptor2DOMVisitor {
    Document document;
    PersistenceDescriptorModel descriptorModel;

    public PersistenceDescriptor2DOMVisitor(PersistenceDescriptorModel descriptorModel, Document document) {
        this.descriptorModel = descriptorModel;
        this.document = document;
    }

    public Document visit() {
        Element element = this.document.createElement("persistence");
        element.setAttribute("version", this.descriptorModel.getVersion());
        element.setAttribute("xmlns", "http://java.sun.com/xml/ns/persistence");
        element.setAttribute("xmlns:orm", "http://java.sun.com/xml/ns/persistence/orm");
        element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/persistence http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd http://java.sun.com/xml/ns/persistence/orm http://java.sun.com/xml/ns/persistence/orm_2_0.xsd");
        this.document.appendChild(element);
        if (this.descriptorModel.getPersistenceUnit() != null) {
            this.visitPersistenceUnit(element, this.descriptorModel.getPersistenceUnit());
        }
        return this.document;
    }

    private void visitPersistenceUnit(Element parent, PersistenceUnitModel persistenceUnit) {
        Element persistenceUnitElement = this.document.createElement("persistence-unit");
        parent.appendChild(persistenceUnitElement);
        persistenceUnitElement.setAttribute("name", persistenceUnit.getName());
        if (persistenceUnit.getTransactionType() != null) {
            persistenceUnitElement.setAttribute("transaction-type", persistenceUnit.getTransactionType().name());
        }
        this.visitDescription(persistenceUnitElement, persistenceUnit.getDescription());
        this.visitProvider(persistenceUnitElement, persistenceUnit.getProvider());
        this.visitJTADataSource(persistenceUnitElement, persistenceUnit.getJtaDataSource());
        this.visitNonJTADataSource(persistenceUnitElement, persistenceUnit.getNonJtaDataSource());
        if (persistenceUnit.getMappingFile() != null) {
            for (String mappingFile : persistenceUnit.getMappingFile()) {
                this.visitMappingFile(persistenceUnitElement, mappingFile);
            }
        }
        if (persistenceUnit.getJarFile() != null) {
            for (String jarFile : persistenceUnit.getJarFile()) {
                this.visitJarFile(persistenceUnitElement, jarFile);
            }
        }
        if (persistenceUnit.getClasses() != null) {
            for (PersistableDataObject clazz : persistenceUnit.getClasses()) {
                this.visitClass(persistenceUnitElement, clazz.getValue());
            }
        }
        this.visitExcludeUnlistedClasses(persistenceUnitElement, persistenceUnit.getExcludeUnlistedClasses());
        this.visitSharedChacheMode(persistenceUnitElement, persistenceUnit.getSharedCacheMode());
        this.visitValidationMode(persistenceUnitElement, persistenceUnit.getValidationMode());
        this.visitProperties(persistenceUnitElement, persistenceUnit.getProperties());
    }

    private void visitDescription(Element element, String description) {
        this.createSimpleTextElement(element, "description", description, false);
    }

    private void visitProvider(Element element, String provider) {
        this.createSimpleTextElement(element, "provider", provider, true);
    }

    private void visitJTADataSource(Element element, String jtaDataSource) {
        this.createSimpleTextElement(element, "jta-data-source", jtaDataSource, false);
    }

    private void visitNonJTADataSource(Element element, String nonJtaDataSource) {
        this.createSimpleTextElement(element, "non-jta-data-source", nonJtaDataSource, false);
    }

    private void visitJarFile(Element element, String jarFile) {
        this.createSimpleTextElement(element, "jar-file", jarFile, false);
    }

    private void visitClass(Element element, String clazz) {
        this.createSimpleTextElement(element, "class", clazz, false);
    }

    private void visitExcludeUnlistedClasses(Element element, Boolean excludeUnlistedClasses) {
        this.createSimpleTextElement(element, "exclude-unlisted-classes", excludeUnlistedClasses != null ? excludeUnlistedClasses.toString() : null, false);
    }

    private void visitSharedChacheMode(Element element, CachingType sharedCacheMode) {
        this.createSimpleTextElement(element, "shared-cache-mode", sharedCacheMode != null ? sharedCacheMode.name() : null, false);
    }

    private void visitValidationMode(Element element, ValidationMode validationMode) {
        this.createSimpleTextElement(element, "validation-mode", validationMode != null ? validationMode.name() : null, false);
    }

    private void visitProperties(Element element, List<Property> properties) {
        if (properties != null && properties.size() > 0) {
            Element propertiesElement = this.document.createElement("properties");
            element.appendChild(propertiesElement);
            for (Property property : properties) {
                this.visitProperty(propertiesElement, property);
            }
        }
    }

    private void visitProperty(Element element, Property property) {
        Element propertyElement = this.document.createElement("property");
        element.appendChild(propertyElement);
        propertyElement.setAttribute("name", property.getName());
        propertyElement.setAttribute("value", property.getValue());
    }

    void createSimpleTextElement(Element element, String elementName, String elementValue, boolean includeIfNull) {
        if (elementValue != null || includeIfNull) {
            Element childElement = this.document.createElement(elementName);
            if (elementValue != null) {
                childElement.setTextContent(elementValue);
            }
            element.appendChild(childElement);
        }
    }

    private void visitMappingFile(Element element, String mappingFile) {
        this.createSimpleTextElement(element, "mapping-file", mappingFile, false);
    }
}

