/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.kie.workbench.common.screens.datamodeller.client.util.AnnotationValueHandler;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerValueChangeEvent;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.HasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.PropertyType;

public class DataModelHelper {
    private DataModel dataModel;
    private Map<String, Set<String>> referencedBy = new HashMap<String, Set<String>>(10);
    private Map<String, Set<String>> references = new HashMap<String, Set<String>>(10);
    private Map<String, Set<String>> offspringMap = new HashMap<String, Set<String>>(10);
    private Map<String, String> classNames = new HashMap<String, String>(10);
    private Map<String, String> labelledClassNames = new TreeMap<String, String>();
    Map<String, PropertyType> orderedBaseTypes = new TreeMap<String, PropertyType>();
    Map<String, PropertyType> baseTypesByClassName = new HashMap<String, PropertyType>();
    String contextId;

    public DataModelHelper(String contextId) {
        this.contextId = contextId;
    }

    public Collection<String> getDataObjectReferences(String className) {
        TreeSet<String> c = new TreeSet<String>();
        Set<String> s = this.referencedBy.get(className);
        if (s != null) {
            c.addAll(s);
        }
        if ((s = this.offspringMap.get(className)) != null) {
            c.addAll(s);
        }
        return c;
    }

    public String getObjectLabelByClassName(String className) {
        return this.classNames.get(className);
    }

    public List<String> getClassList() {
        ArrayList<String> l = new ArrayList<String>(this.classNames.size());
        l.addAll(this.classNames.keySet());
        return Collections.unmodifiableList(l);
    }

    public Map<String, String> getLabelledClassMap() {
        return Collections.unmodifiableMap(this.labelledClassNames);
    }

    public Map<String, PropertyType> getOrderedBaseTypes() {
        return this.orderedBaseTypes;
    }

    public void dataModelChanged(DataModelerValueChangeEvent changeEvent) {
        if (changeEvent.isFromContext(this.contextId)) {
            if ("DATA_OBJECT_EDITOR".equalsIgnoreCase(changeEvent.getSource())) {
                if ("name".equals(changeEvent.getValueName())) {
                    this.nameChanged(changeEvent.getCurrentDataObject(), (String)changeEvent.getOldValue(), (String)changeEvent.getNewValue());
                } else if ("packageName".equals(changeEvent.getValueName())) {
                    this.packageChanged(changeEvent.getCurrentDataObject(), (String)changeEvent.getOldValue(), (String)changeEvent.getNewValue());
                }
            }
            this.reset();
        }
    }

    private void nameChanged(DataObject object, String oldName, String newName) {
        this.adjustDataObjects(DataModelerUtils.assembleClassName(object.getPackageName(), oldName), DataModelerUtils.assembleClassName(object.getPackageName(), newName));
    }

    private void packageChanged(DataObject object, String oldPackage, String newPackage) {
        this.adjustDataObjects(DataModelerUtils.assembleClassName(oldPackage, object.getName()), DataModelerUtils.assembleClassName(newPackage, object.getName()));
    }

    private void adjustDataObjects(String oldClassName, String newClassname) {
    }

    public void dataObjectReferenced(String objectClassName, String subjectClassName) {
        this.objectReferenced(objectClassName, subjectClassName);
    }

    public void dataObjectUnReferenced(String objectClassName, String subjectClassName) {
        this.objectUnReferenced(objectClassName, subjectClassName);
    }

    public void dataObjectExtended(String parentClassName, String offspringClassName, Boolean _extends) {
        this.objectExtended(parentClassName, offspringClassName, _extends);
    }

    public void dataObjectDeleted(String objectClassName) {
        this.reset();
    }

    public void dataObjectCreated(String objectClassName) {
        this.reset();
    }

    public void dataObjectSelected(String objectClassName) {
    }

    public void dataObjectUnSelected(String objectClassName) {
    }

    public Boolean isBaseType(String type) {
        return this.baseTypesByClassName.containsKey(type);
    }

    public Boolean isPrimitiveType(String type) {
        PropertyType propertyType = this.baseTypesByClassName.get(type);
        return propertyType != null && propertyType.isPrimitive();
    }

    public Boolean isAssignableFrom(String offspringCandidate, String parentCandidate) {
        boolean candidateHasOffspring;
        if (offspringCandidate == null || offspringCandidate.length() == 0 || parentCandidate == null || parentCandidate.length() == 0 || offspringCandidate.equals(parentCandidate)) {
            return false;
        }
        Set<String> candidatesOffspring = this.offspringMap.get(offspringCandidate);
        boolean bl = candidateHasOffspring = candidatesOffspring != null && candidatesOffspring.size() > 0;
        if (candidateHasOffspring) {
            if (candidatesOffspring.contains(parentCandidate)) {
                return false;
            }
            for (String newOffspringCandidate : candidatesOffspring) {
                if (this.isAssignableFrom(newOffspringCandidate, parentCandidate).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
        this.reset();
    }

    public void setBaseTypes(List<PropertyType> baseTypes) {
        if (baseTypes != null) {
            for (PropertyType type : baseTypes) {
                this.orderedBaseTypes.put(type.getName(), type);
                this.baseTypesByClassName.put(type.getClassName(), type);
            }
        }
    }

    private void reset() {
        this.referencedBy.clear();
        this.references.clear();
        this.classNames.clear();
        this.labelledClassNames.clear();
        this.offspringMap.clear();
        if (this.dataModel != null) {
            for (DataObject extClassName : this.dataModel.getExternalClasses()) {
                this.classNames.put(extClassName.getClassName(), null);
                this.labelledClassNames.put(extClassName.getClassName(), extClassName.getClassName());
            }
            for (DataObject object : this.dataModel.getDataObjects()) {
                String className = object.getClassName();
                this.classNames.put(className, AnnotationValueHandler.getStringValue((HasAnnotations)object, "org.kie.api.definition.type.Label"));
                this.labelledClassNames.put(DataModelerUtils.getDataObjectFullLabel(object), className);
                String superClassName = object.getSuperClassName();
                if (superClassName != null && !"".equals(superClassName)) {
                    this.objectExtended(superClassName, className, true);
                }
                for (ObjectProperty prop : object.getProperties()) {
                    if (prop.isBaseType()) continue;
                    this.objectReferenced(prop.getClassName(), object.getClassName());
                }
            }
        }
    }

    private void objectReferenced(String objectClassName, String subjectClassName) {
        Set<String> refs = this.referencedBy.get(objectClassName);
        if (refs == null) {
            refs = new HashSet<String>();
        }
        refs.add(subjectClassName);
        this.referencedBy.put(objectClassName, refs);
        refs = this.references.get(subjectClassName);
        if (refs == null) {
            refs = new HashSet<String>();
        }
        refs.add(objectClassName);
        this.references.put(subjectClassName, refs);
    }

    private void objectUnReferenced(String objectClassName, String subjectClassName) {
        Set<String> refs = this.referencedBy.get(objectClassName);
        if (refs != null && refs.size() > 0) {
            refs.remove(subjectClassName);
        }
        if ((refs = this.references.get(subjectClassName)) != null && refs.size() > 0) {
            refs.remove(objectClassName);
        }
    }

    private void objectExtended(String parentClassName, String offspringClassName, Boolean _extends) {
        Set<String> _offspring = this.offspringMap.get(parentClassName);
        if (_extends.booleanValue()) {
            if (_offspring != null) {
                _offspring.add(offspringClassName);
            } else {
                _offspring = new HashSet<String>();
                _offspring.add(offspringClassName);
                this.offspringMap.put(parentClassName, _offspring);
            }
        } else if (_offspring != null) {
            if (_offspring.size() > 0) {
                _offspring.remove(offspringClassName);
            }
            if (_offspring.size() == 0) {
                this.offspringMap.remove(parentClassName);
            }
        }
    }
}

