/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.shared.security.KieWorkbenchACL;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.guvnor.messageconsole.events.PublishBaseEvent;
import org.guvnor.messageconsole.events.PublishBatchMessagesEvent;
import org.guvnor.messageconsole.events.SystemMessage;
import org.guvnor.messageconsole.events.UnpublishMessagesEvent;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.Role;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerErrorCallback;
import org.kie.workbench.common.screens.datamodeller.client.context.DataModelerWorkbenchContext;
import org.kie.workbench.common.screens.datamodeller.client.context.DataModelerWorkbenchFocusEvent;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.screens.datamodeller.client.validation.JavaFileNameValidator;
import org.kie.workbench.common.screens.datamodeller.client.validation.ValidatorService;
import org.kie.workbench.common.screens.datamodeller.events.DataModelSaved;
import org.kie.workbench.common.screens.datamodeller.events.DataModelStatusChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectCreatedEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectDeletedEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldCreatedEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldDeletedEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldSelectedEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectSelectedEvent;
import org.kie.workbench.common.screens.datamodeller.model.DataModelerError;
import org.kie.workbench.common.screens.datamodeller.model.EditorModelContent;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.model.TypeInfoResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.screens.javaeditor.client.type.JavaResourceType;
import org.kie.workbench.common.screens.javaeditor.client.widget.EditJavaSourceWidget;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.JavaTypeInfo;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.JavaTypeInfoImpl;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.LockRequiredEvent;
import org.uberfire.client.views.pfly.multipage.PageImpl;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.CopyPopup;
import org.uberfire.ext.editor.commons.client.file.CopyPopupView;
import org.uberfire.ext.editor.commons.client.file.DeletePopup;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.RenamePopup;
import org.uberfire.ext.editor.commons.client.file.RenamePopupView;
import org.uberfire.ext.editor.commons.client.file.SaveOperationService;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="DataModelerEditor", supportedTypes={JavaResourceType.class}, priority=0x7FFFFFFF)
public class DataModelerScreenPresenter
extends KieEditor {
    protected DataModelerScreenView view;
    @Inject
    protected EditJavaSourceWidget javaSourceEditor;
    @Inject
    protected Event<DataModelerEvent> dataModelerEvent;
    @Inject
    protected Event<UnpublishMessagesEvent> unpublishMessagesEvent;
    @Inject
    protected Event<PublishBatchMessagesEvent> publishBatchMessagesEvent;
    @Inject
    protected Event<LockRequiredEvent> lockRequired;
    @Inject
    protected Event<DataModelerWorkbenchFocusEvent> dataModelerFocusEvent;
    @Inject
    protected KieWorkbenchACL kieACL;
    @Inject
    protected Caller<DataModelerService> modelerService;
    @Inject
    protected ValidatorService validatorService;
    @Inject
    protected JavaFileNameValidator javaFileNameValidator;
    @Inject
    protected JavaResourceType resourceType;
    @Inject
    protected DataModelerWorkbenchContext dataModelerWBContext;
    protected DataModelerContext context;
    protected boolean uiStarted = false;
    protected boolean loading = false;
    private boolean loadTypesInfo = false;
    private SessionInfo sessionInfo;
    private String currentMessageType;
    private Integer originalSourceHash = null;
    private boolean sourceEditionEnabled = false;
    private static final int EDITABLE_SOURCE_TAB = 2;
    private static int editorIds = 0;
    private String editorId;

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    @Inject
    public DataModelerScreenPresenter(DataModelerScreenView baseView, SessionInfo sessionInfo) {
        super((KieEditorView)baseView);
        this.view = baseView;
        this.sessionInfo = sessionInfo;
        this.editorId = sessionInfo.getId() + "-" + editorIds++;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.loading = true;
        this.loadTypesInfo = !this.dataModelerWBContext.isTypesInfoLoaded();
        this.context = new DataModelerContext(this.editorId);
        this.setSourceEditionGrant();
        this.init(path, place, (ClientResourceType)this.resourceType);
        this.currentMessageType = "DataModeler" + path.toURI();
        this.cleanSystemMessages(this.getCurrentMessageType());
        this.javaSourceEditor.addChangeHandler(new EditJavaSourceWidget.TextChangeHandler(){

            public void onTextChange() {
                if (DataModelerScreenPresenter.this.context != null) {
                    DataModelerScreenPresenter.this.context.setEditionStatus(DataModelerContext.EditionStatus.SOURCE_CHANGED);
                }
            }
        });
    }

    @OnFocus
    public void onFocus() {
        if (!this.loading && this.context != null) {
            this.view.redraw();
            this.setActiveContext();
            this.showDataModellerDocks();
        }
    }

    private void showDataModellerDocks() {
        this.dataModelerFocusEvent.fire((Object)new DataModelerWorkbenchFocusEvent());
    }

    private void hideDataModellerDocks(@Observes PlaceHiddenEvent event) {
        if (this.context != null && "DataModelerEditor".equals(event.getPlace().getIdentifier()) && this.place != null && this.place.equals(event.getPlace())) {
            this.dataModelerFocusEvent.fire((Object)new DataModelerWorkbenchFocusEvent().lostFocus());
        }
    }

    @OnMayClose
    public boolean onMayClose() {
        if (this.isDirty()) {
            return this.view.confirmClose();
        }
        return true;
    }

    @OnClose
    public void OnClose() {
        this.versionRecordManager.clear();
        this.cleanSystemMessages(this.getCurrentMessageType());
        this.clearContext();
        super.OnClose();
        this.dataModelerWBContext.clearContext();
    }

    private void setActiveContext() {
        this.dataModelerWBContext.setActiveContext(this.context);
        if (this.context.getDataObject() != null && this.context.getObjectProperty() != null) {
            this.refreshTitle(this.context.getDataObject(), this.context.getObjectProperty());
        } else if (this.context.getDataObject() != null) {
            this.refreshTitle(this.context.getDataObject());
        }
    }

    private void onSafeDelete() {
        if (this.context.getEditorModelContent().getOriginalClassName() != null) {
            final String className = this.context.getEditorModelContent().getOriginalClassName();
            ((DataModelerService)this.modelerService.call((RemoteCallback)new RemoteCallback<List<Path>>(){

                public void callback(List<Path> paths) {
                    if (paths != null && paths.size() > 0) {
                        DataModelerScreenPresenter.this.view.showUsagesPopupForDeletion(Constants.INSTANCE.modelEditor_confirm_deletion_of_used_class(className), paths, new Command(){

                            public void execute() {
                                DataModelerScreenPresenter.this.onDelete((Path)DataModelerScreenPresenter.this.versionRecordManager.getPathToLatest());
                            }
                        }, new Command(){

                            public void execute() {
                            }
                        });
                    } else {
                        DataModelerScreenPresenter.this.onDelete((Path)DataModelerScreenPresenter.this.versionRecordManager.getPathToLatest());
                    }
                }
            })).findClassUsages((Path)this.versionRecordManager.getPathToLatest(), className);
        } else {
            this.onDelete((Path)this.versionRecordManager.getPathToLatest());
        }
    }

    private void onDelete(final Path path) {
        DeletePopup popup = new DeletePopup((ParameterizedCommand)new ParameterizedCommand<String>(){

            public void execute(String comment) {
                DataModelerScreenPresenter.this.view.showBusyIndicator(CommonConstants.INSTANCE.Deleting());
                ((DataModelerService)DataModelerScreenPresenter.this.modelerService.call(DataModelerScreenPresenter.this.getDeleteSuccessCallback(), (ErrorCallback)new DataModelerErrorCallback(Constants.INSTANCE.modelEditor_deleting_error()))).delete(path, comment);
            }
        });
        popup.show();
    }

    private void onCopy() {
        final CopyPopupView copyPopupView = CopyPopup.getDefaultView();
        CopyPopup popup = new CopyPopup((Path)this.versionRecordManager.getCurrentPath(), (Validator)this.javaFileNameValidator, new CommandWithFileNameAndCommitMessage(){

            public void execute(FileNameAndCommitMessage details) {
                DataModelerScreenPresenter.this.view.showBusyIndicator(CommonConstants.INSTANCE.Copying());
                ((DataModelerService)DataModelerScreenPresenter.this.modelerService.call(DataModelerScreenPresenter.this.getCopySuccessCallback(copyPopupView), (ErrorCallback)DataModelerScreenPresenter.this.getCopyErrorCallback(copyPopupView))).copy((Path)DataModelerScreenPresenter.this.versionRecordManager.getCurrentPath(), details.getNewFileName(), details.getCommitMessage(), true);
            }
        }, copyPopupView);
        popup.show();
    }

    protected DataModelerErrorCallback getCopyErrorCallback(final CopyPopupView copyPopupView) {
        return new DataModelerErrorCallback(Constants.INSTANCE.modelEditor_copying_error()){

            @Override
            public boolean error(Message message, Throwable throwable) {
                copyPopupView.hide();
                return super.error(message, throwable);
            }
        };
    }

    private void onSafeRename() {
        if (this.context.getEditorModelContent().getOriginalClassName() != null) {
            final String className = this.context.getEditorModelContent().getOriginalClassName();
            ((DataModelerService)this.modelerService.call((RemoteCallback)new RemoteCallback<List<Path>>(){

                public void callback(List<Path> paths) {
                    if (paths != null && paths.size() > 0) {
                        DataModelerScreenPresenter.this.view.showUsagesPopupForRenaming(Constants.INSTANCE.modelEditor_confirm_renaming_of_used_class(className), paths, new Command(){

                            public void execute() {
                                DataModelerScreenPresenter.this.rename();
                            }
                        }, new Command(){

                            public void execute() {
                            }
                        });
                    } else {
                        DataModelerScreenPresenter.this.rename();
                    }
                }
            })).findClassUsages((Path)this.versionRecordManager.getPathToLatest(), className);
        } else {
            this.rename();
        }
    }

    protected void rename() {
        if (this.isDirty()) {
            this.view.showYesNoCancelPopup(org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.Information(), Constants.INSTANCE.modelEditor_confirm_save_before_rename(), new Command(){

                public void execute() {
                    DataModelerScreenPresenter.this.rename(true);
                }
            }, new Command(){

                public void execute() {
                    DataModelerScreenPresenter.this.rename(false);
                }
            });
        } else {
            this.rename(false);
        }
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                DataObject[] modifiedDataObject = new DataObject[1];
                if (DataModelerScreenPresenter.this.isDirty()) {
                    modifiedDataObject[0] = DataModelerScreenPresenter.this.context.isEditorChanged() ? DataModelerScreenPresenter.this.context.getDataObject() : null;
                }
                ((DataModelerService)DataModelerScreenPresenter.this.modelerService.call((RemoteCallback)new RemoteCallback<List<ValidationMessage>>(){

                    public void callback(List<ValidationMessage> results) {
                        if (results == null || results.isEmpty()) {
                            DataModelerScreenPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                        } else {
                            ValidationPopup.showMessages(results);
                        }
                    }
                }, (ErrorCallback)new DefaultErrorCallback())).validate(DataModelerScreenPresenter.this.getSource(), (Path)DataModelerScreenPresenter.this.versionRecordManager.getCurrentPath(), modifiedDataObject[0]);
            }
        };
    }

    private boolean isDirty() {
        return this.isDataObjectDirty() || this.isSourceDirty();
    }

    private boolean isDataObjectDirty() {
        return this.isDirty(this.context.getDataObject() != null ? Integer.valueOf(this.context.getDataObject().hashCode()) : null);
    }

    private boolean isSourceDirty() {
        return this.originalSourceHash != null && this.originalSourceHash.intValue() != this.getSource().hashCode();
    }

    private RemoteCallback<Path> getCopySuccessCallback(final CopyPopupView copyPopupView) {
        return new RemoteCallback<Path>(){

            public void callback(Path response) {
                copyPopupView.hide();
                DataModelerScreenPresenter.this.view.hideBusyIndicator();
                DataModelerScreenPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemCopiedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
            }
        };
    }

    private RemoteCallback<Path> getDeleteSuccessCallback() {
        return new RemoteCallback<Path>(){

            public void callback(Path response) {
                DataModelerScreenPresenter.this.view.hideBusyIndicator();
                DataModelerScreenPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemDeletedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
            }
        };
    }

    private RemoteCallback<Path> getRenameSuccessCallback(final RenamePopupView renamePopupView) {
        return new RemoteCallback<Path>(){

            public void callback(Path targetPath) {
                renamePopupView.hide();
                DataModelerScreenPresenter.this.view.hideBusyIndicator();
                DataModelerScreenPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemRenamedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
            }
        };
    }

    protected void save() {
        final JavaTypeInfoImpl newTypeInfo = new JavaTypeInfoImpl();
        if (this.isDirty()) {
            if (this.context.isEditorChanged()) {
                newTypeInfo.setPackageName(this.context.getDataObject().getPackageName());
                newTypeInfo.setName(this.context.getDataObject().getName());
                this.saveFile((JavaTypeInfo)newTypeInfo);
            } else {
                this.view.showLoading();
                ((DataModelerService)this.modelerService.call((RemoteCallback)new RemoteCallback<TypeInfoResult>(){

                    public void callback(TypeInfoResult typeInfoResult) {
                        DataModelerScreenPresenter.this.view.hideBusyIndicator();
                        if (!typeInfoResult.hasErrors() && typeInfoResult.getJavaTypeInfo() != null) {
                            newTypeInfo.setPackageName(typeInfoResult.getJavaTypeInfo().getPackageName());
                            newTypeInfo.setName(typeInfoResult.getJavaTypeInfo().getName());
                            DataModelerScreenPresenter.this.saveFile((JavaTypeInfo)newTypeInfo);
                        } else {
                            DataModelerScreenPresenter.this.saveFile(null);
                        }
                    }
                })).loadJavaTypeInfo(this.getSource());
            }
        } else {
            this.saveFile(null);
        }
    }

    private void saveFile(final JavaTypeInfo newTypeInfo) {
        String currentFileName = DataModelerUtils.extractSimpleFileName((Path)this.versionRecordManager.getPathToLatest());
        if (this.hasPackageNameChanged(newTypeInfo)) {
            this.view.showYesNoCancelPopup(org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.Information(), Constants.INSTANCE.modelEditor_confirm_file_package_refactoring(newTypeInfo.getPackageName()), new Command(){

                public void execute() {
                    DataModelerScreenPresenter.this.saveOperationService.save((Path)DataModelerScreenPresenter.this.versionRecordManager.getPathToLatest(), DataModelerScreenPresenter.this.getSaveCommand(newTypeInfo, (Path)DataModelerScreenPresenter.this.versionRecordManager.getPathToLatest()));
                }
            }, Constants.INSTANCE.modelEditor_action_yes_refactor_directory(), ButtonType.PRIMARY, new Command(){

                public void execute() {
                    DataModelerScreenPresenter.this.saveOperationService.save((Path)DataModelerScreenPresenter.this.versionRecordManager.getPathToLatest(), DataModelerScreenPresenter.this.getSaveCommand((Path)DataModelerScreenPresenter.this.versionRecordManager.getPathToLatest()));
                }
            }, Constants.INSTANCE.modelEditor_action_no_dont_refactor_directory(), ButtonType.DANGER);
        } else if (this.hasFileNameChanged(newTypeInfo, currentFileName)) {
            this.view.showYesNoCancelPopup(org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.Information(), Constants.INSTANCE.modelEditor_confirm_file_name_refactoring(newTypeInfo.getName()), new Command(){

                public void execute() {
                    DataModelerScreenPresenter.this.saveOperationService.save((Path)DataModelerScreenPresenter.this.versionRecordManager.getPathToLatest(), DataModelerScreenPresenter.this.getSaveCommand(newTypeInfo, (Path)DataModelerScreenPresenter.this.versionRecordManager.getPathToLatest()));
                }
            }, Constants.INSTANCE.modelEditor_action_yes_refactor_file_name(), ButtonType.PRIMARY, new Command(){

                public void execute() {
                    DataModelerScreenPresenter.this.saveOperationService.save((Path)DataModelerScreenPresenter.this.versionRecordManager.getPathToLatest(), DataModelerScreenPresenter.this.getSaveCommand((Path)DataModelerScreenPresenter.this.versionRecordManager.getPathToLatest()));
                }
            }, Constants.INSTANCE.modelEditor_action_no_dont_refactor_file_name(), ButtonType.DANGER);
        } else {
            new SaveOperationService().save((Path)this.versionRecordManager.getPathToLatest(), this.getSaveCommand((Path)this.versionRecordManager.getPathToLatest()));
        }
    }

    private boolean hasFileNameChanged(JavaTypeInfo newTypeInfo, String currentFileName) {
        return currentFileName != null && newTypeInfo != null && newTypeInfo.getName() != null && !currentFileName.equals(newTypeInfo.getName());
    }

    private boolean hasPackageNameChanged(JavaTypeInfo newTypeInfo) {
        return newTypeInfo != null && newTypeInfo.getPackageName() != null && !newTypeInfo.getPackageName().equals(this.context.getEditorModelContent().getOriginalPackageName());
    }

    private ParameterizedCommand<String> getSaveCommand(Path path) {
        return this.getSaveCommand(null, path);
    }

    private ParameterizedCommand<String> getSaveCommand(final JavaTypeInfo newTypeInfo, final Path path) {
        return new ParameterizedCommand<String>(){

            public void execute(String commitMessage) {
                DataObject[] modifiedDataObject = new DataObject[1];
                if (DataModelerScreenPresenter.this.isDirty()) {
                    modifiedDataObject[0] = DataModelerScreenPresenter.this.context.isEditorChanged() ? DataModelerScreenPresenter.this.context.getDataObject() : null;
                }
                DataModelerScreenPresenter.this.view.showSaving();
                if (newTypeInfo != null) {
                    ((DataModelerService)DataModelerScreenPresenter.this.modelerService.call(DataModelerScreenPresenter.this.getSaveSuccessCallback(newTypeInfo, path), (ErrorCallback)new DataModelerErrorCallback(Constants.INSTANCE.modelEditor_saving_error()))).saveSource(DataModelerScreenPresenter.this.getSource(), path, modifiedDataObject[0], DataModelerScreenPresenter.this.metadata, commitMessage, newTypeInfo.getPackageName(), newTypeInfo.getName());
                } else {
                    ((DataModelerService)DataModelerScreenPresenter.this.modelerService.call(DataModelerScreenPresenter.this.getSaveSuccessCallback(newTypeInfo, path), (ErrorCallback)new DataModelerErrorCallback(Constants.INSTANCE.modelEditor_saving_error()))).saveSource(DataModelerScreenPresenter.this.getSource(), path, modifiedDataObject[0], DataModelerScreenPresenter.this.metadata, commitMessage);
                }
            }
        };
    }

    private RemoteCallback<GenerationResult> getSaveSuccessCallback(final JavaTypeInfo newTypeInfo, final Path currentPath) {
        return new RemoteCallback<GenerationResult>(){

            public void callback(GenerationResult result) {
                DataModelerScreenPresenter.this.view.hideBusyIndicator();
                if (newTypeInfo == null) {
                    Boolean oldDirtyStatus = DataModelerScreenPresenter.this.isDirty();
                    if (result.hasErrors()) {
                        DataModelerScreenPresenter.this.context.setParseStatus(DataModelerContext.ParseStatus.PARSE_ERRORS);
                        DataModelerScreenPresenter.this.updateEditorView(null);
                        DataModelerScreenPresenter.this.context.setDataObject(null);
                        if (DataModelerScreenPresenter.this.isEditorTabSelected()) {
                            DataModelerScreenPresenter.this.showParseErrorsDialog(Constants.INSTANCE.modelEditor_message_file_parsing_errors(), true, result.getErrors(), DataModelerScreenPresenter.this.getOnSaveParseErrorCommand());
                        }
                    } else {
                        DataModelerScreenPresenter.this.context.setParseStatus(DataModelerContext.ParseStatus.PARSED);
                        if (DataModelerScreenPresenter.this.context.isSourceChanged()) {
                            DataModelerScreenPresenter.this.updateEditorView(result.getDataObject());
                            DataModelerScreenPresenter.this.context.setDataObject(result.getDataObject());
                        }
                        DataModelerScreenPresenter.this.cleanSystemMessages(DataModelerScreenPresenter.this.getCurrentMessageType());
                    }
                    DataModelerScreenPresenter.this.setSource(result.getSource());
                    DataModelerScreenPresenter.this.context.setEditionStatus(DataModelerContext.EditionStatus.NO_CHANGES);
                    DataModelerScreenPresenter.this.setOriginalHash(DataModelerScreenPresenter.this.context.getDataObject() != null ? Integer.valueOf(DataModelerScreenPresenter.this.context.getDataObject().hashCode()) : null);
                    DataModelerScreenPresenter.this.originalSourceHash = DataModelerScreenPresenter.this.getSource().hashCode();
                    DataModelerScreenPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemSavedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                    DataModelerScreenPresenter.this.dataModelerEvent.fire((Object)new DataModelStatusChangeEvent(DataModelerScreenPresenter.this.context.getContextId(), "DATA_MODEL_BROWSER", oldDirtyStatus.booleanValue(), false));
                    DataModelerScreenPresenter.this.dataModelerEvent.fire((Object)new DataModelSaved(DataModelerScreenPresenter.this.context.getContextId(), null));
                    DataModelerScreenPresenter.this.versionRecordManager.reloadVersions(currentPath);
                } else {
                    DataModelerScreenPresenter.this.notification.fire((Object)new NotificationEvent(org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants.INSTANCE.ItemRenamedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                }
            }
        };
    }

    protected void loadContent() {
        ((DataModelerService)this.modelerService.call(this.getLoadModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath(), this.loadTypesInfo);
    }

    private RemoteCallback<EditorModelContent> getLoadModelSuccessCallback() {
        return new RemoteCallback<EditorModelContent>(){

            public void callback(EditorModelContent content) {
                if (DataModelerScreenPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                DataModelerScreenPresenter.this.uiStarted = false;
                DataModelerScreenPresenter.this.resetEditorPages(content.getOverview());
                DataModelerScreenPresenter.this.addSourceEditorPage();
                DataModelerScreenPresenter.this.uiStarted = true;
                DataModelerScreenPresenter.this.initContext(content);
                DataModelerScreenPresenter.this.javaSourceEditor.setReadonly(DataModelerScreenPresenter.this.isReadOnly || !DataModelerScreenPresenter.this.sourceEditionEnabled);
                DataModelerScreenPresenter.this.javaSourceEditor.setContent(content.getSource());
                DataModelerScreenPresenter.this.view.hideBusyIndicator();
                if (content.hasErrors()) {
                    DataModelerScreenPresenter.this.publishSystemMessages(DataModelerScreenPresenter.this.getCurrentMessageType(), true, content.getErrors());
                }
                if (content.getDataObject() != null) {
                    DataModelerScreenPresenter.this.selectEditorTab();
                } else {
                    DataModelerScreenPresenter.this.showParseErrorsDialog(Constants.INSTANCE.modelEditor_message_file_parsing_errors(), false, DataModelerScreenPresenter.this.context.getEditorModelContent().getErrors(), DataModelerScreenPresenter.this.getOnLoadParseErrorCommand());
                }
                DataModelerScreenPresenter.this.showDataModellerDocks();
                DataModelerScreenPresenter.this.setOriginalHash(DataModelerScreenPresenter.this.context.getDataObject() != null ? Integer.valueOf(DataModelerScreenPresenter.this.context.getDataObject().hashCode()) : null);
                DataModelerScreenPresenter.this.originalSourceHash = DataModelerScreenPresenter.this.getSource().hashCode();
                DataModelerScreenPresenter.this.loading = false;
            }
        };
    }

    protected Command getOnLoadParseErrorCommand() {
        return new Command(){

            public void execute() {
                DataModelerScreenPresenter.this.selectSourceTab();
            }
        };
    }

    protected Command getOnSaveParseErrorCommand() {
        return new Command(){

            public void execute() {
                DataModelerScreenPresenter.this.selectSourceTab();
            }
        };
    }

    protected Command getOnSourceParseErrorCommand() {
        return new Command(){

            public void execute() {
                DataModelerScreenPresenter.this.selectSourceTab();
            }
        };
    }

    protected Command getOnEditorTabSelectedWithParseErrorCommand() {
        return new Command(){

            public void execute() {
                DataModelerScreenPresenter.this.selectSourceTab();
            }
        };
    }

    protected void selectSourceTab() {
        this.setSelectedTab(2);
    }

    private void addSourceEditorPage() {
        this.addPage((Page)new PageImpl((IsWidget)this.javaSourceEditor, CommonConstants.INSTANCE.SourceTabTitle()){

            public void onFocus() {
                if (DataModelerScreenPresenter.this.uiStarted) {
                    DataModelerScreenPresenter.this.onSourceTabSelected();
                }
            }

            public void onLostFocus() {
            }
        });
    }

    private void rename(final boolean saveCurrentChanges) {
        final DataObject[] modifiedDataObject = new DataObject[1];
        if (saveCurrentChanges && this.isDirty()) {
            modifiedDataObject[0] = this.context.isEditorChanged() ? this.context.getDataObject() : null;
        }
        final RenamePopupView renamePopupView = RenamePopup.getDefaultView();
        RenamePopup popup = new RenamePopup((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.javaFileNameValidator, new CommandWithFileNameAndCommitMessage(){

            public void execute(FileNameAndCommitMessage details) {
                DataModelerScreenPresenter.this.view.showBusyIndicator(CommonConstants.INSTANCE.Renaming());
                ((DataModelerService)DataModelerScreenPresenter.this.modelerService.call(DataModelerScreenPresenter.this.getRenameSuccessCallback(renamePopupView), (ErrorCallback)DataModelerScreenPresenter.this.getRenameErrorCallback(renamePopupView))).rename((Path)DataModelerScreenPresenter.this.versionRecordManager.getPathToLatest(), details.getNewFileName(), details.getCommitMessage(), true, saveCurrentChanges, DataModelerScreenPresenter.this.getSource(), modifiedDataObject[0], DataModelerScreenPresenter.this.metadata);
            }
        }, renamePopupView);
        popup.show();
    }

    protected DataModelerErrorCallback getRenameErrorCallback(final RenamePopupView renamePopupView) {
        return new DataModelerErrorCallback(Constants.INSTANCE.modelEditor_renaming_error()){

            @Override
            public boolean error(Message message, Throwable throwable) {
                renamePopupView.hide();
                return super.error(message, throwable);
            }
        };
    }

    public DataModel getDataModel() {
        return this.context.getDataModel();
    }

    public String getSource() {
        return this.javaSourceEditor.getContent();
    }

    public void setSource(String source) {
        this.javaSourceEditor.setContent(source);
        this.context.getEditorModelContent().setSource(source);
    }

    private void setSourceEditionGrant() {
        Set grantedRoles = this.kieACL.getGrantedRoles("wb_data_modeler_edit_sources");
        this.sourceEditionEnabled = false;
        if (this.sessionInfo != null && this.sessionInfo.getIdentity() != null && this.sessionInfo.getIdentity().getRoles() != null) {
            for (Role role : this.sessionInfo.getIdentity().getRoles()) {
                if (!grantedRoles.contains(role.getName())) continue;
                this.sourceEditionEnabled = true;
                break;
            }
        }
    }

    private void initContext(EditorModelContent content) {
        if (this.loadTypesInfo) {
            this.dataModelerWBContext.setAnnotationDefinitions(content.getAnnotationDefinitions());
            this.dataModelerWBContext.setPropertyTypes(content.getPropertyTypes());
        }
        this.context.setReadonly(this.isReadOnly);
        this.context.setEditorModelContent(content);
        this.context.setAnnotationDefinitions(this.dataModelerWBContext.getAnnotationDefinitions());
        this.context.init(this.dataModelerWBContext.getPropertyTypes());
        this.context.setEditionStatus(DataModelerContext.EditionStatus.NO_CHANGES);
        if (content.getDataObject() != null) {
            this.context.setParseStatus(DataModelerContext.ParseStatus.PARSED);
            this.context.setEditionMode(DataModelerContext.EditionMode.GRAPHICAL_MODE);
        } else {
            this.context.setParseStatus(DataModelerContext.ParseStatus.PARSE_ERRORS);
            this.context.setEditionMode(DataModelerContext.EditionMode.SOURCE_MODE);
        }
    }

    public void onSourceTabSelected() {
        this.context.setEditionMode(DataModelerContext.EditionMode.SOURCE_MODE);
        if (this.context.isParsed() && this.context.isEditorChanged()) {
            this.view.showLoading();
            ((DataModelerService)this.modelerService.call((RemoteCallback)new RemoteCallback<GenerationResult>(){

                public void callback(GenerationResult result) {
                    DataModelerScreenPresenter.this.view.hideBusyIndicator();
                    DataModelerScreenPresenter.this.setSource(result.getSource());
                    DataModelerScreenPresenter.this.updateSource(result.getSource());
                    DataModelerScreenPresenter.this.context.setEditionStatus(DataModelerContext.EditionStatus.NO_CHANGES);
                    DataModelerScreenPresenter.this.setActiveContext();
                }
            }, (ErrorCallback)new DataModelerErrorCallback(Constants.INSTANCE.modelEditor_loading_error()))).updateSource(this.getSource(), (Path)this.versionRecordManager.getCurrentPath(), this.context.getDataObject());
        } else {
            if (!this.isOverviewTabSelected()) {
                this.context.setEditionStatus(DataModelerContext.EditionStatus.NO_CHANGES);
            }
            this.updateSource(this.javaSourceEditor.getContent());
            this.setActiveContext();
        }
    }

    public void onOverviewSelected() {
        this.context.setEditionMode(DataModelerContext.EditionMode.SOURCE_MODE);
        this.setActiveContext();
    }

    protected void updateSource(String source) {
        this.setSource(source);
    }

    private void updateEditorView(DataObject dataObject) {
        if (this.context.getDataObject() != null) {
            this.context.getDataModel().removeDataObject(this.context.getDataObject().getClassName());
        }
        if (dataObject != null) {
            this.context.getDataModel().removeDataObject(dataObject.getClassName());
            this.context.getDataModel().addDataObject(dataObject);
        }
    }

    public void onEditTabSelected() {
        if (!this.uiStarted) {
            return;
        }
        boolean doParsing = false;
        if (this.context.isSourceChanged()) {
            doParsing = true;
        } else if (this.context.isNotParsed()) {
            doParsing = true;
        }
        if (doParsing) {
            this.view.showLoading();
            ((DataModelerService)this.modelerService.call((RemoteCallback)new RemoteCallback<GenerationResult>(){

                public void callback(GenerationResult result) {
                    DataModelerScreenPresenter.this.view.hideBusyIndicator();
                    if (result.hasErrors()) {
                        DataModelerScreenPresenter.this.context.setParseStatus(DataModelerContext.ParseStatus.PARSE_ERRORS);
                        DataModelerScreenPresenter.this.context.setEditionMode(DataModelerContext.EditionMode.SOURCE_MODE);
                        DataModelerScreenPresenter.this.updateEditorView(null);
                        DataModelerScreenPresenter.this.context.setDataObject(null);
                        DataModelerScreenPresenter.this.showParseErrorsDialog(Constants.INSTANCE.modelEditor_message_file_parsing_errors(), true, result.getErrors(), DataModelerScreenPresenter.this.getOnSourceParseErrorCommand());
                    } else {
                        DataModelerScreenPresenter.this.context.setParseStatus(DataModelerContext.ParseStatus.PARSED);
                        DataModelerScreenPresenter.this.updateEditorView(result.getDataObject());
                        DataModelerScreenPresenter.this.context.setEditionStatus(DataModelerContext.EditionStatus.NO_CHANGES);
                        DataModelerScreenPresenter.this.context.setDataObject(result.getDataObject());
                        DataModelerScreenPresenter.this.context.setObjectProperty(null);
                        DataModelerScreenPresenter.this.context.setEditionMode(DataModelerContext.EditionMode.GRAPHICAL_MODE);
                        DataModelerScreenPresenter.this.view.setContext(DataModelerScreenPresenter.this.context);
                        DataModelerScreenPresenter.this.cleanSystemMessages(DataModelerScreenPresenter.this.getCurrentMessageType());
                        DataModelerScreenPresenter.this.setActiveContext();
                    }
                }
            }, (ErrorCallback)new DataModelerErrorCallback(Constants.INSTANCE.modelEditor_loading_error()))).updateDataObject(this.context.getDataObject(), this.getSource(), (Path)this.versionRecordManager.getCurrentPath());
        } else {
            if (!this.isOverviewTabSelected()) {
                this.context.setEditionStatus(DataModelerContext.EditionStatus.NO_CHANGES);
            }
            if (this.context.isParseErrors()) {
                this.showParseErrorsDialog(Constants.INSTANCE.modelEditor_message_file_parsing_errors(), false, null, this.getOnEditorTabSelectedWithParseErrorCommand());
            } else {
                this.context.setEditionMode(DataModelerContext.EditionMode.GRAPHICAL_MODE);
                this.view.setContext(this.context);
                this.setActiveContext();
            }
        }
    }

    private void showParseErrorsDialog(String message, boolean publishErrors, List<DataModelerError> errors, Command command) {
        if (publishErrors && errors != null && !errors.isEmpty()) {
            this.publishSystemMessages(this.getCurrentMessageType(), true, errors);
        }
        this.view.showParseErrorsDialog(org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.Information(), message, command);
    }

    private void onDataObjectDeleted(@Observes DataObjectDeletedEvent event) {
        if (this.context != null && event.isFrom((Project)this.context.getCurrentProject()) && event.getCurrentDataObject() != null && this.context.isParsed() && this.isEditorTabSelected() && this.context.getDataObject() != null && !this.context.getDataObject().getClassName().equals(event.getCurrentDataObject().getClassName())) {
            if (this.validatorService.isReferencedByCurrentObject(event.getCurrentDataObject(), this.context.getDataObject())) {
                this.notification.fire((Object)new NotificationEvent(Constants.INSTANCE.modelEditor_notification_dataObject_referenced_has_been_deleted(event.getCurrentDataObject().getClassName(), this.context.getDataObject().getClassName())));
            } else if (!this.getDataModel().isExternal(event.getCurrentDataObject().getClassName())) {
                this.getDataModel().removeDataObject(event.getCurrentDataObject().getClassName());
                this.view.refreshTypeLists(true);
            }
        }
    }

    private void onDataObjectCreated(@Observes DataObjectCreatedEvent event) {
        if (this.context != null && event.isFrom((Project)this.context.getCurrentProject()) && event.getCurrentDataObject() != null && this.getDataModel() != null && this.getDataModel().getDataObject(event.getCurrentDataObject().getClassName()) == null) {
            this.getDataModel().addDataObject(event.getCurrentDataObject());
            this.view.refreshTypeLists(true);
        }
    }

    private void onDataObjectFieldChangeEvent(@Observes DataObjectFieldChangeEvent event) {
        if (this.isFromThisContext((DataModelerEvent)event)) {
            this.notifyLock();
            this.refreshTitle(event.getCurrentDataObject(), event.getCurrentField());
            this.updateChangeStatus((DataModelerEvent)event);
        }
    }

    private void onDataObjectFieldDeleted(@Observes DataObjectFieldDeletedEvent event) {
        if (this.isFromThisContext((DataModelerEvent)event)) {
            this.updateChangeStatus((DataModelerEvent)event);
        }
    }

    protected void onDataObjectChangeEvent(@Observes DataObjectChangeEvent event) {
        if (this.isFromThisContext((DataModelerEvent)event)) {
            this.notifyLock();
            this.refreshTitle(event.getCurrentDataObject());
            this.updateChangeStatus((DataModelerEvent)event);
        }
    }

    private void onDataObjectFieldCreated(@Observes DataObjectFieldCreatedEvent event) {
        if (this.isFromThisContext((DataModelerEvent)event)) {
            this.updateChangeStatus((DataModelerEvent)event);
        }
    }

    protected void onDataObjectSelectedEvent(@Observes DataObjectSelectedEvent event) {
        if (this.isFromThisContext((DataModelerEvent)event)) {
            this.refreshTitle(event.getCurrentDataObject());
        }
    }

    protected void onDataObjectFieldSelectedEvent(@Observes DataObjectFieldSelectedEvent event) {
        if (this.isFromThisContext((DataModelerEvent)event)) {
            this.refreshTitle(event.getCurrentDataObject(), event.getCurrentField());
        }
    }

    private void notifyLock() {
        this.lockRequired.fire((Object)new LockRequiredEvent());
    }

    private void cleanSystemMessages(String currentMessageType) {
        UnpublishMessagesEvent unpublishMessage = new UnpublishMessagesEvent();
        unpublishMessage.setShowSystemConsole(false);
        unpublishMessage.setMessageType(currentMessageType);
        unpublishMessage.setUserId(this.sessionInfo != null && this.sessionInfo.getIdentity() != null ? this.sessionInfo.getIdentity().getIdentifier() : null);
        this.unpublishMessagesEvent.fire((Object)unpublishMessage);
    }

    private void publishSystemMessages(String messageType, boolean cleanExisting, List<DataModelerError> errors) {
        PublishBatchMessagesEvent publishMessage = new PublishBatchMessagesEvent();
        publishMessage.setCleanExisting(cleanExisting);
        publishMessage.setMessageType(messageType);
        publishMessage.setUserId(this.sessionInfo != null && this.sessionInfo.getIdentity() != null ? this.sessionInfo.getIdentity().getIdentifier() : null);
        publishMessage.setPlace(PublishBaseEvent.Place.TOP);
        for (DataModelerError error : errors) {
            SystemMessage systemMessage = new SystemMessage();
            systemMessage.setMessageType(messageType);
            systemMessage.setId(error.getId());
            systemMessage.setText(error.getMessage());
            systemMessage.setPath(error.getFile());
            systemMessage.setLevel(error.getLevel());
            systemMessage.setLine(error.getLine());
            systemMessage.setColumn(error.getColumn());
            publishMessage.getMessagesToPublish().add(systemMessage);
        }
        this.publishBatchMessagesEvent.fire((Object)publishMessage);
    }

    protected void makeMenuBar() {
        this.menuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(new Command(){

            public void execute() {
                DataModelerScreenPresenter.this.onSave();
            }
        })).addCopy(new Command(){

            public void execute() {
                DataModelerScreenPresenter.this.onCopy();
            }
        }).addRename(new Command(){

            public void execute() {
                DataModelerScreenPresenter.this.onSafeRename();
            }
        }).addDelete(new Command(){

            public void execute() {
                DataModelerScreenPresenter.this.onSafeDelete();
            }
        }).addValidate(this.onValidate()).addNewTopLevelMenu(this.versionRecordManager.buildMenu());
        this.menus = this.menuBuilder.build();
    }

    private void clearContext() {
        this.context.clear();
    }

    private String getCurrentMessageType() {
        return this.currentMessageType;
    }

    private boolean isFromThisContext(DataModelerEvent event) {
        return event.isFromContext(this.context != null ? this.context.getContextId() : null);
    }

    private void refreshTitle(DataObject dataObject) {
        if (dataObject != null) {
            String label = DataModelerUtils.getDataObjectFullLabel(dataObject, false);
            String title = "'" + label + "'" + Constants.INSTANCE.modelEditor_general_properties_label();
            String tooltip = dataObject.getClassName();
            this.view.setDomainContainerTitle(title, tooltip);
        }
    }

    private void refreshTitle(DataObject dataObject, ObjectProperty objectProperty) {
        if (dataObject != null && objectProperty != null) {
            String title = "'" + objectProperty.getName() + "'" + Constants.INSTANCE.modelEditor_general_properties_label();
            String tooltip = dataObject.getClassName() + "." + objectProperty.getName();
            this.view.setDomainContainerTitle(title, tooltip);
        }
    }

    private void updateChangeStatus(DataModelerEvent event) {
        if (this.isFromThisContext(event)) {
            this.context.setEditionStatus(DataModelerContext.EditionStatus.EDITOR_CHANGED);
            this.dataModelerEvent.fire((Object)new DataModelStatusChangeEvent(this.context.getContextId(), null, false, true));
        }
    }

    public static interface DataModelerScreenView
    extends KieEditorView {
        public void setContext(DataModelerContext var1);

        public void refreshTypeLists(boolean var1);

        public void showUsagesPopupForDeletion(String var1, List<Path> var2, Command var3, Command var4);

        public void showUsagesPopupForRenaming(String var1, List<Path> var2, Command var3, Command var4);

        public void showYesNoCancelPopup(String var1, String var2, Command var3, String var4, ButtonType var5, Command var6, String var7, ButtonType var8);

        public void showYesNoCancelPopup(String var1, String var2, Command var3, Command var4);

        public void showParseErrorsDialog(String var1, String var2, Command var3);

        public void setDomainContainerTitle(String var1, String var2);

        public void redraw();
    }
}

