/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.command;

import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.AbstractDataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelChangeNotifier;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;

public class DataObjectAddOrRemoveAnnotationCommand
extends AbstractDataModelCommand {
    boolean doAdd = true;

    public DataObjectAddOrRemoveAnnotationCommand(DataModelerContext context, String source, DataObject dataObject, String annotationClassName, boolean doAdd, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, notifier);
        this.setAnnotationClassName(annotationClassName);
        this.doAdd = doAdd;
    }

    @Override
    public void execute() {
        if (this.doAdd && this.dataObject.getAnnotation(this.annotationClassName) == null) {
            this.dataObject.addAnnotation((Annotation)new AnnotationImpl(this.context.getAnnotationDefinition(this.annotationClassName)));
            this.notifyObjectChange(ChangeType.TYPE_ANNOTATION_ADD_CHANGE, this.context, this.source, this.dataObject, this.annotationClassName, null, null, null);
        } else if (!this.doAdd && this.dataObject.getAnnotation(this.annotationClassName) != null) {
            this.dataObject.removeAnnotation(this.annotationClassName);
            this.notifyObjectChange(ChangeType.TYPE_ANNOTATION_REMOVE_CHANGE, this.context, this.source, this.dataObject, this.annotationClassName, null, null, null);
        }
    }
}

