/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.command;

import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.AbstractDataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelChangeNotifier;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectChangeEvent;
import org.kie.workbench.common.services.datamodeller.core.DataObject;

public class DataObjectSuperClassChangeCommand
extends AbstractDataModelCommand {
    private String newSuperClass;

    public DataObjectSuperClassChangeCommand(DataModelerContext context, String source, DataObject dataObject, String newSuperClass, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, notifier);
        this.newSuperClass = newSuperClass;
    }

    @Override
    public void execute() {
        String oldSuperClass = this.dataObject.getSuperClassName();
        this.getDataObject().setSuperClassName(this.newSuperClass);
        if (oldSuperClass != null && !"".equals(oldSuperClass)) {
            this.getContext().getHelper().dataObjectExtended(oldSuperClass, this.getDataObject().getClassName(), false);
        }
        this.getContext().getHelper().dataObjectExtended(this.newSuperClass, this.getDataObject().getClassName(), true);
        DataObjectChangeEvent event = new DataObjectChangeEvent(ChangeType.SUPER_CLASS_NAME_CHANGE, this.getContext().getContextId(), this.getSource(), this.getDataObject(), null, (Object)oldSuperClass, (Object)this.newSuperClass);
        this.notifyChange((DataModelerEvent)event);
    }
}

