/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.command;

import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.AbstractDataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelChangeNotifier;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;

public class FieldTypeChangeCommand
extends AbstractDataModelCommand {
    protected ObjectProperty field;
    protected String newType;
    protected boolean multiple;

    public FieldTypeChangeCommand(DataModelerContext context, String source, DataObject dataObject, ObjectProperty field, String newType, boolean multiple, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, null, null, null, false, notifier);
        this.field = field;
        this.newType = newType;
        this.multiple = multiple;
    }

    public String getNewType() {
        return this.newType;
    }

    public void setNewType(String newType) {
        this.newType = newType;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public ObjectProperty getField() {
        return this.field;
    }

    public void setField(ObjectProperty field) {
        this.field = field;
    }

    @Override
    public void execute() {
        String oldType = this.field.getClassName();
        this.field.setClassName(this.newType);
        this.field.setMultiple(this.multiple);
        if (this.multiple && this.field.getBag() == null) {
            this.field.setBag("java.util.List");
        }
        if (!this.getContext().getHelper().isBaseType(this.newType).booleanValue()) {
            this.getContext().getHelper().dataObjectUnReferenced(oldType, this.getDataObject().getClassName());
            this.getContext().getHelper().dataObjectReferenced(this.newType, this.getDataObject().getClassName());
        }
        this.notifyFieldChange(ChangeType.FIELD_TYPE_CHANGE, this.context, this.source, this.dataObject, this.field, null, null, oldType, this.newValue);
    }
}

