/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandler;

@ApplicationScoped
public class DomainHandlerRegistry {
    private List<DomainHandler> domainHandlers = new ArrayList<DomainHandler>();
    private SyncBeanManager iocBeanManager;

    @Inject
    public DomainHandlerRegistry(SyncBeanManager iocBeanManager) {
        this.iocBeanManager = iocBeanManager;
    }

    @PostConstruct
    private void init() {
        Collection handlerBeans = this.iocBeanManager.lookupBeans(DomainHandler.class);
        if (handlerBeans != null && handlerBeans.size() > 0) {
            for (IOCBeanDef beanDef : handlerBeans) {
                this.domainHandlers.add((DomainHandler)beanDef.getInstance());
            }
        }
        Collections.sort(this.domainHandlers, new Comparator<DomainHandler>(){

            @Override
            public int compare(DomainHandler handler1, DomainHandler handler2) {
                Integer key1 = handler1.getPriority();
                Integer key2 = handler2.getPriority();
                return key1.compareTo(key2);
            }
        });
    }

    public List<DomainHandler> getDomainHandlers(String excludeDomain) {
        ArrayList<DomainHandler> result = new ArrayList<DomainHandler>();
        for (DomainHandler handler : this.domainHandlers) {
            if (excludeDomain.equals(handler.getName())) continue;
            result.add(handler);
        }
        return result;
    }

    public List<DomainHandler> getDomainHandlers(List<String> includedDomains) {
        ArrayList<DomainHandler> result = new ArrayList<DomainHandler>();
        for (DomainHandler handler : this.domainHandlers) {
            if (!includedDomains.contains(handler.getName())) continue;
            result.add(handler);
        }
        return result;
    }

    public List<DomainHandler> getDomainHandlers() {
        return Collections.unmodifiableList(this.domainHandlers);
    }
}

