/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.handlers.jpadomain;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.IOC;
import org.kie.workbench.common.screens.datamodeller.client.command.AddPropertyCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.FieldTypeChangeCommand;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandler;
import org.kie.workbench.common.screens.datamodeller.client.handlers.jpadomain.command.AdjustFieldDefaultRelationsCommand;
import org.kie.workbench.common.screens.datamodeller.client.handlers.jpadomain.command.JPACommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.DomainEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ResourceOptions;
import org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.JPADomainEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.options.JPANewResourceOptions;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;

@ApplicationScoped
public class JPADomainHandler
implements DomainHandler {
    @Inject
    private Instance<JPANewResourceOptions> newResourceOptions;
    @Inject
    private JPACommandBuilder commandBuilder;

    @Override
    public String getName() {
        return "JPA";
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public DomainEditor getDomainEditor(boolean newInstance) {
        JPADomainEditor domainEditor = (JPADomainEditor)IOC.getBeanManager().lookupBean(JPADomainEditor.class, new Annotation[0]).newInstance();
        domainEditor.setHandler(this);
        return domainEditor;
    }

    @Override
    public ResourceOptions getResourceOptions(boolean newInstance) {
        return (ResourceOptions)this.newResourceOptions.get();
    }

    @Override
    public boolean validateCommand(DataModelCommand command) {
        return true;
    }

    @Override
    public void postCommandProcessing(DataModelCommand command) {
        if (command instanceof FieldTypeChangeCommand && (this.isPersistable(((FieldTypeChangeCommand)command).getDataObject()) || this.isRelationConfigured(((FieldTypeChangeCommand)command).getField()))) {
            AdjustFieldDefaultRelationsCommand postCommand = this.commandBuilder.buildAdjustFieldDefaultRelationsCommand((FieldTypeChangeCommand)command, this.getName(), ((FieldTypeChangeCommand)command).getField());
            postCommand.execute();
        } else if (command instanceof AddPropertyCommand && this.isPersistable(((AddPropertyCommand)command).getDataObject())) {
            AdjustFieldDefaultRelationsCommand postCommand = this.commandBuilder.buildAdjustFieldDefaultRelationsCommand((AddPropertyCommand)command, this.getName(), ((AddPropertyCommand)command).getProperty());
            postCommand.execute();
        }
    }

    private boolean isPersistable(DataObject dataObject) {
        return dataObject.getAnnotation("javax.persistence.Entity") != null;
    }

    private boolean isRelationConfigured(ObjectProperty objectProperty) {
        return objectProperty.getAnnotation("javax.persistence.ManyToOne") != null || objectProperty.getAnnotation("javax.persistence.ManyToMany") != null || objectProperty.getAnnotation("javax.persistence.OneToOne") != null || objectProperty.getAnnotation("javax.persistence.OneToMany") != null || objectProperty.getAnnotation("javax.persistence.ElementCollection") != null;
    }
}

