/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.pdescriptor;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.kie.workbench.common.screens.datamodeller.client.pdescriptor.PersistenceUnitPropertyGridView;
import org.kie.workbench.common.screens.datamodeller.client.pdescriptor.PropertyRow;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.uberfire.ext.widgets.common.client.tables.SimpleTable;

public class PersistenceUnitPropertyGridViewImpl
extends Composite
implements PersistenceUnitPropertyGridView {
    private static PersistenceUnitPropertyGridViewUiBinder uiBinder = (PersistenceUnitPropertyGridViewUiBinder)GWT.create(PersistenceUnitPropertyGridViewUiBinder.class);
    private PersistenceUnitPropertyGridView.Presenter presenter;
    @UiField(provided=true)
    SimpleTable<PropertyRow> dataGrid = new SimpleTable();
    @UiField
    TextBox newPropertyNameTextBox;
    @UiField
    TextBox newPropertyValueTextBox;
    @UiField
    Button addPropertyButton;
    private boolean readOnly = false;

    public PersistenceUnitPropertyGridViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.dataGrid.setEmptyTableCaption(Constants.INSTANCE.persistence_unit_property_grid_no_properties_message());
        this.dataGrid.setToolBarVisible(false);
        this.addPropertyNameColumn();
        this.addPropertyValueColumn();
        this.addRemoveRowColumn();
    }

    private void addPropertyNameColumn() {
        Column<PropertyRow, String> column = new Column<PropertyRow, String>((Cell)new EditTextCell()){

            public String getValue(PropertyRow propertyRow) {
                if (propertyRow.getName() != null) {
                    return propertyRow.getName();
                }
                return "";
            }
        };
        column.setFieldUpdater(new PropertyNameFieldUpdater((EditTextCell)column.getCell()));
        this.dataGrid.addColumn((Column)column, Constants.INSTANCE.persistence_unit_property_grid_property_name_column());
        this.dataGrid.setColumnWidth((Column)column, 45.0, Style.Unit.PCT);
    }

    private void addPropertyValueColumn() {
        Column<PropertyRow, String> column = new Column<PropertyRow, String>((Cell)new EditTextCell()){

            public String getValue(PropertyRow propertyRow) {
                if (propertyRow.getValue() != null) {
                    return propertyRow.getValue();
                }
                return "";
            }
        };
        column.setFieldUpdater(new PropertyValueFieldUpdater((EditTextCell)column.getCell()));
        this.dataGrid.addColumn((Column)column, Constants.INSTANCE.persistence_unit_property_grid_property_value_column());
        this.dataGrid.setColumnWidth((Column)column, 45.0, Style.Unit.PCT);
    }

    private void addRemoveRowColumn() {
        Column<PropertyRow, String> column = new Column<PropertyRow, String>((Cell)new ButtonCell(IconType.TRASH, ButtonType.DANGER, ButtonSize.SMALL)){

            public String getValue(PropertyRow propertyRow) {
                return Constants.INSTANCE.persistence_unit_property_grid_action_delete();
            }
        };
        column.setFieldUpdater((FieldUpdater)new FieldUpdater<PropertyRow, String>(){

            public void update(int index, PropertyRow propertyRow, String value) {
                if (!PersistenceUnitPropertyGridViewImpl.this.readOnly) {
                    PersistenceUnitPropertyGridViewImpl.this.onRemoveProperty(propertyRow);
                }
            }
        });
        this.dataGrid.addColumn((Column)column, Constants.INSTANCE.persistence_unit_property_grid_property_action_column());
        this.dataGrid.setColumnWidth((Column)column, 10.0, Style.Unit.PCT);
    }

    @Override
    public void setPresenter(PersistenceUnitPropertyGridView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.addPropertyButton.setEnabled(!readOnly);
        this.newPropertyValueTextBox.setReadOnly(readOnly);
        this.newPropertyNameTextBox.setReadOnly(readOnly);
    }

    @Override
    public void setDataProvider(ListDataProvider<PropertyRow> dataProvider) {
        if (!dataProvider.getDataDisplays().contains(this.dataGrid)) {
            dataProvider.addDataDisplay(this.dataGrid);
        }
    }

    @Override
    public void redraw() {
        this.dataGrid.redraw();
    }

    @Override
    public String getNewPropertyName() {
        return this.newPropertyNameTextBox.getText();
    }

    @Override
    public String getNewPropertyValue() {
        return this.newPropertyValueTextBox.getText();
    }

    @Override
    public void setNewPropertyName(String name) {
        this.newPropertyNameTextBox.setText(name);
    }

    @Override
    public void setNewPropertyValue(String value) {
        this.newPropertyValueTextBox.setText(value);
    }

    @UiHandler(value={"addPropertyButton"})
    void onAddProperty(ClickEvent event) {
        this.presenter.onAddProperty();
    }

    private void onRemoveProperty(PropertyRow propertyRow) {
        this.presenter.onRemoveProperty(propertyRow);
    }

    private class PropertyValueFieldUpdater<T, C>
    implements FieldUpdater<T, C> {
        private EditTextCell cell;

        PropertyValueFieldUpdater(EditTextCell cell) {
            this.cell = cell;
        }

        public void update(int index, T object, C value) {
            if (!PersistenceUnitPropertyGridViewImpl.this.readOnly) {
                PropertyRow propertyRow = (PropertyRow)object;
                String sValue = (String)value;
                propertyRow.setValue(sValue);
            } else {
                PersistenceUnitPropertyGridViewImpl.this.dataGrid.redraw();
            }
        }
    }

    private class PropertyNameFieldUpdater<T, C>
    implements FieldUpdater<T, C> {
        private EditTextCell cell;

        PropertyNameFieldUpdater(EditTextCell cell) {
            this.cell = cell;
        }

        public void update(int index, T object, C value) {
            if (!PersistenceUnitPropertyGridViewImpl.this.readOnly) {
                PropertyRow propertyRow = (PropertyRow)object;
                String sValue = (String)value;
                propertyRow.setName(sValue);
            } else {
                PersistenceUnitPropertyGridViewImpl.this.dataGrid.redraw();
            }
        }
    }

    static interface PersistenceUnitPropertyGridViewUiBinder
    extends UiBinder<Widget, PersistenceUnitPropertyGridViewImpl> {
    }
}

