/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.pdescriptor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.pdescriptor.ClassRow;
import org.kie.workbench.common.screens.datamodeller.client.pdescriptor.ClassRowImpl;
import org.kie.workbench.common.screens.datamodeller.client.pdescriptor.ProjectClassListView;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;

@Dependent
public class ProjectClassList
implements IsWidget,
ProjectClassListView.Presenter {
    private ProjectClassListView view;
    private AsyncDataProvider<ClassRow> dataProvider;
    private List<ClassRow> classes;
    private ProjectClassListView.LoadClassesHandler loadClassesHandler;

    public ProjectClassList() {
    }

    @Inject
    public ProjectClassList(ProjectClassListView view) {
        this.view = view;
        view.setPresenter(this);
        this.dataProvider = new AsyncDataProvider<ClassRow>(){

            protected void onRangeChanged(HasData<ClassRow> display) {
                if (ProjectClassList.this.classes != null) {
                    this.updateRowCount(ProjectClassList.this.classes.size(), true);
                    this.updateRowData(0, ProjectClassList.this.classes);
                } else {
                    this.updateRowCount(0, true);
                    this.updateRowData(0, new ArrayList());
                }
            }
        };
        view.setDataProvider(this.dataProvider);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void setClasses(List<ClassRow> classes) {
        this.classes = classes;
        if (classes != null) {
            this.dataProvider.updateRowCount(classes.size(), true);
            this.dataProvider.updateRowData(0, classes);
        } else {
            this.dataProvider.updateRowCount(0, true);
            this.dataProvider.updateRowData(0, new ArrayList());
        }
        this.view.redraw();
    }

    public List<ClassRow> getClasses() {
        return this.classes;
    }

    public void setNewClassHelpMessage(String helpMessage) {
        this.view.setNewClassHelpMessage(helpMessage);
    }

    public void setNewClassName(String newClassName) {
        this.view.setNewClassName(newClassName);
    }

    @Override
    public void onLoadClasses() {
        if (this.loadClassesHandler != null) {
            this.loadClassesHandler.onLoadClasses();
        }
    }

    @Override
    public void onLoadClass() {
        this.view.setNewClassHelpMessage(null);
        String newClassName = DataModelerUtils.nullTrim(this.view.getNewClassName());
        if (newClassName == null) {
            this.view.setNewClassHelpMessage(Constants.INSTANCE.project_class_list_class_name_empty_message());
        } else if (this.loadClassesHandler != null) {
            this.loadClassesHandler.onLoadClass(newClassName);
        } else {
            if (this.classes == null) {
                this.classes = new ArrayList<ClassRow>();
            }
            this.classes.add(new ClassRowImpl(newClassName));
            this.setClasses(this.classes);
        }
    }

    @Override
    public void onClassNameChange() {
        this.view.setNewClassHelpMessage(null);
    }

    @Override
    public void onRemoveClass(ClassRow classRow) {
        this.classes.remove(classRow);
        this.setClasses(this.classes);
    }

    @Override
    public void addLoadClassesHandler(ProjectClassListView.LoadClassesHandler loadClassesHandler) {
        this.loadClassesHandler = loadClassesHandler;
    }

    public void setReadOnly(boolean readOnly) {
        this.view.setReadOnly(readOnly);
    }

    public void redraw() {
        this.view.redraw();
    }
}

