/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.pdescriptor;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.kie.workbench.common.screens.datamodeller.client.pdescriptor.ClassRow;
import org.kie.workbench.common.screens.datamodeller.client.pdescriptor.ProjectClassListView;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;

public class ProjectClassListViewImpl
extends Composite
implements ProjectClassListView {
    private static ProjectClassListViewImplUiBinder uiBinder = (ProjectClassListViewImplUiBinder)GWT.create(ProjectClassListViewImplUiBinder.class);
    private ProjectClassListView.Presenter presenter;
    private boolean readOnly = false;
    @UiField(provided=true)
    PagedTable<ClassRow> dataGrid = new PagedTable(10, (ProvidesKey)new ProvidesKey<ClassRow>(){

        public Object getKey(ClassRow item) {
            return item.getClassName();
        }
    });
    @UiField
    TextBox newClassTextBox;
    @UiField
    HelpBlock newClassHelpInline;
    @UiField
    Button addClassesButton;
    @UiField
    Button addClassButton;

    public ProjectClassListViewImpl() {
        this.dataGrid.setEmptyTableCaption(Constants.INSTANCE.project_class_list_no_classes_message());
        this.dataGrid.setToolBarVisible(false);
        this.addClassNameColumn();
        this.addRemoveRowColumn();
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.newClassTextBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                ProjectClassListViewImpl.this.presenter.onClassNameChange();
            }
        });
    }

    private void addRemoveRowColumn() {
        Column<ClassRow, String> column = new Column<ClassRow, String>((Cell)new ButtonCell(IconType.TRASH, ButtonType.DANGER, ButtonSize.SMALL)){

            public String getValue(ClassRow classRow) {
                return Constants.INSTANCE.project_class_list_action_delete();
            }
        };
        column.setFieldUpdater((FieldUpdater)new FieldUpdater<ClassRow, String>(){

            public void update(int index, ClassRow classRow, String value) {
                if (!ProjectClassListViewImpl.this.readOnly) {
                    ProjectClassListViewImpl.this.onRemoveClass(classRow);
                }
            }
        });
        this.dataGrid.addColumn((Column)column, Constants.INSTANCE.project_class_list_action_column());
        this.dataGrid.setColumnWidth((Column)column, 10.0, Style.Unit.PCT);
    }

    private void addClassNameColumn() {
        Column<ClassRow, String> column = new Column<ClassRow, String>((Cell)new TextCell()){

            public String getValue(ClassRow classRow) {
                if (classRow.getClassName() != null) {
                    return classRow.getClassName();
                }
                return "";
            }
        };
        this.dataGrid.addColumn((Column)column, Constants.INSTANCE.project_class_list_class_name_column());
        this.dataGrid.setColumnWidth((Column)column, 90.0, Style.Unit.PCT);
    }

    @Override
    public void setPresenter(ProjectClassListView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.newClassTextBox.setText(null);
        this.newClassTextBox.setReadOnly(readOnly);
        this.addClassesButton.setEnabled(!readOnly);
        this.addClassButton.setEnabled(!readOnly);
    }

    @Override
    public void setDataProvider(AsyncDataProvider<ClassRow> dataProvider) {
        this.dataGrid.setDataProvider(dataProvider);
    }

    @Override
    public String getNewClassName() {
        return this.newClassTextBox.getText();
    }

    @Override
    public void setNewClassName(String newClassName) {
        this.newClassTextBox.setText(newClassName);
    }

    @Override
    public void setNewClassHelpMessage(String newClassHelpInline) {
        this.newClassHelpInline.setText(newClassHelpInline);
    }

    @Override
    public void redraw() {
        this.dataGrid.redraw();
    }

    @UiHandler(value={"addClassesButton"})
    void onAddClasses(ClickEvent event) {
        this.presenter.onLoadClasses();
    }

    @UiHandler(value={"addClassButton"})
    void onAddClassButton(ClickEvent event) {
        this.presenter.onLoadClass();
    }

    void onRemoveClass(ClassRow classRow) {
        this.presenter.onRemoveClass(classRow);
    }

    static interface ProjectClassListViewImplUiBinder
    extends UiBinder<Widget, ProjectClassListViewImpl> {
    }
}

