/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain;

import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.AdvancedDataObjectEditorView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ObjectEditor;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ElementType;

@Dependent
public class AdvancedDataObjectEditor
extends ObjectEditor
implements AdvancedDataObjectEditorView.Presenter {
    private AdvancedDataObjectEditorView view;

    @Inject
    public AdvancedDataObjectEditor(DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder, AdvancedDataObjectEditorView view) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
        this.view = view;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public String getName() {
        return "ADVANCED_OBJECT_EDITOR";
    }

    @Override
    public String getDomainName() {
        return "ADVANCED";
    }

    @Override
    protected void loadDataObject(DataObject dataObject) {
        this.clear();
        this.setReadonly(this.context != null && this.context.isReadonly());
        this.view.setReadonly(this.isReadonly());
        this.dataObject = dataObject;
        if (dataObject != null) {
            this.view.loadAnnotations(dataObject.getAnnotations());
        }
    }

    @Override
    public void onDeleteAnnotation(Annotation annotation) {
        this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), annotation.getClassName()).execute();
        this.view.removeAnnotation(annotation);
    }

    @Override
    public void onValuePairChange(String annotationClassName, String valuePair, Object newValue) {
        this.commandBuilder.buildDataObjectAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), annotationClassName, valuePair, newValue, false).execute();
        this.refresh();
    }

    @Override
    public void onClearValuePair(Annotation annotation, String valuePair) {
        this.commandBuilder.buildDataObjectAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), annotation.getClassName(), valuePair, null, false).execute();
        this.refresh();
    }

    @Override
    public void onAddAnnotation(Annotation annotation) {
        this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), annotation).execute();
        this.refresh();
    }

    @Override
    public void clear() {
        this.view.clear();
    }

    @Override
    public void onContextChange(DataModelerContext context) {
        this.view.init(context != null ? context.getCurrentProject() : null, ElementType.TYPE);
        this.view.setReadonly(context != null && context.isReadonly());
        super.onContextChange(context);
    }

    private void refresh() {
        this.loadDataObject(this.dataObject);
    }
}

