/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.base.DefaultErrorCallback;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor.AdvancedAnnotationListEditorView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.ValuePairEditorPopup;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.ValuePairEditorPopupView;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.core.ElementType;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationParseRequest;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationParseResponse;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSource;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSourceRequest;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSourceResponse;
import org.kie.workbench.common.services.datamodeller.driver.model.DriverError;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.mvp.Command;

@Dependent
public class AdvancedAnnotationListEditor
implements IsWidget,
AdvancedAnnotationListEditorView.Presenter {
    private AdvancedAnnotationListEditorView view;
    private AdvancedAnnotationListEditorView.DeleteAnnotationHandler deleteAnnotationHandler;
    private AdvancedAnnotationListEditorView.ClearValuePairHandler clearValuePairHandler;
    private AdvancedAnnotationListEditorView.ValuePairChangeHandler valuePairChangeHandler;
    private AdvancedAnnotationListEditorView.AddAnnotationHandler addAnnotationHandler;
    private SyncBeanManager iocManager;
    private Caller<DataModelerService> modelerService;
    private Map<String, AnnotationSource> annotationSources;
    private List<org.kie.workbench.common.services.datamodeller.core.Annotation> annotations;
    private KieProject project;
    private ElementType elementType;
    private boolean readonly = false;

    @Inject
    public AdvancedAnnotationListEditor(AdvancedAnnotationListEditorView view, Caller<DataModelerService> modelerService, SyncBeanManager iocManager) {
        this.view = view;
        view.init(this);
        this.modelerService = modelerService;
        this.iocManager = iocManager;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void init(KieProject project, ElementType elementType) {
        this.project = project;
        this.elementType = elementType;
    }

    public void loadAnnotations(List<org.kie.workbench.common.services.datamodeller.core.Annotation> annotations) {
        this.annotations = annotations;
        if (annotations != null && annotations.size() > 0) {
            AnnotationSourceRequest sourceRequest = new AnnotationSourceRequest();
            sourceRequest.withAnnotations(annotations);
            ((DataModelerService)this.modelerService.call(this.getLoadAnnotationSourcesSuccessCallback(), (ErrorCallback)new DefaultErrorCallback())).resolveSourceRequest(sourceRequest);
        }
    }

    public void loadAnnotations(List<org.kie.workbench.common.services.datamodeller.core.Annotation> annotations, Map<String, AnnotationSource> annotationSources) {
        this.view.loadAnnotations(annotations, annotationSources);
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.view.setReadonly(readonly);
    }

    @Override
    public void onAddAnnotation() {
        this.view.invokeCreateAnnotationWizard(new Callback<org.kie.workbench.common.services.datamodeller.core.Annotation>(){

            public void callback(org.kie.workbench.common.services.datamodeller.core.Annotation annotation) {
                if (annotation != null && AdvancedAnnotationListEditor.this.addAnnotationHandler != null) {
                    AdvancedAnnotationListEditor.this.addAnnotationHandler.onAddAnnotation(annotation);
                }
            }
        }, this.project, this.elementType);
    }

    @Override
    public void onDeleteAnnotation(final org.kie.workbench.common.services.datamodeller.core.Annotation annotation) {
        String message = Constants.INSTANCE.advanced_domain_annotation_list_editor_message_confirm_annotation_deletion(annotation.getClassName(), this.elementType != null ? this.elementType.name() : " object/field");
        this.view.showYesNoDialog(message, new Command(){

            public void execute() {
                if (AdvancedAnnotationListEditor.this.deleteAnnotationHandler != null) {
                    AdvancedAnnotationListEditor.this.deleteAnnotationHandler.onDeleteAnnotation(annotation);
                }
            }
        }, new Command(){

            public void execute() {
            }
        }, new Command(){

            public void execute() {
            }
        });
    }

    @Override
    public void onEditValuePair(org.kie.workbench.common.services.datamodeller.core.Annotation annotation, String valuePair) {
        ValuePairEditorPopup valuePairEditor = this.createValuePairEditor(annotation, valuePair);
        if (valuePairEditor.isGenericEditor()) {
            AnnotationSource annotationSource = this.annotationSources.get(annotation.getClassName());
            String valuePairSource = annotationSource != null ? annotationSource.getValuePairSource(valuePair) : null;
            valuePairEditor.setValue(valuePairSource);
        } else {
            valuePairEditor.setValue(annotation.getValue(valuePair));
        }
        valuePairEditor.show();
    }

    @Override
    public void onClearValuePair(org.kie.workbench.common.services.datamodeller.core.Annotation annotation, String valuePair) {
        AnnotationDefinition annotationDefinition = annotation.getAnnotationDefinition();
        AnnotationValuePairDefinition valuePairDefinition = annotationDefinition.getValuePair(valuePair);
        if (valuePairDefinition.getDefaultValue() == null) {
            String message = Constants.INSTANCE.advanced_domain_annotation_list_editor_message_value_pair_has_no_default_value(valuePair, annotation.getClassName());
            this.view.showYesNoDialog(message, null, null, new Command(){

                public void execute() {
                }
            });
        } else if (this.clearValuePairHandler != null) {
            this.clearValuePairHandler.onClearValuePair(annotation, valuePair);
        }
    }

    @Override
    public void addDeleteAnnotationHandler(AdvancedAnnotationListEditorView.DeleteAnnotationHandler deleteAnnotationHandler) {
        this.deleteAnnotationHandler = deleteAnnotationHandler;
    }

    @Override
    public void addClearValuePairHandler(AdvancedAnnotationListEditorView.ClearValuePairHandler clearValuePairHandler) {
        this.clearValuePairHandler = clearValuePairHandler;
    }

    @Override
    public void addValuePairChangeHandler(AdvancedAnnotationListEditorView.ValuePairChangeHandler valuePairChangeHandler) {
        this.valuePairChangeHandler = valuePairChangeHandler;
    }

    @Override
    public void addAddAnnotationHandler(AdvancedAnnotationListEditorView.AddAnnotationHandler addAnnotationHandler) {
        this.addAnnotationHandler = addAnnotationHandler;
    }

    public void clear() {
        this.view.clear();
    }

    public void removeAnnotation(org.kie.workbench.common.services.datamodeller.core.Annotation annotation) {
        this.view.removeAnnotation(annotation);
    }

    private RemoteCallback<AnnotationSourceResponse> getLoadAnnotationSourcesSuccessCallback() {
        return new RemoteCallback<AnnotationSourceResponse>(){

            public void callback(AnnotationSourceResponse annotationSourceResponse) {
                AdvancedAnnotationListEditor.this.view.clear();
                AdvancedAnnotationListEditor.this.annotationSources = annotationSourceResponse.getAnnotationSources();
                AdvancedAnnotationListEditor.this.view.loadAnnotations(AdvancedAnnotationListEditor.this.annotations, annotationSourceResponse.getAnnotationSources());
            }
        };
    }

    private void doValuePairChange(ValuePairEditorPopup valuePairEditor, Object value) {
        if (valuePairEditor.isGenericEditor()) {
            String strValue = value != null ? value.toString() : null;
            ((DataModelerService)this.modelerService.call(this.getValuePairChangeSuccessCallback(valuePairEditor), (ErrorCallback)new DefaultErrorCallback())).resolveParseRequest(new AnnotationParseRequest(valuePairEditor.getAnnotationClassName(), this.elementType, valuePairEditor.getValuePairDefinition().getName(), strValue), this.project);
        } else {
            this.applyValuePairChange(valuePairEditor, value);
        }
    }

    private RemoteCallback<AnnotationParseResponse> getValuePairChangeSuccessCallback(final ValuePairEditorPopup valuePairEditor) {
        return new RemoteCallback<AnnotationParseResponse>(){

            public void callback(AnnotationParseResponse annotationParseResponse) {
                if (!annotationParseResponse.hasErrors() && annotationParseResponse.getAnnotation() != null) {
                    Object newValue = annotationParseResponse.getAnnotation().getValue(valuePairEditor.getValuePairDefinition().getName());
                    AdvancedAnnotationListEditor.this.applyValuePairChange(valuePairEditor, newValue);
                } else {
                    String errorMessage = "";
                    for (DriverError error : annotationParseResponse.getErrors()) {
                        errorMessage = errorMessage + "\n" + error.getMessage();
                    }
                    valuePairEditor.setErrorMessage(errorMessage);
                }
            }
        };
    }

    private void applyValuePairChange(ValuePairEditorPopup valuePairEditor, Object newValue) {
        if (!valuePairEditor.isValid()) {
            valuePairEditor.setErrorMessage(Constants.INSTANCE.advanced_domain_annotation_list_editor_message_invalid_value_for_value_pair(valuePairEditor.getValuePairDefinition().getName()));
        } else if (!valuePairEditor.getValuePairDefinition().hasDefaultValue() && newValue == null) {
            valuePairEditor.setErrorMessage(Constants.INSTANCE.advanced_domain_annotation_list_editor_message_value_pair_cant_be_null(valuePairEditor.getValuePairDefinition().getName()));
        } else {
            this.valuePairChangeHandler.onValuePairChange(valuePairEditor.getAnnotationClassName(), valuePairEditor.getValuePairDefinition().getName(), newValue);
            valuePairEditor.hide();
            this.dispose(valuePairEditor);
        }
    }

    private ValuePairEditorPopup createValuePairEditor(org.kie.workbench.common.services.datamodeller.core.Annotation annotation, String valuePair) {
        final ValuePairEditorPopup valuePairEditor = (ValuePairEditorPopup)this.iocManager.lookupBean(ValuePairEditorPopup.class, new Annotation[0]).getInstance();
        valuePairEditor.init(annotation.getClassName(), annotation.getAnnotationDefinition().getValuePair(valuePair));
        valuePairEditor.addPopupHandler(new ValuePairEditorPopupView.ValuePairEditorPopupHandler(){

            @Override
            public void onOk() {
                AdvancedAnnotationListEditor.this.doValuePairChange(valuePairEditor, valuePairEditor.getValue());
            }

            @Override
            public void onCancel() {
                valuePairEditor.hide();
                AdvancedAnnotationListEditor.this.dispose(valuePairEditor);
            }

            @Override
            public void onClose() {
                valuePairEditor.hide();
                AdvancedAnnotationListEditor.this.dispose(valuePairEditor);
            }
        });
        return valuePairEditor;
    }

    private void dispose(ValuePairEditorPopup valuePairEditor) {
        this.iocManager.destroyBean((Object)valuePairEditor);
    }
}

