/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Column;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.PanelBody;
import org.gwtbootstrap3.client.ui.PanelCollapse;
import org.gwtbootstrap3.client.ui.PanelGroup;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ColumnOffset;
import org.gwtbootstrap3.client.ui.constants.ColumnSize;
import org.gwtbootstrap3.client.ui.constants.HeadingSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Pull;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor.AdvancedAnnotationListEditorView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationwizard.CreateAnnotationWizard;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.core.ElementType;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSource;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.mvp.Command;

@Dependent
public class AdvancedAnnotationListEditorViewImpl
extends Composite
implements AdvancedAnnotationListEditorView {
    private static AdvancedAnnotationListEditorViewImplUiBinder uiBinder = (AdvancedAnnotationListEditorViewImplUiBinder)GWT.create(AdvancedAnnotationListEditorViewImplUiBinder.class);
    @UiField
    Button addAnnotationButton;
    @UiField
    PanelGroup accordionsContainer;
    private AdvancedAnnotationListEditorView.Presenter presenter;
    private Map<Annotation, Panel> annotationAccordion = new HashMap<Annotation, Panel>();
    private boolean readonly = false;
    private CreateAnnotationWizard createAnnotationWizard;

    @Inject
    public AdvancedAnnotationListEditorViewImpl(CreateAnnotationWizard createAnnotationWizard) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.createAnnotationWizard = createAnnotationWizard;
    }

    @PostConstruct
    protected void init() {
        this.accordionsContainer.setId(DOM.createUniqueId());
    }

    public void init(AdvancedAnnotationListEditorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void loadAnnotations(List<Annotation> annotations, Map<String, AnnotationSource> annotationSources) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                this.createAnnotationAccordionGroup(annotation, annotationSources != null ? annotationSources.get(annotation.getClassName()) : null, this.readonly);
            }
        }
    }

    @Override
    public void removeAnnotation(Annotation annotation) {
        Panel accordionGroup = this.annotationAccordion.get(annotation);
        if (accordionGroup != null) {
            this.accordionsContainer.remove((Widget)accordionGroup);
            this.annotationAccordion.remove(annotation);
        }
    }

    private void createAnnotationAccordionGroup(final Annotation annotation, AnnotationSource annotationSource, boolean readonly) {
        Panel container = new Panel();
        PanelHeader header = new PanelHeader();
        PanelCollapse collapse = new PanelCollapse();
        PanelBody body = new PanelBody();
        container.add((Widget)header);
        collapse.add((Widget)body);
        container.add((Widget)collapse);
        Button remove = new Button();
        remove.setEnabled(!readonly);
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                AdvancedAnnotationListEditorViewImpl.this.presenter.onDeleteAnnotation(annotation);
            }
        });
        remove.setPull(Pull.RIGHT);
        remove.setIcon(IconType.TRASH);
        remove.setType(ButtonType.DANGER);
        remove.setSize(ButtonSize.SMALL);
        remove.getElement().getStyle().setMarginTop(-4.0, Style.Unit.PX);
        header.add((Widget)remove);
        Heading heading = new Heading(HeadingSize.H4);
        Anchor anchor = new Anchor();
        anchor.setText(this.accordionHeading(annotation));
        anchor.setDataToggle(Toggle.COLLAPSE);
        anchor.setDataParent(this.accordionsContainer.getId());
        anchor.setDataTargetWidget((Widget)collapse);
        anchor.addStyleName("collapsed");
        heading.add((Widget)anchor);
        header.add((Widget)heading);
        this.accordionsContainer.add((Widget)container);
        this.annotationAccordion.put(annotation, container);
        if (annotation.getAnnotationDefinition() != null && annotation.getAnnotationDefinition().getValuePairs() != null) {
            for (AnnotationValuePairDefinition valuePairDefinition : annotation.getAnnotationDefinition().getValuePairs()) {
                body.add(this.createValuePairItem(annotation, valuePairDefinition, annotationSource));
            }
        }
    }

    private Widget createValuePairItem(final Annotation annotation, final AnnotationValuePairDefinition valuePairDefinition, AnnotationSource annotationSource) {
        Row valuePairRow = new Row();
        FormGroup formGroup = new FormGroup();
        valuePairRow.add((Widget)formGroup);
        FormLabel formLabel = new FormLabel();
        formLabel.addStyleName(ColumnSize.MD_3.getCssName());
        formLabel.setText(valuePairDefinition.getName());
        formGroup.add((Widget)formLabel);
        if (valuePairDefinition.getDefaultValue() == null) {
            formLabel.setShowRequiredIndicator(true);
        }
        Column column = new Column(ColumnSize.MD_9, new ColumnSize[0]);
        formGroup.add((Widget)column);
        TextBox content = new TextBox();
        column.add((Widget)content);
        String valuePairString = this.getValuePairStringValue(annotation, valuePairDefinition, annotationSource);
        content.setText(valuePairString);
        content.setReadOnly(true);
        content.setTitle(valuePairString);
        Button editButton = new Button(Constants.INSTANCE.advanced_domain_annotation_list_editor_action_edit(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                AdvancedAnnotationListEditorViewImpl.this.presenter.onEditValuePair(annotation, valuePairDefinition.getName());
            }
        });
        editButton.setEnabled(!this.readonly);
        editButton.setIcon(IconType.EDIT);
        Button clearButton = new Button(Constants.INSTANCE.advanced_domain_annotation_list_editor_action_clear(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                AdvancedAnnotationListEditorViewImpl.this.presenter.onClearValuePair(annotation, valuePairDefinition.getName());
            }
        });
        clearButton.setEnabled(!this.readonly);
        clearButton.setIcon(IconType.ERASER);
        FormGroup formGroupButton = new FormGroup();
        formGroupButton.add((Widget)editButton);
        formGroupButton.add((Widget)clearButton);
        Column columnButton = new Column(ColumnSize.MD_9, new ColumnSize[0]);
        columnButton.setOffset(new ColumnOffset[]{ColumnOffset.MD_3});
        columnButton.add((Widget)formGroupButton);
        valuePairRow.add((Widget)columnButton);
        return valuePairRow;
    }

    private String getValuePairStringValue(Annotation annotation, AnnotationValuePairDefinition valuePairDefinition, AnnotationSource annotationSource) {
        String strValue;
        Object value = annotation.getValue(valuePairDefinition.getName());
        if (value == null) {
            strValue = Constants.INSTANCE.advanced_domain_annotation_list_editor_message_value_not_set();
        } else {
            String string = strValue = annotationSource != null ? annotationSource.getValuePairSource(valuePairDefinition.getName()) : null;
            if (strValue == null) {
                strValue = Constants.INSTANCE.advanced_domain_annotation_list_editor_message_source_code_not_available();
            }
        }
        return strValue;
    }

    private String accordionHeading(Annotation annotation) {
        return "@" + annotation.getClassName();
    }

    @Override
    public void showYesNoDialog(String message, Command yesCommand, Command noCommand, Command cancelCommand) {
        YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)CommonConstants.INSTANCE.Information(), (String)message, (Command)yesCommand, (Command)noCommand, (Command)cancelCommand);
        yesNoCancelPopup.setClosable(false);
        yesNoCancelPopup.show();
    }

    @Override
    public void invokeCreateAnnotationWizard(Callback<Annotation> callback, KieProject kieProject, ElementType elementType) {
        this.createAnnotationWizard.init(kieProject, elementType);
        this.createAnnotationWizard.onCloseCallback(callback);
        this.createAnnotationWizard.start();
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.addAnnotationButton.setEnabled(!readonly);
    }

    @Override
    public void clear() {
        this.accordionsContainer.clear();
    }

    @UiHandler(value={"addAnnotationButton"})
    void onAddAnnotation(ClickEvent event) {
        this.presenter.onAddAnnotation();
    }

    static interface AdvancedAnnotationListEditorViewImplUiBinder
    extends UiBinder<Widget, AdvancedAnnotationListEditorViewImpl> {
    }
}

