/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationwizard;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationwizard.SearchAnnotationPage;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationwizard.SearchAnnotationPageView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationwizard.ValuePairEditorPage;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.core.ElementType;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.AbstractWizard;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;

@Dependent
public class CreateAnnotationWizard
extends AbstractWizard {
    private List<WizardPage> pages = new ArrayList<WizardPage>();
    private SearchAnnotationPage searchAnnotationPage;
    private SyncBeanManager iocManager;
    private Callback<org.kie.workbench.common.services.datamodeller.core.Annotation> onCloseCallback;
    private KieProject project;
    private AnnotationDefinition annotationDefinition = null;
    private ElementType target = ElementType.FIELD;

    @Inject
    public CreateAnnotationWizard(SearchAnnotationPage searchAnnotationPage, SyncBeanManager iocManager) {
        this.searchAnnotationPage = searchAnnotationPage;
        this.iocManager = iocManager;
    }

    @PostConstruct
    protected void init() {
        this.pages.add(this.searchAnnotationPage);
        this.searchAnnotationPage.addSearchAnnotationHandler(new SearchAnnotationPageView.SearchAnnotationHandler(){

            @Override
            public void onSearchClassChanged() {
                CreateAnnotationWizard.this.doOnSearchClassChanged();
            }

            @Override
            public void onAnnotationDefinitionChange(AnnotationDefinition annotationDefinition) {
                CreateAnnotationWizard.this.updateValuePairPages(annotationDefinition);
            }
        });
    }

    public void init(KieProject project, ElementType target) {
        this.project = project;
        this.target = target;
        this.searchAnnotationPage.init(project, target);
        this.clearCurrentValuePairEditorPages();
    }

    public List<WizardPage> getPages() {
        return this.pages;
    }

    public Widget getPageWidget(int pageNumber) {
        return this.pages.get(pageNumber).asWidget();
    }

    public String getTitle() {
        return Constants.INSTANCE.advanced_domain_wizard_title();
    }

    public int getPreferredHeight() {
        return 350;
    }

    public int getPreferredWidth() {
        return 700;
    }

    public void isComplete(final Callback<Boolean> callback) {
        callback.callback((Object)true);
        for (WizardPage page : this.pages) {
            page.isComplete((Callback)new Callback<Boolean>(){

                public void callback(Boolean result) {
                    if (Boolean.FALSE.equals(result)) {
                        callback.callback((Object)false);
                    }
                }
            });
        }
    }

    public void onCloseCallback(Callback<org.kie.workbench.common.services.datamodeller.core.Annotation> callback) {
        this.onCloseCallback = callback;
    }

    public void complete() {
        super.complete();
        this.doComplete();
    }

    public void close() {
        super.close();
        this.clearCurrentValuePairEditorPages();
        this.invokeOnCloseCallback(null);
    }

    private void doComplete() {
        AnnotationImpl annotation = null;
        if (this.annotationDefinition != null) {
            annotation = new AnnotationImpl(this.annotationDefinition);
            if (!this.annotationDefinition.isMarker()) {
                for (ValuePairEditorPage valuePairEditor : this.filterValuePairEditorPages()) {
                    if (valuePairEditor.getCurrentValue() == null) continue;
                    annotation.setValue(valuePairEditor.getValuePairDefinition().getName(), valuePairEditor.getCurrentValue());
                }
            }
        }
        this.clearCurrentValuePairEditorPages();
        this.invokeOnCloseCallback((org.kie.workbench.common.services.datamodeller.core.Annotation)annotation);
    }

    private void doOnSearchClassChanged() {
        if (this.annotationDefinition != null || this.pages.size() > 1) {
            this.annotationDefinition = null;
            this.clearCurrentValuePairEditorPages();
            super.start();
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    CreateAnnotationWizard.this.searchAnnotationPage.requestFocus();
                }
            });
        }
    }

    private void updateValuePairPages(AnnotationDefinition annotationDefinition) {
        this.clearCurrentValuePairEditorPages();
        this.pages.clear();
        this.pages.add(this.searchAnnotationPage);
        this.annotationDefinition = annotationDefinition;
        if (annotationDefinition != null) {
            for (AnnotationValuePairDefinition valuePairDefinition : annotationDefinition.getValuePairs()) {
                this.pages.add(this.createValuePairEditorPage(valuePairDefinition));
            }
        }
        super.start();
    }

    private ValuePairEditorPage createValuePairEditorPage(AnnotationValuePairDefinition valuePairDefinition) {
        ValuePairEditorPage valuePairEditorPage = (ValuePairEditorPage)this.iocManager.lookupBean(ValuePairEditorPage.class, new Annotation[0]).getInstance();
        valuePairEditorPage.init(this.annotationDefinition, valuePairDefinition, this.target, this.project);
        return valuePairEditorPage;
    }

    private void clearCurrentValuePairEditorPages() {
        List<ValuePairEditorPage> editorPages = this.filterValuePairEditorPages();
        int valuePairEditors = editorPages.size();
        for (WizardPage wizardPage : editorPages) {
            this.pages.remove(wizardPage);
        }
        for (int i = 0; i < valuePairEditors; ++i) {
            ValuePairEditorPage valuePairEditorPage = editorPages.remove(0);
            this.iocManager.destroyBean((Object)valuePairEditorPage);
        }
    }

    private void invokeOnCloseCallback(org.kie.workbench.common.services.datamodeller.core.Annotation annotation) {
        if (this.onCloseCallback != null) {
            this.onCloseCallback.callback((Object)annotation);
        }
    }

    private List<ValuePairEditorPage> filterValuePairEditorPages() {
        ArrayList<ValuePairEditorPage> result = new ArrayList<ValuePairEditorPage>(this.pages.size());
        for (WizardPage page : this.pages) {
            if (!(page instanceof ValuePairEditorPage)) continue;
            result.add((ValuePairEditorPage)page);
        }
        return result;
    }

    public static class CreateAnnotationWizardErrorCallback
    implements ErrorCallback<Message> {
        public boolean error(Message message, Throwable throwable) {
            Window.alert((String)("Unexpected error encountered : " + throwable.getMessage()));
            return false;
        }
    }
}

