/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationwizard;

import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationwizard.CreateAnnotationWizardPage;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationwizard.SearchAnnotationPageView;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.ElementType;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationDefinitionRequest;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationDefinitionResponse;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class SearchAnnotationPage
extends CreateAnnotationWizardPage
implements SearchAnnotationPageView.Presenter {
    private SearchAnnotationPageView.SearchAnnotationHandler searchAnnotationHandler;
    private SearchAnnotationPageView view;

    @Inject
    public SearchAnnotationPage(SearchAnnotationPageView view, Caller<DataModelerService> modelerService, Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent) {
        super(modelerService, wizardPageStatusChangeEvent);
        this.view = view;
        view.init(this);
        this.setTitle(Constants.INSTANCE.advanced_domain_wizard_search_page_title());
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void init(KieProject project, ElementType target) {
        this.project = project;
        this.target = target;
        this.status = CreateAnnotationWizardPage.PageStatus.NOT_VALIDATED;
        this.view.setClassName(null);
        this.view.clearHelpMessage();
    }

    @Override
    public void onSearchClass() {
        AnnotationDefinitionRequest definitionRequest = new AnnotationDefinitionRequest(DataModelerUtils.trim(this.view.getClassName()));
        ((DataModelerService)this.modelerService.call(this.getOnSearchClassSuccessCallback(definitionRequest))).resolveDefinitionRequest(definitionRequest, this.project);
    }

    private RemoteCallback<AnnotationDefinitionResponse> getOnSearchClassSuccessCallback(final AnnotationDefinitionRequest definitionRequest) {
        return new RemoteCallback<AnnotationDefinitionResponse>(){

            public void callback(AnnotationDefinitionResponse definitionResponse) {
                SearchAnnotationPage.this.processAnnotationDefinitionRequest(definitionRequest, definitionResponse);
            }
        };
    }

    private void processAnnotationDefinitionRequest(AnnotationDefinitionRequest definitionRequest, AnnotationDefinitionResponse definitionResponse) {
        this.annotationDefinition = definitionResponse.getAnnotationDefinition();
        if (definitionResponse.hasErrors() || definitionResponse.getAnnotationDefinition() == null) {
            this.setHelpMessage(Constants.INSTANCE.advanced_domain_wizard_search_page_message_class_not_found(definitionRequest.getClassName()));
        } else {
            this.setHelpMessage(Constants.INSTANCE.advanced_domain_wizard_search_page_message_annotation_is_loaded());
        }
        this.setStatus(this.annotationDefinition != null ? CreateAnnotationWizardPage.PageStatus.VALIDATED : CreateAnnotationWizardPage.PageStatus.NOT_VALIDATED);
        if (this.searchAnnotationHandler != null) {
            this.searchAnnotationHandler.onAnnotationDefinitionChange(this.annotationDefinition);
        }
    }

    @Override
    public void onSearchClassChanged() {
        this.setHelpMessage(Constants.INSTANCE.advanced_domain_wizard_search_page_message_annotation_not_loaded());
        this.annotationDefinition = null;
        if (this.searchAnnotationHandler != null) {
            this.searchAnnotationHandler.onSearchClassChanged();
        }
        this.setStatus(CreateAnnotationWizardPage.PageStatus.NOT_VALIDATED);
    }

    public void requestFocus() {
        this.view.setClassNameFocus(true);
    }

    @Override
    public void addSearchAnnotationHandler(SearchAnnotationPageView.SearchAnnotationHandler searchAnnotationHandler) {
        this.searchAnnotationHandler = searchAnnotationHandler;
    }

    void clearHelpMessage() {
        this.view.clearHelpMessage();
    }

    void setHelpMessage(String helpMessage) {
        this.view.setHelpMessage(helpMessage);
    }
}

