/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.droolsdomain;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.util.AnnotationValueHandler;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.screens.datamodeller.client.validation.ValidatorService;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ObjectEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.droolsdomain.DroolsDataObjectEditorView;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldCreatedEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldDeletedEvent;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.mvp.Command;

@Dependent
public class DroolsDataObjectEditor
extends ObjectEditor
implements DroolsDataObjectEditorView.Presenter {
    private ValidatorService validatorService;
    private DroolsDataObjectEditorView view;

    @Inject
    public DroolsDataObjectEditor(DroolsDataObjectEditorView view, DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder, ValidatorService validatorService) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
        this.validatorService = validatorService;
        this.view = view;
        view.init(this);
    }

    @PostConstruct
    protected void init() {
        ArrayList<Pair<String, String>> roleOptions = new ArrayList<Pair<String, String>>();
        roleOptions.add(new Pair((Object)"EVENT", (Object)"EVENT"));
        this.view.initRoleList(roleOptions, true);
        ArrayList<Pair<String, String>> typeSafeOptions = new ArrayList<Pair<String, String>>();
        typeSafeOptions.add(new Pair((Object)"false", (Object)"false"));
        typeSafeOptions.add(new Pair((Object)"true", (Object)"true"));
        this.view.initTypeSafeList(typeSafeOptions, true);
        this.view.initTimeStampFieldList(new ArrayList<Pair<String, String>>(), true);
        this.view.initDurationFieldList(new ArrayList<Pair<String, String>>(), true);
        this.setReadonly(true);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public String getName() {
        return "DROOLS_OBJECT_EDITOR";
    }

    @Override
    public String getDomainName() {
        return "DROOLS";
    }

    @Override
    public void setReadonly(boolean readonly) {
        super.setReadonly(readonly);
        this.view.setReadonly(readonly);
    }

    @Override
    protected void loadDataObject(DataObject dataObject) {
        this.clear();
        this.setReadonly(true);
        if (dataObject != null) {
            String value;
            this.dataObject = dataObject;
            Annotation annotation = dataObject.getAnnotation("org.kie.api.definition.type.Role");
            if (annotation != null) {
                value = annotation.getValue("value") != null ? annotation.getValue("value").toString() : "NOT_SELECTED";
                this.view.setRole(value);
            }
            if ((annotation = dataObject.getAnnotation("org.kie.api.definition.type.PropertyReactive")) != null) {
                this.view.setPropertyReactive(Boolean.TRUE);
            }
            if ((annotation = dataObject.getAnnotation("org.kie.api.definition.type.ClassReactive")) != null) {
                this.view.setClassReactive(Boolean.TRUE);
            }
            if ((annotation = dataObject.getAnnotation("org.kie.api.definition.type.TypeSafe")) != null) {
                value = annotation.getValue("value") != null ? annotation.getValue("value").toString() : "NOT_SELECTED";
                this.view.setTypeSafe(value);
            }
            if ((annotation = dataObject.getAnnotation("org.kie.api.definition.type.Expires")) != null) {
                this.view.setExpires(annotation.getValue("value").toString());
            }
            if ((annotation = dataObject.getAnnotation("org.kie.api.remote.Remotable")) != null) {
                this.view.setRemotable(Boolean.TRUE);
            }
            this.loadDuration(dataObject);
            this.loadTimestamp(dataObject);
            this.setReadonly(this.getContext() == null || this.getContext().isReadonly());
        }
    }

    private void loadDuration(DataObject dataObject) {
        this.loadDurationSelector(dataObject);
        Annotation annotation = dataObject.getAnnotation("org.kie.api.definition.type.Duration");
        if (annotation != null) {
            String value = annotation.getValue("value") != null ? annotation.getValue("value").toString() : "NOT_SELECTED";
            this.view.setDurationField(value);
        }
    }

    private void loadTimestamp(DataObject dataObject) {
        this.loadTimestampSelector(dataObject);
        Annotation annotation = dataObject.getAnnotation("org.kie.api.definition.type.Timestamp");
        if (annotation != null) {
            String value = annotation.getValue("value") != null ? annotation.getValue("value").toString() : "NOT_SELECTED";
            this.view.setTimeStampField(value);
        }
    }

    private void onDataObjectFieldCreated(@Observes DataObjectFieldCreatedEvent event) {
        this.updateFieldDependentSelectors((DataModelerEvent)event, event.getCurrentDataObject(), event.getCurrentField());
    }

    private void onDataObjectFieldChange(@Observes DataObjectFieldChangeEvent event) {
        this.updateFieldDependentSelectors((DataModelerEvent)event, event.getCurrentDataObject(), event.getCurrentField());
    }

    private void onDataObjectFieldDeleted(@Observes DataObjectFieldDeletedEvent event) {
        this.updateFieldDependentSelectors((DataModelerEvent)event, event.getCurrentDataObject(), event.getCurrentField());
    }

    private void updateFieldDependentSelectors(DataModelerEvent event, DataObject currentDataObject, ObjectProperty currentField) {
        if (event.isFromContext(this.context != null ? this.context.getContextId() : null) && this.getDataObject() == currentDataObject) {
            this.loadDuration(this.getDataObject());
            this.loadTimestamp(this.getDataObject());
        }
    }

    @Override
    public void onRoleChange() {
        if (this.getDataObject() != null) {
            String newRole = "NOT_SELECTED".equals(this.view.getRole()) ? null : this.view.getRole();
            this.commandBuilder.buildDataObjectAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), "org.kie.api.definition.type.Role", "value", newRole, true).execute();
        }
    }

    @Override
    public void onTypeSafeChange() {
        if (this.getDataObject() != null) {
            String newTypeSafeValue = "NOT_SELECTED".equals(this.view.getTypeSafe()) ? null : this.view.getTypeSafe();
            this.commandBuilder.buildDataObjectAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), "org.kie.api.definition.type.TypeSafe", "value", newTypeSafeValue, true).execute();
        }
    }

    @Override
    public void onTimeStampFieldChange() {
        if (this.getDataObject() != null) {
            String newTimestampValue = "NOT_SELECTED".equals(this.view.getTimeStampField()) ? null : this.view.getTimeStampField();
            this.commandBuilder.buildDataObjectAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), "org.kie.api.definition.type.Timestamp", "value", newTimestampValue, true).execute();
        }
    }

    @Override
    public void onDurationFieldChange() {
        if (this.getDataObject() != null) {
            String newDurationValue = "NOT_SELECTED".equals(this.view.getDurationField()) ? null : this.view.getDurationField();
            this.commandBuilder.buildDataObjectAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), "org.kie.api.definition.type.Duration", "value", newDurationValue, true).execute();
        }
    }

    @Override
    public void onPropertyReactiveChange() {
        if (this.getDataObject() != null) {
            Boolean isChecked = this.view.getPropertyReactive();
            this.commandBuilder.buildDataObjectAddOrRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.kie.api.definition.type.PropertyReactive", isChecked).execute();
            if (isChecked.booleanValue()) {
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.kie.api.definition.type.ClassReactive").execute();
                this.view.setClassReactive(false);
            }
        }
    }

    @Override
    public void onClassReactiveChange() {
        if (this.getDataObject() != null) {
            Boolean isChecked = this.view.getClassReactive();
            this.commandBuilder.buildDataObjectAddOrRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.kie.api.definition.type.ClassReactive", isChecked).execute();
            if (isChecked.booleanValue()) {
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.kie.api.definition.type.PropertyReactive").execute();
                this.view.setPropertyReactive(false);
            }
        }
    }

    @Override
    public void onExpiresChange() {
        if (this.getDataObject() != null) {
            this.view.setExpiresOnError(false);
            final Command afterCloseCommand = new Command(){

                public void execute() {
                    DroolsDataObjectEditor.this.view.setExpiresOnError(true);
                    DroolsDataObjectEditor.this.view.selectAllExpiresText();
                }
            };
            final String newValue = this.view.getExpires();
            this.validatorService.isValidTimerInterval(newValue, new ValidatorCallback(){

                public void onFailure() {
                    DroolsDataObjectEditor.this.view.showErrorPopup(Constants.INSTANCE.validation_error_invalid_timer_expression(newValue), null, afterCloseCommand);
                }

                public void onSuccess() {
                    DroolsDataObjectEditor.this.commandBuilder.buildDataObjectAnnotationValueChangeCommand(DroolsDataObjectEditor.this.getContext(), DroolsDataObjectEditor.this.getName(), DroolsDataObjectEditor.this.getDataObject(), "org.kie.api.definition.type.Expires", "value", DataModelerUtils.nullTrim(newValue), true).execute();
                }
            });
        }
    }

    @Override
    public void onRemotableChange() {
        if (this.getDataObject() != null) {
            Boolean isChecked = this.view.getRemotable();
            this.commandBuilder.buildDataObjectAddOrRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.kie.api.remote.Remotable", isChecked).execute();
        }
    }

    private void loadDurationSelector(DataObject dataObject) {
        if (dataObject == null) {
            return;
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add("short");
        types.add("int");
        types.add("long");
        types.add("java.lang.Short");
        types.add("java.lang.Integer");
        types.add("java.lang.Long");
        String defaultValue = null;
        Annotation annotation = dataObject.getAnnotation("org.kie.api.definition.type.Duration");
        if (annotation != null) {
            defaultValue = AnnotationValueHandler.getStringValue(annotation, "value");
        }
        List<Pair<String, String>> propertyOptions = this.loadPropertyOptions(dataObject, types, defaultValue);
        this.view.initDurationFieldList(propertyOptions, true);
    }

    private void loadTimestampSelector(DataObject dataObject) {
        if (dataObject == null) {
            return;
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add("long");
        types.add("java.lang.Long");
        types.add("java.util.Date");
        types.add("java.sql.Timestamp");
        String defaultValue = null;
        Annotation annotation = dataObject.getAnnotation("org.kie.api.definition.type.Timestamp");
        if (annotation != null) {
            defaultValue = AnnotationValueHandler.getStringValue(annotation, "value");
        }
        List<Pair<String, String>> propertyOptions = this.loadPropertyOptions(dataObject, types, defaultValue);
        this.view.initTimeStampFieldList(propertyOptions, true);
    }

    private List<Pair<String, String>> loadPropertyOptions(DataObject dataObject, List<String> types, String defaultValue) {
        ArrayList<Pair<String, String>> propertyOptions = new ArrayList<Pair<String, String>>();
        if (dataObject != null) {
            List<ObjectProperty> properties = DataModelerUtils.filterPropertiesByType(dataObject.getProperties(), types, true);
            TreeMap<String, String> propertyNames = new TreeMap<String, String>();
            for (ObjectProperty objectProperty : properties) {
                propertyNames.put(objectProperty.getName(), objectProperty.getName());
            }
            if (defaultValue != null && !"".equals(defaultValue)) {
                propertyNames.put(defaultValue, defaultValue);
            }
            for (Map.Entry entry : propertyNames.entrySet()) {
                propertyOptions.add((Pair<String, String>)new Pair(entry.getKey(), entry.getValue()));
            }
        }
        return propertyOptions;
    }

    @Override
    public void clear() {
        this.view.setRole("NOT_SELECTED");
        this.view.setClassReactive(false);
        this.view.setPropertyReactive(false);
        this.view.setClassReactive(false);
        this.view.setTypeSafe("NOT_SELECTED");
        this.view.setExpires(null);
        this.view.setExpiresOnError(false);
        this.view.setDurationField("NOT_SELECTED");
        this.view.setTimeStampField("NOT_SELECTED");
        this.view.setRemotable(false);
    }
}

