/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.editor;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ImageResourceCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import java.util.HashSet;
import java.util.Set;

public class ClickableImageResourceCell
extends ImageResourceCell {
    private boolean asAnchor = false;
    private int minWidth = -1;

    public ClickableImageResourceCell(boolean asAnchor) {
        this.asAnchor = asAnchor;
    }

    public ClickableImageResourceCell(boolean asAnchor, int minWidth) {
        this.asAnchor = asAnchor;
        this.minWidth = minWidth;
    }

    public Set<String> getConsumedEvents() {
        HashSet<String> consumedEvents = new HashSet<String>();
        consumedEvents.add("click");
        consumedEvents.add("keydown");
        return consumedEvents;
    }

    public void onBrowserEvent(Cell.Context context, Element parent, ImageResource value, NativeEvent event, ValueUpdater<ImageResource> valueUpdater) {
        switch (DOM.eventGetType((Event)((Event)event))) {
            case 1: {
                valueUpdater.update((Object)value);
            }
        }
    }

    public void render(Cell.Context context, ImageResource value, SafeHtmlBuilder sb) {
        if (value != null) {
            SafeHtml startAnchor = null;
            SafeHtml endAnchor = null;
            if (this.asAnchor) {
                startAnchor = new SafeHtml(){

                    public String asString() {
                        String minWidthStyle = ClickableImageResourceCell.this.minWidth > 0 ? " min-width:" + ClickableImageResourceCell.this.minWidth + "px;" : "";
                        return "<div style=\"cursor: pointer;" + minWidthStyle + "\">";
                    }
                };
                endAnchor = new SafeHtml(){

                    public String asString() {
                        return "</div>";
                    }
                };
                sb.append(startAnchor);
            }
            super.render(context, value, sb);
            if (this.asAnchor) {
                sb.append(endAnchor);
            }
        }
    }
}

