/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.handlers.jpadomain.util.RelationshipAnnotationValueHandler;
import org.kie.workbench.common.screens.datamodeller.client.handlers.jpadomain.util.SequenceGeneratorValueHandler;
import org.kie.workbench.common.screens.datamodeller.client.model.DataModelerPropertyEditorFieldInfo;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.util.AnnotationValueHandler;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.FieldEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.JPADataObjectFieldEditorView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.properties.IdGeneratorField;
import org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.properties.RelationshipField;
import org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.properties.SequenceGeneratorField;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.model.jpadomain.FetchMode;
import org.kie.workbench.common.screens.datamodeller.model.jpadomain.RelationType;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.uberfire.ext.properties.editor.client.fields.BooleanField;
import org.uberfire.ext.properties.editor.client.fields.TextField;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

@Dependent
public class JPADataObjectFieldEditor
extends FieldEditor
implements JPADataObjectFieldEditorView.Presenter {
    private static Map<String, DataModelerPropertyEditorFieldInfo> propertyEditorFields = new HashMap<String, DataModelerPropertyEditorFieldInfo>();
    private JPADataObjectFieldEditorView view;

    @Inject
    public JPADataObjectFieldEditor(JPADataObjectFieldEditorView view, DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
        this.view = view;
        view.init(this);
    }

    @PostConstruct
    protected void init() {
        this.view.setLastOpenAccordionGroupTitle("");
        this.loadPropertyEditor();
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public String getName() {
        return "JPA_FIELD_EDITOR";
    }

    @Override
    public String getDomainName() {
        return "JPA";
    }

    @Override
    protected void loadDataObjectField(DataObject dataObject, ObjectProperty objectField) {
        this.clear();
        this.setReadonly(true);
        this.view.setLastOpenAccordionGroupTitle("");
        if (dataObject != null && objectField != null) {
            this.dataObject = dataObject;
            this.objectField = objectField;
            this.updateIdentifierField(objectField.getAnnotation("javax.persistence.Id"));
            this.updateColumnFields(objectField.getAnnotation("javax.persistence.Column"));
            this.updateGeneratedValueField(objectField.getAnnotation("javax.persistence.GeneratedValue"));
            this.updateSequenceGeneratorField(objectField.getAnnotation("javax.persistence.SequenceGenerator"));
            this.updateRelationshipField(this.getCurrentRelationshipAnnotation(objectField));
            if (objectField.getAnnotation("javax.persistence.Id") != null) {
                this.view.setLastOpenAccordionGroupTitle(Constants.INSTANCE.persistence_domain_fieldEditor_identifier_category());
            } else if (this.getCurrentRelationshipAnnotation(objectField) != null) {
                this.view.setLastOpenAccordionGroupTitle(Constants.INSTANCE.persistence_domain_fieldEditor_relationship_category());
            }
            this.setReadonly(this.getContext() == null || this.getContext().isReadonly());
        }
        this.loadPropertyEditor();
    }

    @Override
    public void onIdentifierFieldChange(DataModelerPropertyEditorFieldInfo fieldInfo, String newValue) {
        if (this.getObjectField() != null) {
            Boolean doAdd = Boolean.TRUE.toString().equals(newValue);
            this.commandBuilder.buildFieldAddOrRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "javax.persistence.Id", doAdd).execute();
        }
    }

    @Override
    public void onColumnFieldChange(DataModelerPropertyEditorFieldInfo fieldInfo, String newValue) {
        if (this.getObjectField() != null) {
            if ("COLUMN_NAME_FIELD".equals(fieldInfo.getKey())) {
                String value = DataModelerUtils.nullTrim(newValue);
                this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "javax.persistence.Column", "name", value, false).execute();
            } else if ("COLUMN_UNIQUE_FIELD".equals(fieldInfo.getKey())) {
                this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "javax.persistence.Column", "unique", newValue, false).execute();
            } else if ("COLUMN_NULLABLE_FIELD".equals(fieldInfo.getKey())) {
                this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "javax.persistence.Column", "nullable", newValue, false).execute();
            } else if ("COLUMN_INSERTABLE_FIELD".equals(fieldInfo.getKey())) {
                this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "javax.persistence.Column", "insertable", newValue, false).execute();
            } else if ("COLUMN_UPDATABLE_FIELD".equals(fieldInfo.getKey())) {
                this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "javax.persistence.Column", "updatable", newValue, false).execute();
            }
            Annotation annotation = this.getObjectField().getAnnotation("javax.persistence.Column");
            if (annotation != null && this.hasOnlyDefaultValues(annotation)) {
                this.commandBuilder.buildFieldAddOrRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "javax.persistence.Column", false).execute();
            }
        }
    }

    @Override
    public void onGeneratedValueFieldChange(DataModelerPropertyEditorFieldInfo fieldInfo, String newValue) {
        if (this.getObjectField() != null) {
            String strategy = DataModelerUtils.nullTrim((String)fieldInfo.getCurrentValue("strategy"));
            String generator = DataModelerUtils.nullTrim((String)fieldInfo.getCurrentValue("generator"));
            if (strategy == null || "NONE".equals(strategy)) {
                this.commandBuilder.buildFieldAnnotationRemoveCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "javax.persistence.GeneratedValue").execute();
            } else {
                this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "javax.persistence.GeneratedValue", "strategy", strategy, false).execute();
                this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "javax.persistence.GeneratedValue", "generator", generator, false).execute();
            }
        }
    }

    @Override
    public void onSequenceGeneratorFieldChange(DataModelerPropertyEditorFieldInfo fieldInfo, String newValue) {
        if (this.getObjectField() != null) {
            Annotation oldGenerator = this.getObjectField().getAnnotation("javax.persistence.SequenceGenerator");
            SequenceGeneratorValueHandler oldGeneratorHandler = oldGenerator != null ? new SequenceGeneratorValueHandler(oldGenerator) : null;
            Annotation newGenerator = null;
            if (oldGeneratorHandler != null) {
                this.commandBuilder.buildFieldAnnotationRemoveCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), oldGeneratorHandler.getClassName()).execute();
            }
            String name = DataModelerUtils.nullTrim((String)fieldInfo.getCurrentValue("name"));
            String sequenceName = DataModelerUtils.nullTrim((String)fieldInfo.getCurrentValue("sequenceName"));
            Integer initialValue = (Integer)fieldInfo.getCurrentValue("initialValue");
            Integer allocationSize = (Integer)fieldInfo.getCurrentValue("allocationSize");
            if (name != null && !"".equals(name.trim())) {
                newGenerator = SequenceGeneratorValueHandler.createAnnotation(name, sequenceName, initialValue, allocationSize, this.getContext().getAnnotationDefinitions());
                this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), newGenerator).execute();
            }
        }
    }

    @Override
    public void onRelationTypeFieldChange(DataModelerPropertyEditorFieldInfo fieldInfo, String newValue) {
        if (this.getObjectField() != null) {
            Annotation newRelation;
            Annotation oldRelation = this.getCurrentRelationshipAnnotation(this.getObjectField());
            RelationshipAnnotationValueHandler oldRelationHandler = oldRelation != null ? new RelationshipAnnotationValueHandler(oldRelation) : null;
            RelationType newRelationType = (RelationType)fieldInfo.getCurrentValue("relationType");
            List newCascadeTypes = (List)fieldInfo.getCurrentValue("cascade");
            FetchMode newFetchMode = (FetchMode)fieldInfo.getCurrentValue("fetch");
            Boolean newOptional = (Boolean)fieldInfo.getCurrentValue("optional");
            String newMappedBy = DataModelerUtils.nullTrim((String)fieldInfo.getCurrentValue("mappedBy"));
            Boolean newOrphanRemoval = (Boolean)fieldInfo.getCurrentValue("orphanRemoval");
            if (oldRelationHandler != null) {
                this.commandBuilder.buildFieldAnnotationRemoveCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), oldRelationHandler.getClassName()).execute();
            }
            if ((newRelation = RelationshipAnnotationValueHandler.createAnnotation(newRelationType, newCascadeTypes, newFetchMode, newOptional, newMappedBy, newOrphanRemoval, this.getContext().getAnnotationDefinitions())) != null) {
                this.getObjectField().addAnnotation(newRelation);
                this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), newRelation).execute();
            }
        }
    }

    protected void loadPropertyEditor() {
        this.view.loadPropertyEditorCategories(this.getPropertyEditorCategories());
    }

    protected List<PropertyEditorCategory> getPropertyEditorCategories() {
        ArrayList<PropertyEditorCategory> categories = new ArrayList<PropertyEditorCategory>();
        PropertyEditorCategory category = new PropertyEditorCategory(this.getIdentifierCategoryName(), 1);
        categories.add(category);
        category.withField((PropertyEditorFieldInfo)this.createIdentifierField());
        category.withField((PropertyEditorFieldInfo)this.createGeneratedValueField());
        category.withField((PropertyEditorFieldInfo)this.createSequenceGeneratorField());
        category = new PropertyEditorCategory(this.getColumnCategoryName(), 2);
        categories.add(category);
        category.withField((PropertyEditorFieldInfo)this.createColumnNameField());
        category.withField((PropertyEditorFieldInfo)this.createColumnUniqueField());
        category.withField((PropertyEditorFieldInfo)this.createColumnNullableField());
        category.withField((PropertyEditorFieldInfo)this.createColumnInsertableField());
        category.withField((PropertyEditorFieldInfo)this.createColumnUpdatableField());
        category = new PropertyEditorCategory(this.getRelationshipCategoryName(), 3);
        categories.add(category);
        category.withField((PropertyEditorFieldInfo)this.createRelationShipTypeField());
        return categories;
    }

    private DataModelerPropertyEditorFieldInfo createIdentifierField() {
        return this.createField(Constants.INSTANCE.persistence_domain_fieldEditor_identifier_field_label(), "IDENTIFIER_FIELD", "false", BooleanField.class, Constants.INSTANCE.persistence_domain_fieldEditor_identifier_field_help_heading(), Constants.INSTANCE.persistence_domain_fieldEditor_identifier_field_help());
    }

    private DataModelerPropertyEditorFieldInfo createGeneratedValueField() {
        return this.createField(Constants.INSTANCE.persistence_domain_fieldEditor_generation_strategy_field_label(), "GENERATED_VALUE_FIELD", "NONE", IdGeneratorField.class, Constants.INSTANCE.persistence_domain_fieldEditor_generation_strategy_field_help_heading(), Constants.INSTANCE.persistence_domain_fieldEditor_generation_strategy_field_help());
    }

    private DataModelerPropertyEditorFieldInfo createSequenceGeneratorField() {
        return this.createField(Constants.INSTANCE.persistence_domain_fieldEditor_sequence_generator_field_label(), "SEQUENCE_GENERATOR_FIELD", "NONE", SequenceGeneratorField.class, Constants.INSTANCE.persistence_domain_fieldEditor_sequence_generator_field_help_heading(), Constants.INSTANCE.persistence_domain_fieldEditor_sequence_generator_field_help());
    }

    private DataModelerPropertyEditorFieldInfo createColumnNameField() {
        return this.createField(Constants.INSTANCE.persistence_domain_fieldEditor_column_field_label(), "COLUMN_NAME_FIELD", "", TextField.class, Constants.INSTANCE.persistence_domain_fieldEditor_column_field_help_heading(), Constants.INSTANCE.persistence_domain_fieldEditor_column_field_help());
    }

    private DataModelerPropertyEditorFieldInfo createColumnUniqueField() {
        return this.createField(Constants.INSTANCE.persistence_domain_fieldEditor_unique_field_label(), "COLUMN_UNIQUE_FIELD", "false", BooleanField.class, Constants.INSTANCE.persistence_domain_fieldEditor_unique_field_help_heading(), Constants.INSTANCE.persistence_domain_fieldEditor_unique_field_help());
    }

    private DataModelerPropertyEditorFieldInfo createColumnNullableField() {
        return this.createField(Constants.INSTANCE.persistence_domain_fieldEditor_nullable_field_label(), "COLUMN_NULLABLE_FIELD", "true", BooleanField.class, Constants.INSTANCE.persistence_domain_fieldEditor_nullable_field_help_heading(), Constants.INSTANCE.persistence_domain_fieldEditor_nullable_field_help());
    }

    private DataModelerPropertyEditorFieldInfo createColumnInsertableField() {
        return this.createField(Constants.INSTANCE.persistence_domain_fieldEditor_insertable_field_label(), "COLUMN_INSERTABLE_FIELD", "true", BooleanField.class, Constants.INSTANCE.persistence_domain_fieldEditor_insertable_field_help_heading(), Constants.INSTANCE.persistence_domain_fieldEditor_insertable_field_help());
    }

    private DataModelerPropertyEditorFieldInfo createColumnUpdatableField() {
        return this.createField(Constants.INSTANCE.persistence_domain_fieldEditor_updatable_field_label(), "COLUMN_UPDATABLE_FIELD", "true", BooleanField.class, Constants.INSTANCE.persistence_domain_fieldEditor_updatable_field_help_heading(), Constants.INSTANCE.persistence_domain_fieldEditor_updatable_field_help());
    }

    private DataModelerPropertyEditorFieldInfo createRelationShipTypeField() {
        return this.createField(Constants.INSTANCE.persistence_domain_fieldEditor_relationship_field_label(), "RELATIONSHIP_TYPE_FIELD", Constants.INSTANCE.persistence_domain_fieldEditor_relationship_field_relation_not_set_message(), RelationshipField.class, Constants.INSTANCE.persistence_domain_fieldEditor_relationship_field_help_heading(), Constants.INSTANCE.persistence_domain_fieldEditor_relationship_field_help());
    }

    private DataModelerPropertyEditorFieldInfo createField(String label, String key, String currentStringValue, Class<?> customFieldClass) {
        DataModelerPropertyEditorFieldInfo fieldInfo = propertyEditorFields.get(key);
        if (fieldInfo == null) {
            fieldInfo = new DataModelerPropertyEditorFieldInfo(label, currentStringValue, customFieldClass);
            fieldInfo.withKey(key);
            propertyEditorFields.put(key, fieldInfo);
        }
        return fieldInfo;
    }

    private DataModelerPropertyEditorFieldInfo createField(String label, String key, String currentStringValue, Class<?> customFieldClass, String helpHeading, String helpText) {
        DataModelerPropertyEditorFieldInfo fieldInfo = propertyEditorFields.get(key);
        if (fieldInfo == null) {
            fieldInfo = new DataModelerPropertyEditorFieldInfo(label, currentStringValue, customFieldClass);
            fieldInfo.withKey(key);
            if (helpHeading != null) {
                fieldInfo.withHelpInfo(helpHeading, helpText);
            }
            propertyEditorFields.put(key, fieldInfo);
        }
        return fieldInfo;
    }

    private void updatePropertyEditorField(String fieldId, Annotation currentValue, String currentStringValue) {
        DataModelerPropertyEditorFieldInfo fieldInfo = propertyEditorFields.get(fieldId);
        fieldInfo.setCurrentValue(currentValue);
        fieldInfo.setCurrentStringValue(currentStringValue);
    }

    private DataModelerPropertyEditorFieldInfo getField(String fieldId) {
        return propertyEditorFields.get(fieldId);
    }

    private void updateIdentifierField(Annotation annotation) {
        this.clearIdentifierField();
        if (annotation != null) {
            this.updatePropertyEditorField("IDENTIFIER_FIELD", annotation, "true");
        }
    }

    private void updateColumnFields(Annotation annotation) {
        this.clearColumnFields();
        if (annotation != null) {
            String currentStringValue = AnnotationValueHandler.getStringValue(annotation, "name", "");
            this.updatePropertyEditorField("COLUMN_NAME_FIELD", annotation, currentStringValue);
            currentStringValue = AnnotationValueHandler.getStringValue(annotation, "unique", "false");
            this.updatePropertyEditorField("COLUMN_UNIQUE_FIELD", annotation, currentStringValue);
            currentStringValue = AnnotationValueHandler.getStringValue(annotation, "nullable", "true");
            this.updatePropertyEditorField("COLUMN_NULLABLE_FIELD", annotation, currentStringValue);
            currentStringValue = AnnotationValueHandler.getStringValue(annotation, "insertable", "true");
            this.updatePropertyEditorField("COLUMN_INSERTABLE_FIELD", annotation, currentStringValue);
            currentStringValue = AnnotationValueHandler.getStringValue(annotation, "updatable", "true");
            this.updatePropertyEditorField("COLUMN_UPDATABLE_FIELD", annotation, currentStringValue);
        }
    }

    private void updateGeneratedValueField(Annotation annotation) {
        this.clearGeneratedValueField();
        if (annotation != null) {
            DataModelerPropertyEditorFieldInfo fieldInfo = this.getField("GENERATED_VALUE_FIELD");
            String strategy = AnnotationValueHandler.getStringValue(annotation, "strategy", "NONE");
            String generator = AnnotationValueHandler.getStringValue(annotation, "generator", null);
            fieldInfo.setCurrentValue("strategy", strategy);
            fieldInfo.setCurrentValue("generator", generator);
            this.updatePropertyEditorField("GENERATED_VALUE_FIELD", annotation, strategy);
        }
    }

    private void updateSequenceGeneratorField(Annotation annotation) {
        this.clearSequenceGeneratorField();
        if (annotation != null) {
            SequenceGeneratorValueHandler valueHandler = new SequenceGeneratorValueHandler(annotation);
            DataModelerPropertyEditorFieldInfo fieldInfo = this.getField("SEQUENCE_GENERATOR_FIELD");
            fieldInfo.setCurrentValue("name", valueHandler.getName());
            fieldInfo.setCurrentValue("sequenceName", valueHandler.getSequenceName());
            fieldInfo.setCurrentValue("initialValue", valueHandler.getInitialValue());
            fieldInfo.setCurrentValue("allocationSize", valueHandler.getAllocationSize());
            this.updatePropertyEditorField("SEQUENCE_GENERATOR_FIELD", annotation, valueHandler.getName());
        }
    }

    private void updateRelationshipField(Annotation annotation) {
        this.clearRelationshipField();
        if (annotation != null) {
            RelationshipAnnotationValueHandler valueHandler = new RelationshipAnnotationValueHandler(annotation);
            DataModelerPropertyEditorFieldInfo fieldInfo = this.getField("RELATIONSHIP_TYPE_FIELD");
            fieldInfo.setCurrentValue("relationType", valueHandler.getRelationType());
            fieldInfo.setCurrentValue("cascade", valueHandler.getCascade());
            fieldInfo.setCurrentValue("fetch", valueHandler.getFetch());
            fieldInfo.setCurrentValue("optional", valueHandler.getOptional());
            fieldInfo.setCurrentValue("mappedBy", valueHandler.getMappedBy());
            fieldInfo.setCurrentValue("orphanRemoval", valueHandler.getOrphanRemoval());
            if (valueHandler.isOneToMany()) {
                fieldInfo.removeCurrentValue("optional");
            } else if (valueHandler.isManyToOne()) {
                fieldInfo.removeCurrentValue("mappedBy");
                fieldInfo.removeCurrentValue("orphanRemoval");
            } else if (valueHandler.isManyToMany()) {
                fieldInfo.removeCurrentValue("optional");
                fieldInfo.removeCurrentValue("orphanRemoval");
            }
            this.updatePropertyEditorField("RELATIONSHIP_TYPE_FIELD", annotation, valueHandler.getRelationType().name());
        }
    }

    boolean hasOnlyDefaultValues(Annotation columnAnnotation) {
        String strValue = (String)columnAnnotation.getValue("name");
        if (strValue != null && !"".equals(strValue)) {
            return false;
        }
        strValue = AnnotationValueHandler.getStringValue(columnAnnotation, "unique", null);
        if (strValue != null && !"false".equals(strValue)) {
            return false;
        }
        strValue = AnnotationValueHandler.getStringValue(columnAnnotation, "nullable", null);
        if (strValue != null && !"true".equals(strValue)) {
            return false;
        }
        strValue = AnnotationValueHandler.getStringValue(columnAnnotation, "insertable", null);
        if (strValue != null && !"true".equals(strValue)) {
            return false;
        }
        strValue = AnnotationValueHandler.getStringValue(columnAnnotation, "updatable", null);
        return strValue == null || "true".equals(strValue);
    }

    @Override
    public void clear() {
        this.clearIdentifierField();
        this.clearGeneratedValueField();
        this.clearSequenceGeneratorField();
        this.clearColumnFields();
        this.clearRelationshipField();
    }

    protected void clearIdentifierField() {
        this.updatePropertyEditorField("IDENTIFIER_FIELD", null, "false");
    }

    protected void clearGeneratedValueField() {
        this.updatePropertyEditorField("GENERATED_VALUE_FIELD", null, "NONE");
        this.getField("GENERATED_VALUE_FIELD").clearCurrentValues();
    }

    protected void clearSequenceGeneratorField() {
        this.updatePropertyEditorField("SEQUENCE_GENERATOR_FIELD", null, "NOT_SET");
        this.getField("SEQUENCE_GENERATOR_FIELD").clearCurrentValues();
    }

    protected void clearColumnFields() {
        this.updatePropertyEditorField("COLUMN_NAME_FIELD", null, null);
        this.updatePropertyEditorField("COLUMN_UNIQUE_FIELD", null, "false");
        this.updatePropertyEditorField("COLUMN_INSERTABLE_FIELD", null, "true");
        this.updatePropertyEditorField("COLUMN_NULLABLE_FIELD", null, "true");
        this.updatePropertyEditorField("COLUMN_UPDATABLE_FIELD", null, "true");
    }

    protected void clearRelationshipField() {
        this.updatePropertyEditorField("RELATIONSHIP_TYPE_FIELD", null, "NOT_SELECTED");
        this.getField("RELATIONSHIP_TYPE_FIELD").clearCurrentValues();
    }

    private Annotation getCurrentRelationshipAnnotation(ObjectProperty objectProperty) {
        Annotation annotation = this.objectField.getAnnotation("javax.persistence.OneToOne");
        if (annotation != null) {
            return annotation;
        }
        annotation = this.objectField.getAnnotation("javax.persistence.OneToMany");
        if (annotation != null) {
            return annotation;
        }
        annotation = this.objectField.getAnnotation("javax.persistence.ManyToOne");
        if (annotation != null) {
            return annotation;
        }
        annotation = this.objectField.getAnnotation("javax.persistence.ManyToMany");
        if (annotation != null) {
            return annotation;
        }
        return null;
    }

    private String getIdentifierCategoryName() {
        return Constants.INSTANCE.persistence_domain_fieldEditor_identifier_category();
    }

    private String getColumnCategoryName() {
        return Constants.INSTANCE.persistence_domain_fieldEditor_column_category();
    }

    private String getRelationshipCategoryName() {
        return Constants.INSTANCE.persistence_domain_fieldEditor_relationship_category();
    }
}

