/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.properties;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.shared.event.ModalHiddenEvent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenHandler;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.kie.workbench.common.screens.datamodeller.client.model.DataModelerPropertyEditorFieldInfo;
import org.kie.workbench.common.screens.datamodeller.client.util.UIUtil;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.properties.PropertyEditionPopup;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class IdGeneratorEditionDialog
extends BaseModal
implements PropertyEditionPopup {
    @UiField
    Select generatorType;
    @UiField
    TextBox generatorName;
    private Boolean revertChanges = Boolean.TRUE;
    PropertyEditorFieldInfo property;
    Command okCommand;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public IdGeneratorEditionDialog() {
        this.setTitle("Generation Strategy");
        this.setBody((Widget)uiBinder.createAndBindUi(this));
        this.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                IdGeneratorEditionDialog.this.okButton();
            }
        }, new Command(){

            public void execute() {
                IdGeneratorEditionDialog.this.cancelButton();
            }
        }));
        this.generatorType.add((Widget)UIUtil.newOption("NONE", "NONE"));
        this.generatorType.add((Widget)UIUtil.newOption("SEQUENCE", "SEQUENCE"));
        this.generatorType.add((Widget)UIUtil.newOption("TABLE", "TABLE"));
        this.generatorType.add((Widget)UIUtil.newOption("IDENTITY", "IDENTITY"));
        this.generatorType.add((Widget)UIUtil.newOption("AUTO", "AUTO"));
        UIUtil.refreshSelect(this.generatorType);
    }

    private void addHiddlenHandler() {
        this.addHiddenHandler(new ModalHiddenHandler(){

            public void onHidden(ModalHiddenEvent hiddenEvent) {
                if (IdGeneratorEditionDialog.this.userPressCloseOrCancel()) {
                    IdGeneratorEditionDialog.this.revertChanges();
                }
            }
        });
    }

    private void revertChanges() {
    }

    private boolean userPressCloseOrCancel() {
        return this.revertChanges;
    }

    @Override
    public void show() {
        DataModelerPropertyEditorFieldInfo fieldInfo = (DataModelerPropertyEditorFieldInfo)this.property;
        String strategy = (String)fieldInfo.getCurrentValue("strategy");
        String generator = (String)fieldInfo.getCurrentValue("generator");
        strategy = strategy != null ? strategy : "NONE";
        UIUtil.setSelectedValue(this.generatorType, strategy);
        this.generatorName.setText(generator);
        super.show();
    }

    @Override
    public void setOkCommand(Command okCommand) {
        this.okCommand = okCommand;
    }

    @Override
    public void setProperty(PropertyEditorFieldInfo property) {
        this.property = property;
    }

    void okButton() {
        DataModelerPropertyEditorFieldInfo fieldInfo = (DataModelerPropertyEditorFieldInfo)this.property;
        String strategy = this.generatorType.getValue();
        strategy = "NONE".equals(strategy) ? null : strategy;
        String generator = this.generatorName.getText();
        fieldInfo.setCurrentValue("strategy", strategy);
        fieldInfo.setCurrentValue("generator", generator);
        super.hide();
        this.revertChanges = Boolean.FALSE;
        if (this.okCommand != null) {
            this.okCommand.execute();
        }
    }

    void cancelButton() {
        super.hide();
    }

    public void hide() {
        super.hide();
    }

    @Override
    public String getStringValue() {
        return this.generatorType.getValue();
    }

    @Override
    public void setStringValue(String value) {
    }

    static interface Binder
    extends UiBinder<Widget, IdGeneratorEditionDialog> {
    }
}

