/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.properties;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.gwtbootstrap3.client.shared.event.ModalHiddenEvent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenHandler;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.kie.workbench.common.screens.datamodeller.client.model.DataModelerPropertyEditorFieldInfo;
import org.kie.workbench.common.screens.datamodeller.client.util.UIUtil;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.properties.PropertyEditionPopup;
import org.kie.workbench.common.screens.datamodeller.model.jpadomain.CascadeType;
import org.kie.workbench.common.screens.datamodeller.model.jpadomain.FetchMode;
import org.kie.workbench.common.screens.datamodeller.model.jpadomain.RelationType;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class RelationshipEditionDialog
extends BaseModal
implements PropertyEditionPopup {
    @UiField
    Select relationType;
    @UiField
    Select fetchMode;
    @UiField
    CheckBox optional;
    @UiField
    FormLabel optionalLabel;
    @UiField
    FormLabel mappedByLabel;
    @UiField
    TextBox mappedBy;
    @UiField
    FormLabel orphanRemovalLabel;
    @UiField
    CheckBox orphanRemoval;
    @UiField
    CheckBox cascadeAll;
    @UiField
    CheckBox cascadePersist;
    @UiField
    CheckBox cascadeMerge;
    @UiField
    CheckBox cascadeRemove;
    @UiField
    CheckBox cascadeRefresh;
    @UiField
    CheckBox cascadeDetach;
    private Boolean revertChanges = Boolean.TRUE;
    PropertyEditorFieldInfo property;
    Command okCommand;
    private boolean cascadeAllWasClicked = false;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public RelationshipEditionDialog() {
        this.setTitle("Relationship configuration");
        this.setBody((Widget)uiBinder.createAndBindUi(this));
        this.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                RelationshipEditionDialog.this.okButton();
            }
        }, new Command(){

            public void execute() {
                RelationshipEditionDialog.this.cancelButton();
            }
        }));
        this.relationType.add((Widget)UIUtil.newOption("Not set", "NOT_SELECTED"));
        this.relationType.add((Widget)UIUtil.newOption("One to One", RelationType.ONE_TO_ONE.name()));
        this.relationType.add((Widget)UIUtil.newOption("One to Many", RelationType.ONE_TO_MANY.name()));
        this.relationType.add((Widget)UIUtil.newOption("Many to One", RelationType.MANY_TO_ONE.name()));
        this.relationType.add((Widget)UIUtil.newOption("Many to Many", RelationType.MANY_TO_MANY.name()));
        this.relationType.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RelationshipEditionDialog.this.relationTypeChanged();
            }
        });
        this.fetchMode.add((Widget)UIUtil.newOption("EAGER", FetchMode.EAGER.name()));
        this.fetchMode.add((Widget)UIUtil.newOption("LAZY", FetchMode.LAZY.name()));
    }

    private void relationTypeChanged() {
        String strValue = this.relationType.getValue();
        if (!"NOT_SELECTED".equals(strValue)) {
            RelationType type = RelationType.valueOf((String)this.relationType.getValue());
            this.enableRelationDependentFields(type);
        }
    }

    private void enableRelationDependentFields(RelationType relationType) {
        if (relationType != null) {
            switch (relationType) {
                case ONE_TO_ONE: {
                    this.enableOptional(true);
                    this.enableMappedBy(true);
                    this.enableOrphanRemoval(true);
                    break;
                }
                case ONE_TO_MANY: {
                    this.enableOptional(false);
                    this.enableMappedBy(true);
                    this.enableOrphanRemoval(true);
                    break;
                }
                case MANY_TO_ONE: {
                    this.enableOptional(true);
                    this.enableMappedBy(false);
                    this.enableOrphanRemoval(false);
                    break;
                }
                case MANY_TO_MANY: {
                    this.enableOptional(false);
                    this.enableMappedBy(true);
                    this.enableOrphanRemoval(false);
                }
            }
        }
    }

    private void enableOptional(boolean value) {
        this.optionalLabel.setVisible(value);
        this.optional.setVisible(value);
    }

    private void enableOrphanRemoval(boolean value) {
        this.orphanRemovalLabel.setVisible(value);
        this.orphanRemoval.setVisible(value);
    }

    private void enableMappedBy(boolean value) {
        this.mappedByLabel.setVisible(value);
        this.mappedBy.setVisible(value);
    }

    private void addHiddlenHandler() {
        this.addHiddenHandler(new ModalHiddenHandler(){

            public void onHidden(ModalHiddenEvent hiddenEvent) {
                if (RelationshipEditionDialog.this.userPressCloseOrCancel()) {
                    RelationshipEditionDialog.this.revertChanges();
                }
            }
        });
    }

    private void revertChanges() {
    }

    private boolean userPressCloseOrCancel() {
        return this.revertChanges;
    }

    @Override
    public void show() {
        DataModelerPropertyEditorFieldInfo fieldInfo = (DataModelerPropertyEditorFieldInfo)this.property;
        RelationType relationTypeValue = (RelationType)fieldInfo.getCurrentValue("relationType");
        if (relationTypeValue != null) {
            UIUtil.setSelectedValue(this.relationType, relationTypeValue.name());
        } else {
            UIUtil.setSelectedValue(this.relationType, "NOT_SELECTED");
        }
        this.enableRelationDependentFields(relationTypeValue);
        this.cascadeAllWasClicked = false;
        this.setCascadeTypes((List)fieldInfo.getCurrentValue("cascade"));
        this.enableCascadeTypes(true, true);
        FetchMode fetchModeValue = (FetchMode)fieldInfo.getCurrentValue("fetch");
        if (fetchModeValue != null) {
            UIUtil.setSelectedValue(this.fetchMode, fetchModeValue.name());
        } else {
            UIUtil.setSelectedValue(this.fetchMode, "NOT_SELECTED");
        }
        String mappedBy = (String)fieldInfo.getCurrentValue("mappedBy");
        this.mappedBy.setText(mappedBy);
        Boolean orphanRemovalValue = (Boolean)fieldInfo.getCurrentValue("orphanRemoval");
        if (orphanRemovalValue != null) {
            this.orphanRemoval.setValue(orphanRemovalValue);
        }
        super.show();
    }

    @Override
    public void setOkCommand(Command okCommand) {
        this.okCommand = okCommand;
    }

    @Override
    public void setProperty(PropertyEditorFieldInfo property) {
        this.property = property;
    }

    void okButton() {
        DataModelerPropertyEditorFieldInfo fieldInfo = (DataModelerPropertyEditorFieldInfo)this.property;
        String relationTypeValueStr = this.relationType.getValue();
        fieldInfo.removeCurrentValue("relationType");
        fieldInfo.removeCurrentValue("cascade");
        fieldInfo.removeCurrentValue("fetch");
        fieldInfo.removeCurrentValue("optional");
        fieldInfo.removeCurrentValue("mappedBy");
        fieldInfo.removeCurrentValue("orphanRemoval");
        if (!relationTypeValueStr.equals("NOT_SELECTED")) {
            fieldInfo.setCurrentValue("relationType", RelationType.valueOf((String)this.relationType.getValue()));
            fieldInfo.setCurrentValue("cascade", this.getCascadeTypes());
            fieldInfo.setCurrentValue("fetch", FetchMode.valueOf((String)this.fetchMode.getValue()));
            if (this.relationType.getValue().equals(RelationType.ONE_TO_ONE.name()) || this.relationType.getValue().equals(RelationType.MANY_TO_ONE.name())) {
                fieldInfo.setCurrentValue("optional", this.optional.getValue());
            }
            if (this.relationType.getValue().equals(RelationType.ONE_TO_ONE.name()) || this.relationType.getValue().equals(RelationType.ONE_TO_MANY.name()) || this.relationType.getValue().equals(RelationType.MANY_TO_MANY.name())) {
                fieldInfo.setCurrentValue("mappedBy", this.mappedBy.getText());
            }
            if (this.relationType.getValue().equals(RelationType.ONE_TO_ONE.name()) || this.relationType.getValue().equals(RelationType.ONE_TO_MANY.name())) {
                fieldInfo.setCurrentValue("orphanRemoval", this.orphanRemoval.getValue());
            }
        } else {
            fieldInfo.setCurrentValue("relationType", null);
        }
        super.hide();
        this.revertChanges = Boolean.FALSE;
        if (this.okCommand != null) {
            this.okCommand.execute();
        }
    }

    void cancelButton() {
        super.hide();
    }

    public void hide() {
        super.hide();
    }

    @Override
    public String getStringValue() {
        String value = this.relationType.getValue();
        if (value == null || "".equals(value)) {
            value = "NOT_SET";
        }
        return value;
    }

    @Override
    public void setStringValue(String value) {
    }

    private void setCascadeTypes(List<CascadeType> cascadeTypes) {
        this.cascadeAll.setValue(Boolean.valueOf(cascadeTypes != null && cascadeTypes.contains(CascadeType.ALL)));
        this.cascadePersist.setValue(Boolean.valueOf(cascadeTypes != null && cascadeTypes.contains(CascadeType.PERSIST)));
        this.cascadeMerge.setValue(Boolean.valueOf(cascadeTypes != null && cascadeTypes.contains(CascadeType.MERGE)));
        this.cascadeRemove.setValue(Boolean.valueOf(cascadeTypes != null && cascadeTypes.contains(CascadeType.REMOVE)));
        this.cascadeRefresh.setValue(Boolean.valueOf(cascadeTypes != null && cascadeTypes.contains(CascadeType.REFRESH)));
        this.cascadeDetach.setValue(Boolean.valueOf(cascadeTypes != null && cascadeTypes.contains(CascadeType.DETACH)));
    }

    private List<CascadeType> getCascadeTypes() {
        ArrayList<CascadeType> cascadeTypes = new ArrayList<CascadeType>();
        if (this.cascadeAll.getValue().booleanValue()) {
            cascadeTypes.add(CascadeType.ALL);
            if (this.cascadeAllWasClicked) {
                return cascadeTypes;
            }
        }
        if (this.cascadePersist.getValue().booleanValue()) {
            cascadeTypes.add(CascadeType.PERSIST);
        }
        if (this.cascadeMerge.getValue().booleanValue()) {
            cascadeTypes.add(CascadeType.MERGE);
        }
        if (this.cascadeRemove.getValue().booleanValue()) {
            cascadeTypes.add(CascadeType.REMOVE);
        }
        if (this.cascadeRefresh.getValue().booleanValue()) {
            cascadeTypes.add(CascadeType.REFRESH);
        }
        if (this.cascadeDetach.getValue().booleanValue()) {
            cascadeTypes.add(CascadeType.DETACH);
        }
        return cascadeTypes;
    }

    @UiHandler(value={"cascadeAll"})
    void onCascadeAllChanged(ClickEvent clickEvent) {
        if (this.cascadeAll.getValue().booleanValue()) {
            this.enableCascadeTypes(true, false);
            this.cascadePersist.setValue(Boolean.valueOf(true));
            this.cascadeMerge.setValue(Boolean.valueOf(true));
            this.cascadeRemove.setValue(Boolean.valueOf(true));
            this.cascadeRefresh.setValue(Boolean.valueOf(true));
            this.cascadeDetach.setValue(Boolean.valueOf(true));
        } else {
            this.enableCascadeTypes(true, true);
            if (this.cascadeAllWasClicked) {
                this.cascadePersist.setValue(Boolean.valueOf(false));
                this.cascadeMerge.setValue(Boolean.valueOf(false));
                this.cascadeRemove.setValue(Boolean.valueOf(false));
                this.cascadeRefresh.setValue(Boolean.valueOf(false));
                this.cascadeDetach.setValue(Boolean.valueOf(false));
            }
        }
        this.cascadeAllWasClicked = true;
    }

    private void enableCascadeTypes(boolean enableCascadeAll, boolean enableTheRest) {
        this.cascadeAll.setEnabled(enableCascadeAll);
        this.cascadePersist.setEnabled(enableTheRest);
        this.cascadeMerge.setEnabled(enableTheRest);
        this.cascadeRemove.setEnabled(enableTheRest);
        this.cascadeRefresh.setEnabled(enableTheRest);
        this.cascadeDetach.setEnabled(enableTheRest);
    }

    static interface Binder
    extends UiBinder<Widget, RelationshipEditionDialog> {
    }
}

