/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.properties;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.shared.event.ModalHiddenEvent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenHandler;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.screens.datamodeller.client.model.DataModelerPropertyEditorFieldInfo;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.properties.PropertyEditionPopup;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class SequenceGeneratorEditionDialog
extends BaseModal
implements PropertyEditionPopup {
    @UiField
    TextBox generatorName;
    @UiField
    TextBox sequenceName;
    @UiField
    TextBox initialValue;
    @UiField
    TextBox allocationSize;
    private Boolean revertChanges = Boolean.TRUE;
    PropertyEditorFieldInfo property;
    Command okCommand;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public SequenceGeneratorEditionDialog() {
        this.setTitle("Sequence Generator");
        this.add((Widget)new ModalBody(){
            {
                this.add((Widget)uiBinder.createAndBindUi(SequenceGeneratorEditionDialog.this));
            }
        });
        this.add((Widget)new ModalFooterOKCancelButtons(new Command(){

            public void execute() {
                SequenceGeneratorEditionDialog.this.okButton();
            }
        }, new Command(){

            public void execute() {
                SequenceGeneratorEditionDialog.this.cancelButton();
            }
        }));
    }

    private void addHiddlenHandler() {
        this.addHiddenHandler(new ModalHiddenHandler(){

            public void onHidden(ModalHiddenEvent hiddenEvent) {
                if (SequenceGeneratorEditionDialog.this.userPressCloseOrCancel()) {
                    SequenceGeneratorEditionDialog.this.revertChanges();
                }
            }
        });
    }

    private void revertChanges() {
    }

    private boolean userPressCloseOrCancel() {
        return this.revertChanges;
    }

    @Override
    public void show() {
        DataModelerPropertyEditorFieldInfo fieldInfo = (DataModelerPropertyEditorFieldInfo)this.property;
        String sequenceName = (String)fieldInfo.getCurrentValue("sequenceName");
        String generatorName = (String)fieldInfo.getCurrentValue("name");
        Object initialValue = fieldInfo.getCurrentValue("initialValue");
        Object allocationSize = fieldInfo.getCurrentValue("allocationSize");
        this.sequenceName.setText(sequenceName);
        this.generatorName.setText(generatorName);
        this.initialValue.setText(initialValue != null ? initialValue.toString() : null);
        this.allocationSize.setText(allocationSize != null ? allocationSize.toString() : null);
        super.show();
    }

    @Override
    public void setOkCommand(Command okCommand) {
        this.okCommand = okCommand;
    }

    @Override
    public void setProperty(PropertyEditorFieldInfo property) {
        this.property = property;
    }

    void okButton() {
        DataModelerPropertyEditorFieldInfo fieldInfo = (DataModelerPropertyEditorFieldInfo)this.property;
        String sequenceName = this.sequenceName.getText();
        String generatorName = this.generatorName.getText();
        fieldInfo.setCurrentValue("sequenceName", sequenceName);
        fieldInfo.setCurrentValue("name", generatorName);
        fieldInfo.setCurrentValue("initialValue", this.getInitialValue());
        fieldInfo.setCurrentValue("allocationSize", this.getAllocationSize());
        super.hide();
        this.revertChanges = Boolean.FALSE;
        if (this.okCommand != null) {
            this.okCommand.execute();
        }
    }

    private Integer getInitialValue() {
        return this.parseInt(this.initialValue.getText());
    }

    private Integer getAllocationSize() {
        return this.parseInt(this.allocationSize.getText());
    }

    private Integer parseInt(String value) {
        Integer result = null;
        if (value != null && !"".equals(value.trim())) {
            try {
                result = Integer.parseInt(value.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    void cancelButton() {
        super.hide();
    }

    public void hide() {
        super.hide();
    }

    @Override
    public String getStringValue() {
        String value = this.generatorName.getText();
        if (value == null || "".equals(value)) {
            value = "NOT_SET";
        }
        return value;
    }

    @Override
    public void setStringValue(String value) {
    }

    static interface Binder
    extends UiBinder<Widget, SequenceGeneratorEditionDialog> {
    }
}

