/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.packageselector;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.screens.datamodeller.client.widgets.packageselector.PackageSelectorView;
import org.uberfire.commons.data.Pair;
import org.uberfire.mvp.Command;

@Dependent
public class PackageSelector
implements PackageSelectorView.Presenter,
IsWidget {
    private DataModelerContext context;
    private List<String> packageList = new ArrayList<String>();
    private PackageSelectorView view;
    private List<PackageSelectorView.PackageSelectorHandler> handlers = new ArrayList<PackageSelectorView.PackageSelectorHandler>();

    @Inject
    public PackageSelector(PackageSelectorView view) {
        this.view = view;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void onPackageChange() {
        this.handlePackageChange(this.view.getPackage());
    }

    @Override
    public void onNewPackage() {
        this.view.showNewPackagePopup(new Command(){

            public void execute() {
                PackageSelector.this.doPackageAdded(PackageSelector.this.view.getNewPackage());
            }
        });
    }

    private void doPackageAdded(String newPackage) {
        String newPackageName = DataModelerUtils.trim(newPackage);
        if (newPackageName != null && !"".equals(newPackageName)) {
            boolean exists = this.packageList.contains(newPackageName);
            if (exists) {
                this.view.setPackage(newPackageName);
            } else {
                this.view.addToPackageList(newPackageName, true);
            }
            if (this.context != null) {
                this.context.appendPackage(newPackageName.trim());
            }
        }
        this.handlePackageAdded(newPackageName);
    }

    private void handlePackageAdded(String packageName) {
        for (PackageSelectorView.PackageSelectorHandler handler : this.handlers) {
            handler.onPackageAdded(packageName);
        }
    }

    private void handlePackageChange(String packageName) {
        for (PackageSelectorView.PackageSelectorHandler handler : this.handlers) {
            handler.onPackageChange(packageName);
        }
    }

    public void enableCreatePackage(boolean enable) {
        this.view.enableCreatePackage(enable);
    }

    public void setEnabled(boolean enabled) {
        this.view.setEnabled(enabled);
    }

    public boolean isValueSelected() {
        String currentPackage = DataModelerUtils.trim(this.view.getPackage());
        return currentPackage != null && !"".equals(currentPackage) && !"NOT_SELECTED".equals(currentPackage);
    }

    public String getPackage() {
        return this.view.getPackage();
    }

    public String getNewPackage() {
        return this.view.getNewPackage();
    }

    public DataModelerContext getContext() {
        return this.context;
    }

    public void setContext(DataModelerContext context) {
        this.context = context;
        this.initList(null, true);
    }

    public void setCurrentPackage(String currentPackage) {
        boolean enableEmptyPackageOption = false;
        if (currentPackage == null || "".equals(currentPackage)) {
            enableEmptyPackageOption = true;
            currentPackage = "NOT_SELECTED";
        }
        this.initList(currentPackage, enableEmptyPackageOption);
    }

    public void clear() {
        this.view.initPackageList(new ArrayList<Pair<String, String>>(), null, true);
    }

    public void addPackageSelectorHandler(PackageSelectorView.PackageSelectorHandler handler) {
        if (!this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    private void initList(String currentPackage, boolean enableEmptyPackageOption) {
        this.packageList.clear();
        if (this.context != null && this.context.getCurrentProjectPackages() != null) {
            for (String packageName : this.context.getCurrentProjectPackages()) {
                this.packageList.add(packageName);
            }
        }
        if (currentPackage != null && !this.packageList.contains(currentPackage)) {
            this.packageList.add(currentPackage);
        }
        Collections.sort(this.packageList);
        ArrayList<Pair<String, String>> packageOptions = new ArrayList<Pair<String, String>>(this.packageList.size());
        for (String packageName : this.packageList) {
            packageOptions.add((Pair<String, String>)new Pair((Object)packageName, (Object)packageName));
        }
        this.view.initPackageList(packageOptions, currentPackage, enableEmptyPackageOption);
    }
}

