/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kie.workbench.common.screens.datamodeller.client.DataModelHelper;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.screens.datamodeller.model.EditorModelContent;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.PropertyType;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.backend.vfs.Path;

public class DataModelerContext {
    private DataModelHelper helper;
    private Map<String, AnnotationDefinition> annotationDefinitions = new HashMap<String, AnnotationDefinition>();
    private List<PropertyType> baseTypes = new ArrayList<PropertyType>();
    private boolean readonly = false;
    private Set<String> currentProjectPackages = new HashSet<String>();
    private EditorModelContent editorModelContent;
    private ObjectProperty objectProperty;
    private String contextId;
    private EditionStatus editionStatus = EditionStatus.NO_CHANGES;
    private ParseStatus parseStatus = ParseStatus.NOT_PARSED;
    private EditionMode editionMode = EditionMode.GRAPHICAL_MODE;

    public DataModelerContext() {
    }

    public DataModelerContext(String contextId) {
        this.contextId = contextId;
        this.helper = new DataModelHelper(contextId);
    }

    public void init(List<PropertyType> baseTypes) {
        this.baseTypes = baseTypes;
        this.helper.setBaseTypes(baseTypes);
    }

    public DataModel getDataModel() {
        return this.editorModelContent != null ? this.editorModelContent.getDataModel() : null;
    }

    public DataModelHelper getHelper() {
        return this.helper;
    }

    public Map<String, AnnotationDefinition> getAnnotationDefinitions() {
        return this.annotationDefinitions;
    }

    public void setAnnotationDefinitions(Map<String, AnnotationDefinition> annotationDefinitions) {
        this.annotationDefinitions = annotationDefinitions;
    }

    public AnnotationDefinition getAnnotationDefinition(String className) {
        return this.getAnnotationDefinitions().get(className);
    }

    public List<PropertyType> getBaseTypes() {
        return this.baseTypes;
    }

    public ParseStatus getParseStatus() {
        return this.parseStatus;
    }

    public void setParseStatus(ParseStatus parseStatus) {
        this.parseStatus = parseStatus;
    }

    public boolean isParsed() {
        return this.getParseStatus() == ParseStatus.PARSED;
    }

    public boolean isNotParsed() {
        return this.getParseStatus() == ParseStatus.NOT_PARSED;
    }

    public boolean isParseErrors() {
        return this.getParseStatus() == ParseStatus.PARSE_ERRORS;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isEditorChanged() {
        return this.editionStatus == EditionStatus.EDITOR_CHANGED;
    }

    public boolean isSourceChanged() {
        return this.editionStatus == EditionStatus.SOURCE_CHANGED;
    }

    public void appendPackages(Collection<String> packages) {
        if (packages != null) {
            for (String packageToAppend : packages) {
                if ("".equals(packageToAppend) || this.currentProjectPackages.contains(packageToAppend)) continue;
                this.currentProjectPackages.add(packageToAppend);
            }
        }
    }

    public void appendPackage(String packageName) {
        if (packageName != null && !"".equals(packageName)) {
            String[] subPackages = DataModelerUtils.calculateSubPackages(packageName);
            String subPackage = null;
            for (int i = 0; subPackages != null && i < subPackages.length; ++i) {
                subPackage = subPackages[i];
                if (this.currentProjectPackages.contains(subPackage)) continue;
                this.currentProjectPackages.add(subPackage);
            }
        }
    }

    public Set<String> getCurrentProjectPackages() {
        return this.currentProjectPackages;
    }

    public void cleanPackages() {
        if (this.currentProjectPackages != null) {
            this.currentProjectPackages.clear();
        }
    }

    public boolean isDataObjectLoaded() {
        return this.getDataObject() != null;
    }

    public KieProject getCurrentProject() {
        if (this.editorModelContent != null) {
            return this.editorModelContent.getCurrentProject();
        }
        return null;
    }

    public DataObject getDataObject() {
        if (this.editorModelContent != null) {
            return this.editorModelContent.getDataObject();
        }
        return null;
    }

    public void setDataObject(DataObject dataObject) {
        if (this.editorModelContent != null) {
            this.editorModelContent.setDataObject(dataObject);
        }
    }

    public ObjectProperty getObjectProperty() {
        return this.objectProperty;
    }

    public void setObjectProperty(ObjectProperty objectProperty) {
        this.objectProperty = objectProperty;
    }

    public Path getDataObjectPath(String className) {
        return this.editorModelContent != null && this.editorModelContent.getDataObjectPaths() != null ? (Path)this.editorModelContent.getDataObjectPaths().get(className) : null;
    }

    public EditionStatus getEditionStatus() {
        return this.editionStatus;
    }

    public void setEditionStatus(EditionStatus editionStatus) {
        this.editionStatus = editionStatus;
    }

    public EditionMode getEditionMode() {
        return this.editionMode;
    }

    public void setEditionMode(EditionMode editionMode) {
        this.editionMode = editionMode;
    }

    public EditorModelContent getEditorModelContent() {
        return this.editorModelContent;
    }

    public void setEditorModelContent(EditorModelContent editorModelContent) {
        this.editorModelContent = editorModelContent;
        if (editorModelContent.getDataModel() != null) {
            this.helper.setDataModel(editorModelContent.getDataModel());
        }
        this.cleanPackages();
        this.appendPackages(editorModelContent.getCurrentProjectPackages());
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public void clear() {
        this.annotationDefinitions = null;
        this.baseTypes = null;
        if (this.getDataModel() != null && this.getDataModel().getDataObjects() != null) {
            this.getDataModel().getDataObjects().clear();
        }
        this.cleanPackages();
        this.helper = new DataModelHelper(this.contextId);
    }

    public static enum EditionMode {
        SOURCE_MODE,
        GRAPHICAL_MODE;

    }

    public static enum ParseStatus {
        PARSED,
        NOT_PARSED,
        PARSE_ERRORS;

    }

    public static enum EditionStatus {
        NO_CHANGES,
        EDITOR_CHANGED,
        SOURCE_CHANGED;

    }
}

