/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.command;

import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.AbstractDataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelChangeNotifier;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;

public class FieldTypeChangeCommand
extends AbstractDataModelCommand {
    protected ObjectProperty field;
    protected boolean multiple;

    public FieldTypeChangeCommand(DataModelerContext context, String source, DataObject dataObject, ObjectProperty field, String newType, boolean multiple, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, null, null, newType, false, notifier);
        this.field = field;
        this.multiple = multiple;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public ObjectProperty getField() {
        return this.field;
    }

    public void setField(ObjectProperty field) {
        this.field = field;
    }

    @Override
    public void execute() {
        String oldType = this.field.getClassName();
        String newType = (String)this.newValue;
        this.field.setClassName(newType);
        this.field.setMultiple(this.multiple);
        if (this.multiple && this.field.getBag() == null) {
            this.field.setBag("java.util.List");
        }
        if (!this.getContext().getHelper().isBaseType(newType).booleanValue()) {
            this.getContext().getHelper().dataObjectUnReferenced(oldType, this.getDataObject().getClassName());
            this.getContext().getHelper().dataObjectReferenced(newType, this.getDataObject().getClassName());
        }
        this.notifyFieldChange(ChangeType.FIELD_TYPE_CHANGE, this.context, this.source, this.dataObject, this.field, null, null, oldType, newType);
    }
}

