/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kie.workbench.common.screens.datamodeller.client.util.AnnotationValueHandler;
import org.kie.workbench.common.screens.datamodeller.client.util.ReflectionUtil;
import org.kie.workbench.common.screens.datamodeller.client.util.UIUtil;
import org.kie.workbench.common.services.datamodel.util.SortHelper;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.HasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.JavaEnum;
import org.kie.workbench.common.services.datamodeller.core.JavaType;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.PropertyType;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.data.Pair;

public class DataModelerUtils {
    public static final String EXTERNAL_PREFIX = "- ext - ";
    public static final String CLIPPED_MARKER = "...";

    public static String getDataObjectUILabel(DataObject dataObject) {
        if (dataObject != null) {
            String label = AnnotationValueHandler.getStringValue((HasAnnotations)dataObject, "org.kie.api.definition.type.Label");
            if (label == null) {
                label = dataObject.getName();
            }
            return label;
        }
        return "";
    }

    public static String getMaxLengthClippedString(String s, int maxLength) {
        return s.length() > maxLength ? s.substring(0, maxLength) + CLIPPED_MARKER : s;
    }

    public static String getDataObjectFullLabel(DataObject dataObject) {
        return DataModelerUtils.getDataObjectFullLabel(dataObject, true);
    }

    public static String getDataObjectFullLabel(DataObject dataObject, boolean includePackage) {
        StringBuilder sb = new StringBuilder("");
        if (dataObject != null) {
            sb.append(includePackage ? dataObject.getClassName() : dataObject.getName());
            String objectLabel = AnnotationValueHandler.getStringValue((HasAnnotations)dataObject, "org.kie.api.definition.type.Label");
            if (objectLabel != null) {
                sb.insert(0, objectLabel + " (").append(")");
            }
        }
        return sb.toString();
    }

    public static String assembleClassName(String objPackage, String objName) {
        if (objName == null || objName.length() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(objName);
        if (objPackage != null && !"".equals(objPackage)) {
            sb.insert(0, ".").insert(0, objPackage);
        }
        return sb.toString();
    }

    public static String extractClassName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        int index = fullClassName.lastIndexOf(".");
        if (index > 0) {
            return fullClassName.substring(index + 1, fullClassName.length());
        }
        return fullClassName;
    }

    public static String extractPackageName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        int index = fullClassName.lastIndexOf(".");
        if (index > 0) {
            return fullClassName.substring(0, index);
        }
        return null;
    }

    public static String extractSimpleFileName(Path path) {
        if (path == null) {
            return null;
        }
        String fileNameWithExtension = path.getFileName();
        return fileNameWithExtension.substring(0, fileNameWithExtension.lastIndexOf("."));
    }

    public static String[] getPackageTerms(String packageName) {
        return packageName.split("\\.", -1);
    }

    public static String[] calculateSubPackages(String packageName) {
        String[] packageTerms;
        if (packageName == null || (packageTerms = DataModelerUtils.getPackageTerms(packageName)) == null) {
            return null;
        }
        String[] subpackages = new String[packageTerms.length];
        for (int i = 0; i < packageTerms.length; ++i) {
            String subpackage = "";
            for (int j = 0; j <= i; ++j) {
                subpackage = subpackage + packageTerms[j];
                if (j >= i) continue;
                subpackage = subpackage + ".";
            }
            subpackages[i] = subpackage;
        }
        return subpackages;
    }

    public static String unCapitalize(String str) {
        int strLen;
        int n = strLen = str != null ? str.length() : 0;
        if (strLen == 0) {
            return str;
        }
        if (strLen > 1 && Character.isUpperCase(str.charAt(0)) && Character.isUpperCase(str.charAt(1))) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toLowerCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static List<ObjectProperty> getFieldsUsingPosition(DataObject dataObject, int position, String skipField) {
        ArrayList<ObjectProperty> fields = new ArrayList<ObjectProperty>();
        if (dataObject != null && dataObject.getProperties() != null) {
            for (ObjectProperty property : dataObject.getProperties()) {
                String currentPosition;
                if (skipField != null && skipField.equals(property.getName()) || (currentPosition = AnnotationValueHandler.getStringValue(property.getAnnotation("org.kie.api.definition.type.Position"), "value")) == null || !currentPosition.trim().equals(position + "")) continue;
                fields.add(property);
            }
        }
        return fields;
    }

    public static Integer getMaxPosition(DataObject dataObject) {
        List properties = dataObject.getProperties();
        Integer maxPosition = -1;
        if (properties != null && properties.size() > 0) {
            for (ObjectProperty property : properties) {
                Integer currentPosition;
                try {
                    currentPosition = new Integer(AnnotationValueHandler.getStringValue((HasAnnotations)property, "org.kie.api.definition.type.Position", "value", "-1"));
                }
                catch (Exception e) {
                    currentPosition = -1;
                }
                if (currentPosition <= maxPosition) continue;
                maxPosition = currentPosition;
            }
        }
        return maxPosition;
    }

    public static boolean hasPosition(ObjectProperty property) {
        return property != null && property.getAnnotation("org.kie.api.definition.type.Position") != null;
    }

    public static List<ObjectProperty> getManagedProperties(DataObject dataObject) {
        ArrayList<ObjectProperty> editableProperties = new ArrayList<ObjectProperty>();
        if (dataObject != null && dataObject.getProperties() != null) {
            for (ObjectProperty property : dataObject.getProperties()) {
                if (!DataModelerUtils.isManagedProperty(property)) continue;
                editableProperties.add(property);
            }
        }
        return editableProperties;
    }

    public static boolean isManagedProperty(ObjectProperty property) {
        return !property.isFinal() && !property.isStatic();
    }

    public static String calculateExpectedClassName(Path projectRootPath, Path javaFilePath) {
        if (projectRootPath == null || javaFilePath == null) {
            return null;
        }
        return DataModelerUtils.calculateExpectedClassName(projectRootPath.toURI(), javaFilePath.toURI());
    }

    public static String calculateExpectedClassName(String projectRootPathUri, String javaFilePathUri) {
        String srcPathStrUri = projectRootPathUri + "/src/main/java/";
        if (!javaFilePathUri.startsWith(srcPathStrUri)) {
            return null;
        }
        int extensionIndex = (javaFilePathUri = javaFilePathUri.substring(srcPathStrUri.length(), javaFilePathUri.length())).lastIndexOf(".java");
        if (extensionIndex <= 0) {
            return null;
        }
        javaFilePathUri = javaFilePathUri.substring(0, extensionIndex);
        return javaFilePathUri.replaceAll("/", ".");
    }

    public static List<ObjectProperty> filterPropertiesByType(Collection<ObjectProperty> properties, List<String> expectedTypes, boolean skipUnmanaged) {
        ArrayList<ObjectProperty> result = new ArrayList<ObjectProperty>();
        if (properties == null || properties.size() == 0) {
            return result;
        }
        HashMap<String, String> types = new HashMap<String, String>();
        if (expectedTypes != null && expectedTypes.size() > 0) {
            for (String type : expectedTypes) {
                types.put(type, type);
            }
        } else {
            return result;
        }
        for (ObjectProperty propertyTO : properties) {
            if (propertyTO.getClassName() == null || !types.containsKey(propertyTO.getClassName()) || skipUnmanaged && (ReflectionUtil.isStatic(propertyTO.getModifiers()) || ReflectionUtil.isFinal(propertyTO.getModifiers()))) continue;
            result.add(propertyTO);
        }
        return result;
    }

    public static List<Pair<String, String>> buildFieldTypeOptions(Collection<PropertyType> baseTypes, Collection<DataObject> dataObjects, Collection<JavaEnum> javaEnum, Collection<DataObject> externalClasses, Collection<JavaEnum> externalEnums, boolean includeEmptyItem) {
        return DataModelerUtils.buildFieldTypeOptions(baseTypes, dataObjects, javaEnum, externalClasses, externalEnums, null, includeEmptyItem);
    }

    public static List<Pair<String, String>> buildFieldTypeOptions(Collection<PropertyType> baseTypes, Collection<DataObject> dataObjects, Collection<JavaEnum> javaEnums, Collection<DataObject> externalClasses, Collection<JavaEnum> externalEnums, String selectedType, boolean includeEmptyItem) {
        ArrayList<Pair<String, String>> typeList = new ArrayList<Pair<String, String>>();
        ArrayList<Object> javaTypes = new ArrayList<Object>();
        ArrayList<Object> externalJavaTypes = new ArrayList<Object>();
        TreeMap<String, String> sortedModelTypeNames = new TreeMap<String, String>(SortHelper.ALPHABETICAL_ORDER_COMPARATOR);
        TreeMap<String, String> sortedExternalTypeNames = new TreeMap<String, String>(SortHelper.ALPHABETICAL_ORDER_COMPARATOR);
        TreeMap<String, PropertyType> orderedBaseTypes = new TreeMap<String, PropertyType>(SortHelper.ALPHABETICAL_ORDER_COMPARATOR);
        TreeMap<String, PropertyType> baseTypesByClassName = new TreeMap<String, PropertyType>(SortHelper.ALPHABETICAL_ORDER_COMPARATOR);
        boolean selectedTypeIncluded = false;
        if (includeEmptyItem) {
            typeList.add(UIUtil.emptyValue());
        }
        if (baseTypes != null) {
            for (PropertyType propertyType : baseTypes) {
                orderedBaseTypes.put(propertyType.getName(), propertyType);
                baseTypesByClassName.put(propertyType.getClassName(), propertyType);
            }
        }
        for (Map.Entry entry : orderedBaseTypes.entrySet()) {
            if (((PropertyType)entry.getValue()).isPrimitive()) continue;
            typeList.add(new Pair(entry.getKey(), (Object)((PropertyType)entry.getValue()).getClassName()));
        }
        if (dataObjects != null) {
            javaTypes.addAll(dataObjects);
        }
        if (javaEnums != null) {
            javaTypes.addAll(javaEnums);
        }
        for (JavaType javaType : javaTypes) {
            String className = javaType.getClassName();
            String classLabel = javaType instanceof DataObject ? DataModelerUtils.getDataObjectFullLabel((DataObject)javaType) : javaType.getClassName();
            sortedModelTypeNames.put(classLabel, className);
            if (selectedType == null || !selectedType.equals(className)) continue;
            selectedTypeIncluded = true;
        }
        if (externalClasses != null) {
            externalJavaTypes.addAll(externalClasses);
        }
        if (externalEnums != null) {
            externalJavaTypes.addAll(externalEnums);
        }
        if (externalClasses != null) {
            for (JavaType javaType : externalJavaTypes) {
                String extClass = javaType.getClassName();
                sortedExternalTypeNames.put(EXTERNAL_PREFIX + extClass, extClass);
                if (selectedType == null || !selectedType.equals(extClass)) continue;
                selectedTypeIncluded = true;
            }
        }
        if (selectedType != null && !selectedTypeIncluded && !baseTypesByClassName.containsKey(selectedType)) {
            String extClass = selectedType;
            sortedExternalTypeNames.put(EXTERNAL_PREFIX + extClass, extClass);
        }
        for (Map.Entry entry : sortedModelTypeNames.entrySet()) {
            typeList.add(new Pair(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry entry : sortedExternalTypeNames.entrySet()) {
            typeList.add((Pair<String, String>)new Pair(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry entry : orderedBaseTypes.entrySet()) {
            if (!((PropertyType)entry.getValue()).isPrimitive()) continue;
            typeList.add((Pair<String, String>)new Pair(entry.getKey(), (Object)((PropertyType)entry.getValue()).getClassName()));
        }
        return typeList;
    }

    public static List<Pair<String, String>> buildSuperclassOptions(DataModel dataModel, DataObject currentDataObject) {
        ArrayList<Pair<String, String>> options = new ArrayList<Pair<String, String>>();
        if (dataModel != null) {
            String currentClassName;
            String classLabel;
            String className;
            TreeMap<String, String> sortedModelClasses = new TreeMap<String, String>(SortHelper.ALPHABETICAL_ORDER_COMPARATOR);
            TreeMap<String, String> sortedExternalClasses = new TreeMap<String, String>(SortHelper.ALPHABETICAL_ORDER_COMPARATOR);
            boolean isExtensible = false;
            for (DataObject dataObject : dataModel.getDataObjects()) {
                className = dataObject.getClassName();
                classLabel = DataModelerUtils.getDataObjectFullLabel(dataObject);
                isExtensible = !dataObject.isAbstract() && !dataObject.isFinal() && !dataObject.isInterface();
                if (!isExtensible || currentDataObject != null && className.toLowerCase().equals(currentDataObject.getClassName().toLowerCase())) continue;
                sortedModelClasses.put(classLabel, className);
            }
            for (DataObject dataObject : dataModel.getExternalClasses()) {
                className = dataObject.getClassName();
                classLabel = EXTERNAL_PREFIX + className;
                isExtensible = !dataObject.isAbstract() && !dataObject.isFinal() && !dataObject.isInterface();
                if (!isExtensible || currentDataObject != null && className.toLowerCase().equals(currentDataObject.getClassName().toLowerCase())) continue;
                sortedExternalClasses.put(classLabel, className);
            }
            if (currentDataObject != null && currentDataObject.getSuperClassName() != null && !sortedModelClasses.containsKey(currentClassName = currentDataObject.getSuperClassName()) && !sortedExternalClasses.containsKey(currentClassName)) {
                sortedModelClasses.put(currentClassName, currentClassName);
            }
            for (Map.Entry entry : sortedModelClasses.entrySet()) {
                options.add((Pair<String, String>)new Pair(entry.getKey(), entry.getValue()));
            }
            for (Map.Entry entry : sortedExternalClasses.entrySet()) {
                options.add((Pair<String, String>)new Pair(entry.getKey(), entry.getValue()));
            }
        }
        return options;
    }

    public static final String nullTrim(String value) {
        String result;
        String string = result = value != null ? value.trim() : value;
        if (result != null && !"".equals(result)) {
            return result;
        }
        return null;
    }

    public static final String trim(String value) {
        return value != null ? value.trim() : value;
    }
}

