/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.enterprise.event.Event;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandler;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerValueChangeEvent;

public abstract class BaseEditor
implements IsWidget {
    protected DataModelerContext context;
    protected boolean readonly = false;
    protected Event<DataModelerEvent> dataModelerEvent;
    protected DomainHandlerRegistry handlerRegistry;
    protected DataModelCommandBuilder commandBuilder;

    public BaseEditor(DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder) {
        this.handlerRegistry = handlerRegistry;
        this.dataModelerEvent = dataModelerEvent;
        this.commandBuilder = commandBuilder;
    }

    public DataModelerContext getContext() {
        return this.context;
    }

    public void onContextChange(DataModelerContext context) {
        this.context = context;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public abstract void clear();

    public abstract String getName();

    public abstract String getDomainName();

    protected void executePostCommandProcessing(DataModelCommand command) {
        List<DomainHandler> handlers = this.handlerRegistry.getDomainHandlers(this.getDomainName());
        for (DomainHandler handler : handlers) {
            handler.postCommandProcessing(command);
        }
    }

    protected void notifyChange(DataModelerEvent event) {
        this.dataModelerEvent.fire((Object)event);
        this.getContext().getHelper().dataModelChanged((DataModelerValueChangeEvent)event);
    }
}

