/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.refactoring;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.List;
import org.gwtbootstrap3.client.shared.event.ModalShownEvent;
import org.gwtbootstrap3.client.shared.event.ModalShownHandler;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.tables.SimpleTable;
import org.uberfire.mvp.Command;

public class ShowUsagesPopup
extends BaseModal {
    private ShowUsagesPopupWidgetBinder uiBinder = (ShowUsagesPopupWidgetBinder)GWT.create(ShowUsagesPopupWidgetBinder.class);
    @UiField
    protected Paragraph message;
    @UiField
    protected SimpleTable<UsedByRow> usedByTable;
    @UiField
    protected Button yesButton;
    @UiField
    protected Button cancelButton;
    private List<Path> usedByFiles;
    private ListDataProvider<UsedByRow> usedByFilesProvider = new ListDataProvider();
    private Command yesCommand;
    private Command cancelCommand;

    protected ShowUsagesPopup(String title, String message, List<Path> usedByFiles, Command yesCommand, String yesButtonText, ButtonType yesButtonType, IconType yesButtonIconType, Command cancelCommand, String cancelButtonText, ButtonType cancelButtonType, IconType cancelButtonIconType) {
        this.setTitle(title);
        this.usedByFiles = usedByFiles;
        this.yesCommand = yesCommand;
        this.cancelCommand = cancelCommand;
        this.setBody((Widget)this.uiBinder.createAndBindUi((Object)this));
        if (yesCommand == null) {
            this.yesButton.setVisible(false);
        }
        if (cancelCommand == null) {
            this.cancelButton.setVisible(false);
        }
        if (yesButtonType != null) {
            this.yesButton.setType(yesButtonType);
        }
        if (yesButtonText != null) {
            this.yesButton.setText(yesButtonText);
        }
        if (yesButtonIconType != null) {
            this.yesButton.setIcon(yesButtonIconType);
        }
        if (cancelButtonType != null) {
            this.cancelButton.setType(cancelButtonType);
        }
        if (cancelButtonText != null) {
            this.cancelButton.setText(cancelButtonText);
        }
        if (cancelButtonIconType != null) {
            this.cancelButton.setIcon(cancelButtonIconType);
        }
        this.message.setHTML(message);
        this.initTable();
        this.addShownHandler(new ModalShownHandler(){

            public void onShown(ModalShownEvent shownEvent) {
                Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new com.google.gwt.user.client.Command(){

                    public void execute() {
                        ShowUsagesPopup.this.loadTable();
                    }
                });
            }
        });
    }

    protected ShowUsagesPopup(String message, List<Path> usedByFiles, Command yesCommand, String yesButtonText, Command cancelCommand, String cancelButtonText) {
        this(Constants.INSTANCE.usages_popup_title(), message, usedByFiles, yesCommand, yesButtonText, null, null, cancelCommand, cancelButtonText, null, null);
    }

    public static ShowUsagesPopup newUsagesPopup(String message, List<Path> usedByFiles, Command yesCommand, String yesButtonText, Command cancelCommand, String cancelButtonText) {
        return new ShowUsagesPopup(message, usedByFiles, yesCommand, yesButtonText, cancelCommand, cancelButtonText);
    }

    public static ShowUsagesPopup newUsagesPopup(String message, List<Path> usedByFiles, Command yesCommand, String yesButtonText, ButtonType yesButtonType, IconType yesButtonIconType, Command cancelCommand, String cancelButtonText, ButtonType cancelButtonType, IconType cancelButtonIconType) {
        return new ShowUsagesPopup(Constants.INSTANCE.usages_popup_title(), message, usedByFiles, yesCommand, yesButtonText, yesButtonType, yesButtonIconType, cancelCommand, cancelButtonText, cancelButtonType, cancelButtonIconType);
    }

    public static ShowUsagesPopup newUsagesPopupForDeletion(String message, List<Path> usedByFiles, Command yesCommand, Command cancelCommand) {
        return ShowUsagesPopup.newUsagesPopup(message, usedByFiles, yesCommand, Constants.INSTANCE.usages_popup_action_yes_delete_anyway(), ButtonType.DANGER, IconType.TRASH, cancelCommand, null, ButtonType.PRIMARY, null);
    }

    public static ShowUsagesPopup newUsagesPopupForRenaming(String message, List<Path> usedByFiles, Command yesCommand, Command cancelCommand) {
        return ShowUsagesPopup.newUsagesPopup(message, usedByFiles, yesCommand, Constants.INSTANCE.usages_popup_action_yes_rename_anyway(), ButtonType.DANGER, IconType.TRASH, cancelCommand, null, ButtonType.PRIMARY, null);
    }

    public static ShowUsagesPopup newUsagesPopupForChanging(String message, List<Path> usedByFiles, Command yesCommand, Command cancelCommand) {
        return ShowUsagesPopup.newUsagesPopup(message, usedByFiles, yesCommand, Constants.INSTANCE.usages_popup_action_yes_change_anyway(), ButtonType.DANGER, IconType.TRASH, cancelCommand, null, ButtonType.PRIMARY, null);
    }

    private void initTable() {
        this.usedByTable.columnPickerButton.setVisible(true);
        this.usedByFilesProvider.addDataDisplay(this.usedByTable);
        TextColumn<UsedByRow> nameColumn = new TextColumn<UsedByRow>(){

            public String getValue(UsedByRow row) {
                return row.getPath() != null ? row.getPath().getFileName() : null;
            }

            public void render(Cell.Context context, UsedByRow object, SafeHtmlBuilder sb) {
                String currentValue = this.getValue(object);
                if (currentValue != null) {
                    sb.append(SafeHtmlUtils.fromTrustedString((String)"<div title=\""));
                    sb.append(SafeHtmlUtils.fromString((String)currentValue));
                    sb.append(SafeHtmlUtils.fromTrustedString((String)"\">"));
                }
                super.render(context, (Object)object, sb);
                if (currentValue != null) {
                    sb.append(SafeHtmlUtils.fromTrustedString((String)"</div>"));
                }
            }
        };
        this.usedByTable.addColumn((Column)nameColumn, Constants.INSTANCE.usages_popup_file_name_column());
        this.usedByTable.setColumnWidth((Column)nameColumn, 40.0, Style.Unit.PCT);
        TextColumn<UsedByRow> pathColumn = new TextColumn<UsedByRow>(){

            public String getValue(UsedByRow row) {
                String pathStr = null;
                if (row.getPath() != null && row.getPath().getFileName() != null) {
                    pathStr = row.getPath().toURI().substring(0, row.getPath().toURI().lastIndexOf(47));
                }
                return pathStr;
            }

            public void render(Cell.Context context, UsedByRow object, SafeHtmlBuilder sb) {
                String currentValue = this.getValue(object);
                if (currentValue != null) {
                    sb.append(SafeHtmlUtils.fromTrustedString((String)"<div title=\""));
                    sb.append(SafeHtmlUtils.fromString((String)currentValue));
                    sb.append(SafeHtmlUtils.fromTrustedString((String)"\">"));
                }
                super.render(context, (Object)object, sb);
                if (currentValue != null) {
                    sb.append(SafeHtmlUtils.fromTrustedString((String)"</div>"));
                }
            }
        };
        this.usedByTable.addColumn((Column)pathColumn, Constants.INSTANCE.usages_popup_file_path_column());
        this.usedByTable.setColumnWidth((Column)pathColumn, 60.0, Style.Unit.PCT);
    }

    private void loadTable() {
        if (this.usedByFiles != null && !this.usedByFiles.isEmpty()) {
            this.usedByFilesProvider.getList().clear();
            this.usedByFilesProvider.getList().addAll(this.createUsedByRows(this.usedByFiles));
        }
    }

    @UiHandler(value={"yesButton"})
    public void onYesButtonClick(ClickEvent e) {
        if (this.yesCommand != null) {
            this.yesCommand.execute();
        }
        this.hide();
    }

    @UiHandler(value={"cancelButton"})
    public void onCancelButtonClick(ClickEvent e) {
        if (this.cancelCommand != null) {
            this.cancelCommand.execute();
        }
        this.hide();
    }

    private List<UsedByRow> createUsedByRows(List<Path> usedByFiles) {
        ArrayList<UsedByRow> result = new ArrayList<UsedByRow>();
        if (usedByFiles != null) {
            for (Path path : usedByFiles) {
                result.add(new UsedByRow(path));
            }
        }
        return result;
    }

    public static class UsedByRow {
        Path path;

        public UsedByRow(Path path) {
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }

        public void setPath(Path path) {
            this.path = path;
        }
    }

    static interface ShowUsagesPopupWidgetBinder
    extends UiBinder<Widget, ShowUsagesPopup> {
    }
}

