/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.command;

import java.util.List;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.AbstractDataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelChangeNotifier;
import org.kie.workbench.common.screens.datamodeller.client.command.ValuePair;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectChangeEvent;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;

public class MethodAddAnnotationCommand
extends AbstractDataModelCommand {
    private final Method method;
    private Annotation annotation;

    public MethodAddAnnotationCommand(DataModelerContext context, String source, DataObject dataObject, Method method, String annotationClassName, List<ValuePair> valuePairs, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, notifier);
        this.annotationClassName = annotationClassName;
        this.method = method;
        this.valuePairs = valuePairs;
    }

    @Override
    public void execute() {
        Annotation existingAnnotation;
        if (this.annotation == null) {
            this.annotation = new AnnotationImpl(this.context.getAnnotationDefinition(this.annotationClassName));
            if (this.valuePairs != null) {
                for (ValuePair valuePair : this.valuePairs) {
                    this.annotation.setValue(valuePair.getName(), valuePair.getValue());
                }
            }
        }
        if ((existingAnnotation = this.method.getAnnotation(this.annotation.getClassName())) != null) {
            this.method.removeAnnotation(this.annotation.getClassName());
        }
        this.method.addAnnotation(this.annotation);
        DataModelerEvent event = new DataObjectChangeEvent().withChangeType(ChangeType.METHOD_ANNOTATION_ADD_CHANGE).withOldValue(null).withNewValue((Object)this.annotation).withContextId(this.getContext().getContextId()).withSource(this.getSource()).withCurrentDataObject(this.getDataObject()).withCurrentMethod(this.method);
        this.notifyChange(event);
    }
}

