/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandler;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.DomainEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.FieldEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.InfoEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ObjectEditor;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectDeletedEvent;

public abstract class BaseDomainEditor
extends Composite
implements DomainEditor {
    protected static int OBJECT_EDITOR = 0;
    protected static int FIELD_EDITOR = 1;
    protected static int INFO_EDITOR = 2;
    protected SimplePanel mainPanel = new SimplePanel();
    protected DeckPanel editorsDeck = new DeckPanel();
    protected ObjectEditor objectEditor;
    protected FieldEditor fieldEditor;
    protected InfoEditor infoEditor = new InfoEditor();
    protected DataModelerContext context;
    protected DomainHandler handler;

    public BaseDomainEditor() {
        this.initWidget((Widget)this.mainPanel);
    }

    public BaseDomainEditor(ObjectEditor objectEditor, FieldEditor fieldEditor) {
        this();
        this.objectEditor = objectEditor;
        this.fieldEditor = fieldEditor;
    }

    @PostConstruct
    private void init() {
        this.editorsDeck.add((IsWidget)this.objectEditor);
        this.editorsDeck.add((IsWidget)this.fieldEditor);
        this.editorsDeck.add((IsWidget)this.infoEditor);
        this.mainPanel.add((Widget)this.editorsDeck);
        this.infoEditor.setInfo("No data object has been opened.");
        this.showInfoEditor();
    }

    public DataModelerContext getContext() {
        return this.context;
    }

    protected String getContextId() {
        return this.context != null ? this.context.getContextId() : null;
    }

    public void showObjectEditor() {
        this.editorsDeck.showWidget(OBJECT_EDITOR);
    }

    public void showFieldEditor() {
        this.editorsDeck.showWidget(FIELD_EDITOR);
    }

    public void showInfoEditor() {
        this.editorsDeck.showWidget(INFO_EDITOR);
    }

    @Override
    public Widget getWidget() {
        return this.asWidget();
    }

    @Override
    public DomainHandler getHandler() {
        return this.handler;
    }

    public void setHandler(DomainHandler handler) {
        this.handler = handler;
    }

    protected void onContextChange(DataModelerContext context) {
        this.context = context;
        if (context == null) {
            this.infoEditor.setInfo("No data object has been opened.");
            this.showInfoEditor();
        } else if (context.getEditionMode() == DataModelerContext.EditionMode.SOURCE_MODE) {
            this.infoEditor.setInfo("Data object is being edited at this moment.");
            this.showInfoEditor();
        } else if (context.getEditionMode() == DataModelerContext.EditionMode.GRAPHICAL_MODE) {
            if (context.getDataObject() != null && context.getObjectProperty() != null) {
                this.showFieldEditor();
            } else {
                this.showObjectEditor();
            }
        }
        this.objectEditor.onContextChange(context);
        this.fieldEditor.onContextChange(context);
    }

    protected void onDataObjectDeleted(@Observes DataObjectDeletedEvent event) {
        if (event.isFromContext(this.getContextId())) {
            this.showInfoEditor();
        }
    }
}

