/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerErrorCallback;
import org.kie.workbench.common.screens.datamodeller.client.command.AddPropertyCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.context.DataModelerWorkbenchContextChangeEvent;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandler;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.screens.datamodeller.client.util.ObjectPropertyComparator;
import org.kie.workbench.common.screens.datamodeller.client.validation.ValidatorService;
import org.kie.workbench.common.screens.datamodeller.client.widgets.editor.DataObjectBrowserView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.editor.NewFieldPopup;
import org.kie.workbench.common.screens.datamodeller.client.widgets.editor.NewFieldPopupView;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldCreatedEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldDeletedEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldSelectedEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectSelectedEvent;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.LockRequiredEvent;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@Dependent
public class DataObjectBrowser
implements IsWidget,
DataObjectBrowserView.Presenter {
    protected DataModelCommandBuilder commandBuilder;
    protected DataObject dataObject;
    protected DataModelerContext context;
    protected ListDataProvider<ObjectProperty> dataProvider = new ListDataProvider(new ArrayList());
    protected ValidatorService validatorService;
    protected DomainHandlerRegistry handlerRegistry;
    protected Caller<DataModelerService> modelerService;
    protected Event<DataModelerEvent> dataModelerEvent;
    protected Event<DataModelerWorkbenchContextChangeEvent> dataModelerWBContextEvent;
    protected Event<LockRequiredEvent> lockRequiredEvent;
    protected PlaceManager placeManager;
    protected NewFieldPopup newFieldPopup;
    protected DataObjectBrowserView view;
    protected boolean readonly = true;

    @Inject
    public DataObjectBrowser(DomainHandlerRegistry handlerRegistry, DataModelCommandBuilder commandBuilder, Caller<DataModelerService> modelerService, ValidatorService validatorService, Event<DataModelerEvent> dataModelerEvent, Event<DataModelerWorkbenchContextChangeEvent> dataModelerWBContextEvent, Event<LockRequiredEvent> lockRequiredEvent, PlaceManager placeManager, NewFieldPopup newFieldPopup, DataObjectBrowserView view) {
        this.handlerRegistry = handlerRegistry;
        this.commandBuilder = commandBuilder;
        this.modelerService = modelerService;
        this.validatorService = validatorService;
        this.dataModelerEvent = dataModelerEvent;
        this.dataModelerWBContextEvent = dataModelerWBContextEvent;
        this.lockRequiredEvent = lockRequiredEvent;
        this.placeManager = placeManager;
        this.newFieldPopup = newFieldPopup;
        this.view = view;
        view.init(this);
        view.setTableHeight(DataObjectBrowserHelper.calculateTableHeight(0));
        view.setDataProvider(this.dataProvider);
    }

    @PostConstruct
    protected void init() {
        this.setReadonly(true);
        this.newFieldPopup.addPopupHandler(new NewFieldPopupView.NewFieldPopupHandler(){

            @Override
            public void onCreate(String fieldName, String fieldLabel, String type, boolean multiple) {
                DataObjectBrowser.this.onCreateNewProperty(DataObjectBrowser.this.dataObject, DataModelerUtils.unCapitalize(fieldName), fieldLabel, type, multiple, true);
            }

            @Override
            public void onCreateAndContinue(String fieldName, String fieldLabel, String type, boolean multiple) {
                DataObjectBrowser.this.onCreateNewProperty(DataObjectBrowser.this.dataObject, DataModelerUtils.unCapitalize(fieldName), fieldLabel, type, multiple, false);
            }

            @Override
            public void onCancel() {
                DataObjectBrowser.this.newFieldPopup.hide();
            }
        });
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public DataModelerContext getContext() {
        return this.context;
    }

    public void setContext(DataModelerContext context) {
        this.context = context;
        if (context != null) {
            this.setDataObject(context.getDataObject());
            this.setReadonly(context.isReadonly());
        } else {
            this.setReadonly(true);
        }
    }

    private void onCreateNewProperty(final DataObject dataObject, final String propertyName, final String propertyLabel, final String propertyType, final Boolean isMultiple, final boolean closePopup) {
        if (dataObject != null) {
            this.validatorService.isValidIdentifier(propertyName, new ValidatorCallback(){

                public void onFailure() {
                    DataObjectBrowser.this.newFieldPopup.setErrorMessage(Constants.INSTANCE.validation_error_invalid_object_attribute_identifier(propertyName));
                }

                public void onSuccess() {
                    DataObjectBrowser.this.validatorService.isUniqueAttributeName(propertyName, dataObject, new ValidatorWithReasonCallback(){

                        public void onFailure() {
                            this.showFailure("MANAGED_PROPERTY_EXISTS");
                        }

                        public void onFailure(String reason) {
                            this.showFailure(reason);
                        }

                        private void showFailure(String reason) {
                            if ("UN_MANAGED_PROPERTY_EXISTS".equals(reason)) {
                                ObjectProperty unmanagedProperty = DataObjectBrowser.this.getDataObject().getUnManagedProperty(propertyName);
                                DataObjectBrowser.this.newFieldPopup.setErrorMessage(Constants.INSTANCE.validation_error_object_un_managed_attribute_already_exists(unmanagedProperty.getName(), unmanagedProperty.getClassName()));
                            } else {
                                DataObjectBrowser.this.newFieldPopup.setErrorMessage(Constants.INSTANCE.validation_error_object_attribute_already_exists(propertyName));
                            }
                        }

                        public void onSuccess() {
                            if (propertyType != null && !"".equals(propertyType) && !"NOT_SELECTED".equals(propertyType)) {
                                boolean multiple = isMultiple != false && DataObjectBrowser.this.getContext().getHelper().isPrimitiveType(propertyType) == false;
                                DataObjectBrowser.this.addNewProperty(DataObjectBrowser.this.getDataObject(), propertyName, propertyLabel, propertyType, multiple);
                                if (closePopup) {
                                    DataObjectBrowser.this.newFieldPopup.hide();
                                } else {
                                    DataObjectBrowser.this.newFieldPopup.resetInput();
                                }
                            } else {
                                DataObjectBrowser.this.newFieldPopup.setErrorMessage(Constants.INSTANCE.validation_error_missing_object_attribute_type());
                            }
                        }
                    });
                }
            });
        }
    }

    private void setDataObject(DataObject dataObject) {
        this.dataObject = dataObject;
        this.setObjectSelectorLabel(dataObject);
        List<Object> dataObjectProperties = dataObject != null ? DataModelerUtils.getManagedProperties(dataObject) : Collections.emptyList();
        ArrayList sortBuffer = new ArrayList();
        if (dataObject != null) {
            sortBuffer.addAll(dataObjectProperties);
        }
        Collections.sort(sortBuffer, new ObjectPropertyComparator("name", true));
        this.adjustTableSize(sortBuffer.size());
        this.dataProvider.getList().clear();
        this.dataProvider.getList().addAll(sortBuffer);
        this.view.redrawTable();
    }

    private void adjustTableSize(int rows) {
        int currentHeight;
        int height = DataObjectBrowserHelper.calculateTableHeight(rows);
        if (height != (currentHeight = this.view.getTableHeight())) {
            this.view.setTableHeight(height);
        }
    }

    private void addNewProperty(DataObject dataObject, String propertyName, String propertyLabel, String propertyType, Boolean isMultiple) {
        AddPropertyCommand command = this.commandBuilder.buildAddPropertyCommand(this.getContext(), "DATA_OBJECT_BROWSER", dataObject, propertyName, propertyLabel, propertyType, isMultiple);
        command.execute();
        ObjectProperty property = command.getProperty();
        this.adjustTableSize(this.dataProvider.getList().size() + 1);
        this.dataProvider.getList().add(property);
        this.view.setSelectedRow(property, true);
        this.executePostCommandProcessing(command);
    }

    @Override
    public void onDeleteProperty(ObjectProperty objectProperty, int index) {
        this.checkUsagesAndDeleteDataObjectProperty(objectProperty, index);
    }

    private void deleteProperty(ObjectProperty objectProperty, int index) {
        if (this.dataObject != null) {
            this.adjustTableSize(this.dataProvider.getList().size() - 1);
            this.dataObject.getProperties().remove(objectProperty);
            this.dataProvider.getList().remove(index);
            this.dataProvider.flush();
            this.dataProvider.refresh();
            this.getContext().getHelper().dataObjectUnReferenced(objectProperty.getClassName(), this.dataObject.getClassName());
            this.notifyFieldDeleted(objectProperty);
            if (this.dataProvider.getList().size() == 0) {
                this.context.setObjectProperty(null);
                this.notifyObjectSelected();
            } else {
                int nextSelectedRow = index > 0 ? index - 1 : 0;
                this.view.setSelectedRow((ObjectProperty)this.dataProvider.getList().get(nextSelectedRow), true);
            }
        }
    }

    private void checkUsagesAndDeleteDataObjectProperty(final ObjectProperty objectProperty, final int index) {
        String className = this.dataObject.getClassName();
        String fieldName = objectProperty.getName();
        if (this.getContext() != null) {
            Path currentPath = this.getContext().getEditorModelContent() != null ? this.getContext().getEditorModelContent().getPath() : null;
            ((DataModelerService)this.modelerService.call((RemoteCallback)new RemoteCallback<List<Path>>(){

                public void callback(List<Path> paths) {
                    if (paths != null && paths.size() > 0) {
                        DataObjectBrowser.this.view.showUsagesPopupForDeletion(Constants.INSTANCE.modelEditor_confirm_deletion_of_used_field(objectProperty.getName()), paths, new Command(){

                            public void execute() {
                                DataObjectBrowser.this.deleteProperty(objectProperty, index);
                            }
                        }, new Command(){

                            public void execute() {
                            }
                        });
                    } else {
                        DataObjectBrowser.this.deleteProperty(objectProperty, index);
                    }
                }
            })).findFieldUsages(currentPath, className, fieldName);
        }
    }

    private void setObjectSelectorLabel(DataObject dataObject) {
        String label = dataObject != null ? DataModelerUtils.getDataObjectFullLabel(dataObject, false) : "";
        String title = dataObject != null ? dataObject.getClassName() : "";
        this.view.setObjectSelectorLabel(label, title);
    }

    public DataModel getDataModel() {
        return this.getContext() != null ? this.getContext().getDataModel() : null;
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    @Override
    public void onSelectPropertyType(ObjectProperty property) {
        DataObject dataObject = this.getDataModel().getDataObject(property.getClassName());
        if (dataObject != null) {
            this.openDataObject(dataObject);
        }
    }

    private void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.view.setReadonly(readonly);
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    private void executePostCommandProcessing(DataModelCommand command) {
        List<DomainHandler> handlers = this.handlerRegistry.getDomainHandlers();
        for (DomainHandler handler : handlers) {
            handler.postCommandProcessing(command);
        }
    }

    public void redrawFields() {
        this.view.redrawTable();
    }

    @Override
    public void onSelectCurrentDataObject() {
        ObjectProperty currentSelection = this.view.getSelectedRow();
        if (currentSelection != null) {
            this.view.setSelectedRow(currentSelection, false);
        }
        this.context.setObjectProperty(null);
        this.notifyObjectSelected();
    }

    @Override
    public void onNewProperty() {
        this.lockRequiredEvent.fire((Object)new LockRequiredEvent());
        if (this.getContext() != null) {
            this.newFieldPopup.init(this.getContext());
            this.newFieldPopup.show();
        }
    }

    @Override
    public void onSelectProperty(ObjectProperty selectedProperty) {
        if (selectedProperty != null) {
            this.context.setObjectProperty(selectedProperty);
            this.notifyFieldSelected();
        }
    }

    @Override
    public void onSortByName(boolean ascending) {
        this.sortTable(new ObjectPropertyComparator("name", ascending));
    }

    @Override
    public void onSortByLabel(boolean ascending) {
        this.sortTable(new ObjectPropertyComparator("label", ascending));
    }

    @Override
    public void onSortByType(boolean ascending) {
        this.sortTable(new ObjectPropertyComparator("className", ascending));
    }

    private void sortTable(Comparator<ObjectProperty> comparator) {
        Collections.sort(this.dataProvider.getList(), comparator);
    }

    @Override
    public String getPropertyTypeDisplayValue(ObjectProperty property) {
        String displayName = property.getClassName();
        if (property.isBaseType()) {
            displayName = DataModelerUtils.extractClassName(displayName);
        } else {
            String label = this.getContext().getHelper().getObjectLabelByClassName(displayName);
            if (label != null && !"".equals(label)) {
                displayName = label;
            }
        }
        if (property.isMultiple()) {
            displayName = displayName + " [" + Constants.INSTANCE.objectBrowser_typeLabelMultiple() + "]";
        }
        return displayName;
    }

    @Override
    public boolean isSelectablePropertyType(ObjectProperty property) {
        return !property.isBaseType() && !this.getDataObject().getClassName().equals(property.getClassName()) && !this.getDataModel().isExternal(property.getClassName());
    }

    private void onDataObjectChange(@Observes DataObjectChangeEvent event) {
        if (event.isFromContext(this.context != null ? this.context.getContextId() : null) && (event.getChangeType() == ChangeType.CLASS_NAME_CHANGE || event.getChangeType() == ChangeType.PACKAGE_NAME_CHANGE || event.getChangeType() == ChangeType.OBJECT_NAME_CHANGE || "org.kie.api.definition.type.Label".equals(event.getAnnotationClassName()))) {
            this.setObjectSelectorLabel(this.dataObject);
            this.dataProvider.refresh();
            this.dataProvider.flush();
        }
    }

    private void onDataObjectPropertyChange(@Observes DataObjectFieldChangeEvent event) {
        if (event.isFromContext(this.context != null ? this.context.getContextId() : null) && (event.getChangeType() == ChangeType.FIELD_NAME_CHANGE || event.getChangeType() == ChangeType.FIELD_TYPE_CHANGE || event.getChangeType() == ChangeType.FIELD_ANNOTATION_VALUE_CHANGE || event.getChangeType() == ChangeType.FIELD_ANNOTATION_ADD_CHANGE || event.getChangeType() == ChangeType.FIELD_ANNOTATION_REMOVE_CHANGE)) {
            List props = this.dataProvider.getList();
            for (int i = 0; i < props.size(); ++i) {
                if (event.getCurrentField() != props.get(i)) continue;
                this.view.redrawRow(i);
                break;
            }
        }
    }

    private void onDataObjectFieldCreated(@Observes DataObjectFieldCreatedEvent event) {
        if (event.isFromContext(this.context != null ? this.context.getContextId() : null) && !"DATA_OBJECT_BROWSER".equals(event.getSource())) {
            this.setDataObject(this.dataObject);
        }
    }

    private void notifyFieldDeleted(ObjectProperty deletedProperty) {
        DataObjectFieldDeletedEvent dataObjectFieldDeletedEvent = new DataObjectFieldDeletedEvent(this.getContext().getContextId(), "DATA_OBJECT_BROWSER", this.getDataObject(), deletedProperty);
        this.dataModelerEvent.fire((Object)dataObjectFieldDeletedEvent);
    }

    private void notifyObjectSelected() {
        this.dataModelerWBContextEvent.fire((Object)new DataModelerWorkbenchContextChangeEvent());
        this.dataModelerEvent.fire((Object)new DataObjectSelectedEvent(this.getContext().getContextId(), "DATA_MODEL_BROWSER", this.getDataObject()));
    }

    private void notifyFieldSelected() {
        this.dataModelerWBContextEvent.fire((Object)new DataModelerWorkbenchContextChangeEvent());
        this.dataModelerEvent.fire((Object)new DataObjectFieldSelectedEvent(this.getContext().getContextId(), "DATA_MODEL_BROWSER", this.getDataObject(), this.context.getObjectProperty()));
    }

    private void openDataObject(DataObject dataObject) {
        final Path objectPath = this.getContext().getDataObjectPath(dataObject.getClassName());
        if (objectPath != null) {
            this.view.showBusyIndicator(CommonConstants.INSTANCE.Loading());
            ((DataModelerService)this.modelerService.call((RemoteCallback)new RemoteCallback<Boolean>(){

                public void callback(Boolean exists) {
                    DataObjectBrowser.this.view.hideBusyIndicator();
                    if (Boolean.TRUE.equals(exists)) {
                        DataObjectBrowser.this.placeManager.goTo((PlaceRequest)new PathPlaceRequest(objectPath));
                    } else {
                        DataObjectBrowser.this.view.showYesNoCancelPopup(org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.Warning(), Constants.INSTANCE.objectBrowser_message_file_not_exists_or_renamed(objectPath.toURI()), new Command(){

                            public void execute() {
                            }
                        }, org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.Close(), ButtonType.WARNING, null, null, null, null, null, null);
                    }
                }
            }, (ErrorCallback)new DataModelerErrorCallback(org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.ExceptionNoSuchFile0(objectPath.toURI())))).exists(objectPath);
        }
    }

    public static class DataObjectBrowserHelper {
        private static final int ROW_HEIGHT = 30;
        public static final int MAX_ROWS = 15;
        public static final int MAX_TABLE_HEIGHT = 480;
        public static final int MIN_TABLE_HEIGHT = 90;

        public static int calculateTableHeight(int rows) {
            int height;
            height = rows >= 15 ? 480 : (rows == 0 ? 90 : ((height = (rows + 1) * 30) < 90 ? 90 : height));
            return height;
        }
    }
}

