/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.datamodeller.client.PersistenceDescriptorEditorView;
import org.kie.workbench.common.screens.datamodeller.client.pdescriptor.ClassRow;
import org.kie.workbench.common.screens.datamodeller.client.pdescriptor.ClassRowImpl;
import org.kie.workbench.common.screens.datamodeller.client.pdescriptor.PropertyRow;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.type.PersistenceDescriptorType;
import org.kie.workbench.common.screens.datamodeller.client.widgets.datasourceselector.DataSourceInfo;
import org.kie.workbench.common.screens.datamodeller.client.widgets.datasourceselector.DataSourceSelector;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorEditorContent;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceUnitModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.Property;
import org.kie.workbench.common.screens.datamodeller.model.persistence.TransactionType;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.screens.datamodeller.service.PersistenceDescriptorEditorService;
import org.kie.workbench.common.screens.datamodeller.service.PersistenceDescriptorService;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.annotations.Customizable;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.views.pfly.multipage.PageImpl;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="PersistenceDescriptorEditor", supportedTypes={PersistenceDescriptorType.class}, priority=0x7FFFFFFF)
public class PersistenceDescriptorEditorPresenter
extends KieEditor
implements PersistenceDescriptorEditorView.Presenter {
    private PersistenceDescriptorEditorView view;
    private PersistenceDescriptorType type;
    private DataSourceSelector dataSourceSelector;
    private Caller<PersistenceDescriptorEditorService> editorService;
    private Caller<PersistenceDescriptorService> descriptorService;
    private Caller<DataModelerService> dataModelerService;
    private ValidationPopup validationPopup;
    private PersistenceDescriptorEditorContent content;
    private boolean createIfNotExists = false;

    @Inject
    public PersistenceDescriptorEditorPresenter(PersistenceDescriptorEditorView baseView, PersistenceDescriptorType type, @Customizable DataSourceSelector dataSourceSelector, Caller<PersistenceDescriptorEditorService> editorService, Caller<PersistenceDescriptorService> descriptorService, Caller<DataModelerService> dataModelerService, ValidationPopup validationPopup) {
        super((KieEditorView)baseView);
        this.view = baseView;
        baseView.setPresenter(this);
        this.type = type;
        this.dataSourceSelector = dataSourceSelector;
        this.editorService = editorService;
        this.descriptorService = descriptorService;
        this.dataModelerService = dataModelerService;
        this.validationPopup = validationPopup;
        this.view.showDataSourceSelector(this.dataSourceIntegrationEnabled());
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.createIfNotExists = "true".equals(place.getParameter("createIfNotExists", null));
        this.init(path, place, this.type);
    }

    @OnFocus
    public void onFocus() {
        this.view.redraw();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        if (this.versionRecordManager.getCurrentPath() == null) {
            return this.type.getDescription();
        }
        super.getTitleText();
        return super.getTitleText();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        this.makeMenuBar();
        return this.menus;
    }

    protected void loadContent() {
        ((PersistenceDescriptorEditorService)this.editorService.call(this.getLoadModelSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).loadContent((Path)this.versionRecordManager.getCurrentPath(), this.createIfNotExists);
    }

    @OnMayClose
    public boolean onMayClose() {
        if (this.isDirty(this.getContent().hashCode())) {
            return this.view.confirmClose();
        }
        return true;
    }

    @OnClose
    public void OnClose() {
        super.OnClose();
    }

    private RemoteCallback<PersistenceDescriptorEditorContent> getLoadModelSuccessCallback() {
        return new RemoteCallback<PersistenceDescriptorEditorContent>(){

            public void callback(PersistenceDescriptorEditorContent content) {
                if (PersistenceDescriptorEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                if (content.isCreated()) {
                    PersistenceDescriptorEditorPresenter.this.versionRecordManager.reloadVersions(content.getPath());
                }
                PersistenceDescriptorEditorPresenter.this.resetEditorPages(content.getOverview());
                PersistenceDescriptorEditorPresenter.this.addSourcePage();
                PersistenceDescriptorEditorPresenter.this.createOriginalHash(content);
                PersistenceDescriptorEditorPresenter.this.setContent(content);
                PersistenceDescriptorEditorPresenter.this.view.setReadOnly(PersistenceDescriptorEditorPresenter.this.isReadOnly);
                PersistenceDescriptorEditorPresenter.this.updateSource(content.getSource());
                PersistenceDescriptorEditorPresenter.this.view.hideBusyIndicator();
            }
        };
    }

    private void setContent(PersistenceDescriptorEditorContent content) {
        this.content = content;
        PersistenceDescriptorModel descriptorModel = content != null ? content.getDescriptorModel() : null;
        PersistenceUnitModel persistenceUnitModel = descriptorModel != null ? descriptorModel.getPersistenceUnit() : null;
        this.view.clear();
        if (persistenceUnitModel != null) {
            this.view.setPersistenceUnitName(persistenceUnitModel.getName());
            this.view.setPersistenceProvider(persistenceUnitModel.getProvider());
            this.view.setJTADataSource(persistenceUnitModel.getJtaDataSource());
            this.view.setJTATransactions(false);
            this.view.setResourceLocalTransactions(false);
            if (TransactionType.JTA.equals((Object)persistenceUnitModel.getTransactionType())) {
                this.view.setJTATransactions(true);
            } else if (TransactionType.RESOURCE_LOCAL.equals((Object)persistenceUnitModel.getTransactionType())) {
                this.view.setResourceLocalTransactions(true);
                this.view.setResourceLocalTransactionsVisible(true);
                this.updateResourceLocalTransactionsAlert();
            }
            this.view.getPersistenceUnitProperties().setProperties(this.wrappPropertiesList(persistenceUnitModel.getProperties()));
            this.view.getPersistenceUnitClasses().setClasses(this.wrappClassesList(persistenceUnitModel.getClasses()));
        }
    }

    public PersistenceDescriptorEditorContent getContent() {
        this.updateContent();
        return this.content;
    }

    protected void addSourcePage() {
        this.addPage((Page)new PageImpl((IsWidget)this.view.getSourceEditor(), CommonConstants.INSTANCE.SourceTabTitle()){

            public void onFocus() {
                PersistenceDescriptorEditorPresenter.this.onSourceTabSelected();
            }

            public void onLostFocus() {
            }
        });
    }

    protected void updateSource(String source) {
        this.view.setSource(source);
    }

    protected void save() {
        this.savePopUpPresenter.show((Path)this.versionRecordManager.getCurrentPath(), (ParameterizedCommand)new ParameterizedCommand<String>(){

            public void execute(String commitMessage) {
                ((PersistenceDescriptorEditorService)PersistenceDescriptorEditorPresenter.this.editorService.call(PersistenceDescriptorEditorPresenter.this.getSaveSuccessCallback(PersistenceDescriptorEditorPresenter.this.getContent().hashCode()))).save((Path)PersistenceDescriptorEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)PersistenceDescriptorEditorPresenter.this.getContent(), PersistenceDescriptorEditorPresenter.this.metadata, commitMessage);
            }
        });
        this.concurrentUpdateSessionInfo = null;
    }

    public void onSourceTabSelected() {
        PersistenceDescriptorModel persistenceDescriptor = this.getContent().getDescriptorModel();
        if (persistenceDescriptor != null) {
            this.view.showBusyIndicator(Constants.INSTANCE.persistence_descriptor_editor_loading_source_message());
            ((PersistenceDescriptorService)this.descriptorService.call((RemoteCallback)new RemoteCallback<String>(){

                public void callback(String source) {
                    PersistenceDescriptorEditorPresenter.this.view.hideBusyIndicator();
                    PersistenceDescriptorEditorPresenter.this.updateSource(source);
                }
            }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).toSource((Path)this.versionRecordManager.getCurrentPath(), (Object)persistenceDescriptor);
        }
    }

    @Override
    public void onPersistenceUnitNameChange() {
        this.ensurePersistenceUnit();
        this.getContent().getDescriptorModel().getPersistenceUnit().setName(this.view.getPersistenceUnitName());
    }

    @Override
    public void onPersistenceProviderChange() {
        this.ensurePersistenceUnit();
        this.getContent().getDescriptorModel().getPersistenceUnit().setProvider(this.view.getPersistenceProvider());
    }

    @Override
    public void onJTADataSourceChange() {
        this.ensurePersistenceUnit();
        this.getContent().getDescriptorModel().getPersistenceUnit().setJtaDataSource(this.view.getJTADataSource());
    }

    @Override
    public void onSelectDataSource() {
        this.dataSourceSelector.setGlobalSelection();
        this.dataSourceSelector.show(new ParameterizedCommand<DataSourceInfo>(){

            public void execute(DataSourceInfo dataSourceInfo) {
                PersistenceDescriptorEditorPresenter.this.ensurePersistenceUnit();
                if (dataSourceInfo.isDeployed()) {
                    PersistenceDescriptorEditorPresenter.this.getContent().getDescriptorModel().getPersistenceUnit().setJtaDataSource(dataSourceInfo.getJndi());
                    PersistenceDescriptorEditorPresenter.this.view.setJTADataSource(dataSourceInfo.getJndi());
                }
            }
        }, new Command(){

            public void execute() {
            }
        });
    }

    private boolean dataSourceIntegrationEnabled() {
        return ApplicationPreferences.getBooleanPref((String)"persistence-descriptor-editor-options.integrate-datasources");
    }

    @Override
    public void onJTATransactionsChange() {
        this.ensurePersistenceUnit();
        this.getContent().getDescriptorModel().getPersistenceUnit().setTransactionType(this.view.getJTATransactions() ? TransactionType.JTA : TransactionType.RESOURCE_LOCAL);
        this.updateResourceLocalTransactionsAlert();
    }

    @Override
    public void onResourceLocalTransactionsChange() {
        this.ensurePersistenceUnit();
        this.getContent().getDescriptorModel().getPersistenceUnit().setTransactionType(this.view.getResourceLocalTransactions() ? TransactionType.RESOURCE_LOCAL : TransactionType.JTA);
        this.updateResourceLocalTransactionsAlert();
    }

    private void updateResourceLocalTransactionsAlert() {
        if (this.view.getResourceLocalTransactions()) {
            this.view.setTransactionTypeHelpMessage(Constants.INSTANCE.persistence_descriptor_editor_resource_local_transactions_not_supported_message());
        } else {
            this.view.setTransactionTypeHelpMessage(null);
        }
    }

    @Override
    public void onLoadClasses() {
        this.view.showBusyIndicator(Constants.INSTANCE.persistence_descriptor_editor_loading_classes_message());
        ((DataModelerService)this.dataModelerService.call(this.getLoadClassesSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).findPersistableClasses((Path)this.versionRecordManager.getCurrentPath());
    }

    @Override
    public void onLoadClass(String className) {
        this.view.showBusyIndicator(Constants.INSTANCE.persistence_descriptor_editor_loading_classes_message());
        ((DataModelerService)this.dataModelerService.call(this.getLoadClassSuccessCallback(className), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).isPersistableClass(className, (Path)this.versionRecordManager.getCurrentPath());
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                PersistenceDescriptorEditorPresenter.this.onValidateDescriptor();
            }
        };
    }

    protected void onValidateDescriptor() {
        this.updateContent();
        ((PersistenceDescriptorService)this.descriptorService.call(this.getValidationSuccessCallback(), (ErrorCallback)new DefaultErrorCallback())).validate((Path)this.versionRecordManager.getCurrentPath(), (Object)this.content.getDescriptorModel());
    }

    private RemoteCallback<List<ValidationMessage>> getValidationSuccessCallback() {
        return new RemoteCallback<List<ValidationMessage>>(){

            public void callback(List<ValidationMessage> messages) {
                if (messages == null || messages.isEmpty()) {
                    PersistenceDescriptorEditorPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                } else {
                    PersistenceDescriptorEditorPresenter.this.validationPopup.showTranslatedMessages(messages);
                }
            }
        };
    }

    protected void updateContent() {
        this.content.getDescriptorModel().getPersistenceUnit().setProperties(this.unWrappPropertiesList(this.view.getPersistenceUnitProperties().getProperties()));
        this.content.getDescriptorModel().getPersistenceUnit().setClasses(this.unWrappClassesList(this.view.getPersistenceUnitClasses().getClasses()));
    }

    private RemoteCallback<List<String>> getLoadClassesSuccessCallback() {
        return new RemoteCallback<List<String>>(){

            public void callback(List<String> classes) {
                PersistenceDescriptorEditorPresenter.this.view.hideBusyIndicator();
                PersistenceDescriptorEditorPresenter.this.appendPersistableClasses(classes);
                PersistenceDescriptorEditorPresenter.this.view.getPersistenceUnitClasses().setNewClassHelpMessage(null);
                PersistenceDescriptorEditorPresenter.this.view.getPersistenceUnitClasses().setNewClassName(null);
            }
        };
    }

    private RemoteCallback<Boolean> getLoadClassSuccessCallback(final String className) {
        return new RemoteCallback<Boolean>(){

            public void callback(Boolean persistable) {
                PersistenceDescriptorEditorPresenter.this.view.hideBusyIndicator();
                if (persistable.booleanValue()) {
                    ArrayList<String> classes = new ArrayList<String>();
                    classes.add(className);
                    PersistenceDescriptorEditorPresenter.this.appendPersistableClasses(classes);
                    PersistenceDescriptorEditorPresenter.this.view.getPersistenceUnitClasses().setNewClassHelpMessage(null);
                    PersistenceDescriptorEditorPresenter.this.view.getPersistenceUnitClasses().setNewClassName(null);
                } else {
                    PersistenceDescriptorEditorPresenter.this.view.getPersistenceUnitClasses().setNewClassHelpMessage(Constants.INSTANCE.persistence_descriptor_editor_peristable_class_not_found(className));
                }
            }
        };
    }

    private void appendPersistableClasses(List<String> classes) {
        if (classes != null && classes.size() > 0) {
            List<String> currentClasses = this.unWrappClassesList(this.view.getPersistenceUnitClasses().getClasses());
            for (String clazz : classes) {
                if (currentClasses.contains(clazz)) continue;
                currentClasses.add(clazz);
            }
            this.view.getPersistenceUnitClasses().setClasses(this.wrappClassesList(currentClasses));
        }
    }

    private void ensurePersistenceUnit() {
        if (this.content.getDescriptorModel().getPersistenceUnit() == null) {
            this.content.getDescriptorModel().setPersistenceUnit(new PersistenceUnitModel());
        }
    }

    private List<ClassRow> wrappClassesList(List<String> classes) {
        ArrayList<ClassRow> classRows = new ArrayList<ClassRow>();
        if (classes == null) {
            return null;
        }
        for (String clazz : classes) {
            classRows.add(new ClassRowImpl(clazz));
        }
        return classRows;
    }

    private List<String> unWrappClassesList(List<ClassRow> classRows) {
        ArrayList<String> classes = new ArrayList<String>();
        if (classRows == null) {
            return null;
        }
        for (ClassRow classRow : classRows) {
            classes.add(classRow.getClassName());
        }
        return classes;
    }

    private List<PropertyRow> wrappPropertiesList(List<Property> properties) {
        ArrayList<PropertyRow> wrapperList = new ArrayList<PropertyRow>();
        if (properties == null) {
            return null;
        }
        for (Property property : properties) {
            wrapperList.add(new PropertyWrapperRow(property));
        }
        return wrapperList;
    }

    private List<Property> unWrappPropertiesList(List<PropertyRow> propertyRows) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (propertyRows == null) {
            return null;
        }
        for (PropertyRow propertyRow : propertyRows) {
            properties.add(new Property(propertyRow.getName(), propertyRow.getValue()));
        }
        return properties;
    }

    public static class PropertyWrapperRow
    implements PropertyRow {
        private Property property = new Property();

        public PropertyWrapperRow(Property property) {
            if (property != null) {
                this.property = property;
            }
        }

        @Override
        public String getName() {
            return this.property.getName();
        }

        @Override
        public void setName(String name) {
            this.property.setName(name);
        }

        @Override
        public String getValue() {
            return this.property.getValue();
        }

        @Override
        public void setValue(String value) {
            this.property.setValue(value);
        }
    }
}

