/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.editor;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.resources.images.ImagesResources;
import org.kie.workbench.common.screens.datamodeller.client.util.AnnotationValueHandler;
import org.kie.workbench.common.screens.datamodeller.client.widgets.editor.ClickableImageResourceCell;
import org.kie.workbench.common.screens.datamodeller.client.widgets.editor.DataObjectBrowserView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.refactoring.ShowUsagesPopup;
import org.kie.workbench.common.services.datamodeller.core.HasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.tables.SimpleTable;
import org.uberfire.mvp.Command;

@Dependent
public class DataObjectBrowserViewImpl
extends Composite
implements DataObjectBrowserView {
    private static DataObjectBrowserViewImplUIBinder uiBinder = (DataObjectBrowserViewImplUIBinder)GWT.create(DataObjectBrowserViewImplUIBinder.class);
    private final ButtonCell deleteCell = new ButtonCell(IconType.TRASH, ButtonType.DANGER, ButtonSize.SMALL);
    @UiField
    Button objectButton;
    @UiField
    Button newPropertyButton;
    @UiField(provided=true)
    SimpleTable<ObjectProperty> propertiesTable = new BrowserSimpleTable<ObjectProperty>(1000);
    @Inject
    private ValidationPopup validationPopup;
    Map<Column<?, ?>, ColumnId> columnIds = new HashMap();
    ListDataProvider<ObjectProperty> dataProvider;
    private DataObjectBrowserView.Presenter presenter;
    private boolean readonly = true;
    private int tableHeight = 480;

    @Inject
    public DataObjectBrowserViewImpl(ValidationPopup validationPopup) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.validationPopup = validationPopup;
    }

    @PostConstruct
    protected void init() {
        this.newPropertyButton.setIcon(IconType.PLUS);
        this.newPropertyButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataObjectBrowserViewImpl.this.presenter.onNewProperty();
            }
        });
        this.objectButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataObjectBrowserViewImpl.this.presenter.onSelectCurrentDataObject();
            }
        });
        this.propertiesTable.setEmptyTableCaption(Constants.INSTANCE.objectBrowser_emptyTable());
        this.propertiesTable.setColumnPickerButtonVisible(false);
        this.propertiesTable.setToolBarVisible(false);
        this.setTableHeight(this.tableHeight);
        this.addPropertyNameColumn();
        this.addPropertyLabelColumn();
        this.addPropertyTypeBrowseColumn();
        this.addPropertyTypeColumn();
        this.addRemoveRowColumn();
        this.addSortHandler();
        SingleSelectionModel selectionModel = new SingleSelectionModel();
        this.propertiesTable.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                ObjectProperty selectedProperty = (ObjectProperty)((SingleSelectionModel)DataObjectBrowserViewImpl.this.propertiesTable.getSelectionModel()).getSelectedObject();
                DataObjectBrowserViewImpl.this.presenter.onSelectProperty(selectedProperty);
            }
        });
        this.setReadonly(true);
    }

    public void init(DataObjectBrowserView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setDataProvider(ListDataProvider<ObjectProperty> dataProvider) {
        if (!dataProvider.getDataDisplays().contains(this.propertiesTable)) {
            dataProvider.addDataDisplay(this.propertiesTable);
        }
        this.dataProvider = dataProvider;
    }

    @Override
    public void setObjectSelectorLabel(String label, String title) {
        this.objectButton.setText(label);
        this.objectButton.setTitle(title);
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.enableNewPropertyAction(!readonly);
        this.enableDeleteRowAction(!readonly);
    }

    @Override
    public void enableNewPropertyAction(boolean enable) {
        this.newPropertyButton.setEnabled(enable);
    }

    @Override
    public void enableDeleteRowAction(boolean enable) {
        this.deleteCell.setEnabled(enable);
    }

    @Override
    public void redrawRow(int row) {
        this.propertiesTable.redraw();
    }

    @Override
    public void redrawTable() {
        this.propertiesTable.redraw();
    }

    @Override
    public ObjectProperty getSelectedRow() {
        return (ObjectProperty)((SingleSelectionModel)this.propertiesTable.getSelectionModel()).getSelectedObject();
    }

    @Override
    public void setSelectedRow(ObjectProperty objectProperty, boolean select) {
        ((SingleSelectionModel)this.propertiesTable.getSelectionModel()).setSelected((Object)objectProperty, select);
    }

    @Override
    public void setTableHeight(int height) {
        this.tableHeight = height;
        this.propertiesTable.setHeight(this.tableHeight + "px");
    }

    @Override
    public int getTableHeight() {
        return this.tableHeight;
    }

    private void addPropertyNameColumn() {
        Column<ObjectProperty, String> column = new Column<ObjectProperty, String>((Cell)new TextCell()){

            public String getValue(ObjectProperty objectProperty) {
                if (objectProperty.getName() != null) {
                    return objectProperty.getName();
                }
                return "";
            }
        };
        column.setSortable(true);
        this.propertiesTable.addColumn((Column)column, Constants.INSTANCE.objectBrowser_columnName());
        this.propertiesTable.setColumnWidth((Column)column, 25.0, Style.Unit.PCT);
        this.columnIds.put(column, ColumnId.NAME_COLUMN);
    }

    private void addPropertyLabelColumn() {
        Column<ObjectProperty, String> column = new Column<ObjectProperty, String>((Cell)new TextCell()){

            public String getValue(ObjectProperty objectProperty) {
                if (objectProperty.getName() != null) {
                    return AnnotationValueHandler.getStringValue((HasAnnotations)objectProperty, "org.kie.api.definition.type.Label", "value");
                }
                return "";
            }
        };
        column.setSortable(true);
        this.propertiesTable.addColumn((Column)column, Constants.INSTANCE.objectBrowser_columnLabel());
        this.propertiesTable.setColumnWidth((Column)column, 25.0, Style.Unit.PCT);
        this.columnIds.put(column, ColumnId.LABEL_COLUMN);
    }

    private void addPropertyTypeBrowseColumn() {
        ClickableImageResourceCell typeImageCell = new ClickableImageResourceCell(true, 20);
        Column<ObjectProperty, ImageResource> column = new Column<ObjectProperty, ImageResource>((Cell)typeImageCell){

            public ImageResource getValue(ObjectProperty property) {
                if (DataObjectBrowserViewImpl.this.presenter != null && DataObjectBrowserViewImpl.this.presenter.isSelectablePropertyType(property)) {
                    return ImagesResources.INSTANCE.BrowseObject();
                }
                return null;
            }
        };
        column.setFieldUpdater((FieldUpdater)new FieldUpdater<ObjectProperty, ImageResource>(){

            public void update(int index, ObjectProperty property, ImageResource value) {
                DataObjectBrowserViewImpl.this.presenter.onSelectPropertyType(property);
            }
        });
        this.propertiesTable.addColumn((Column)column, " ");
        this.propertiesTable.setColumnWidth((Column)column, 38.0, Style.Unit.PX);
    }

    private void addPropertyTypeColumn() {
        Column<ObjectProperty, String> column = new Column<ObjectProperty, String>((Cell)new TextCell()){

            public String getValue(ObjectProperty objectProperty) {
                if (objectProperty.getName() != null && DataObjectBrowserViewImpl.this.presenter != null) {
                    return DataObjectBrowserViewImpl.this.presenter.getPropertyTypeDisplayValue(objectProperty);
                }
                return "";
            }
        };
        column.setSortable(true);
        this.propertiesTable.addColumn((Column)column, Constants.INSTANCE.objectBrowser_columnType());
        this.propertiesTable.setColumnWidth((Column)column, 35.0, Style.Unit.PCT);
        this.columnIds.put(column, ColumnId.TYPE_COLUMN);
    }

    private void addRemoveRowColumn() {
        ButtonCell buttonCell = new ButtonCell(IconType.TRASH, ButtonType.DANGER, ButtonSize.SMALL);
        Column<ObjectProperty, String> column = new Column<ObjectProperty, String>((Cell)buttonCell){

            public String getValue(ObjectProperty objectProperty) {
                return Constants.INSTANCE.objectBrowser_action_delete();
            }
        };
        column.setFieldUpdater((FieldUpdater)new FieldUpdater<ObjectProperty, String>(){

            public void update(int index, ObjectProperty objectProperty, String value) {
                if (!DataObjectBrowserViewImpl.this.readonly) {
                    DataObjectBrowserViewImpl.this.presenter.onDeleteProperty(objectProperty, index);
                }
            }
        });
        this.propertiesTable.addColumn((Column)column, "");
        this.propertiesTable.setColumnWidth((Column)column, (double)this.calculateButtonSize(Constants.INSTANCE.objectBrowser_action_delete()), Style.Unit.PX);
    }

    private void addSortHandler() {
        this.propertiesTable.addColumnSortHandler(new ColumnSortEvent.Handler(){

            public void onColumnSort(ColumnSortEvent event) {
                Column column = event.getColumn();
                ColumnId columnId = DataObjectBrowserViewImpl.this.columnIds.get(column);
                if (columnId != null) {
                    switch (columnId) {
                        case NAME_COLUMN: {
                            DataObjectBrowserViewImpl.this.presenter.onSortByName(event.isSortAscending());
                            break;
                        }
                        case LABEL_COLUMN: {
                            DataObjectBrowserViewImpl.this.presenter.onSortByLabel(event.isSortAscending());
                            break;
                        }
                        case TYPE_COLUMN: {
                            DataObjectBrowserViewImpl.this.presenter.onSortByType(event.isSortAscending());
                        }
                    }
                }
            }
        });
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @Override
    public void showYesNoCancelPopup(String title, String content, Command yesCommand, String yesButtonText, ButtonType yesButtonType, Command noCommand, String noButtonText, ButtonType noButtonType, Command cancelCommand, String cancelButtonText, ButtonType cancelButtonType) {
        YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)title, (String)content, (Command)yesCommand, (String)yesButtonText, (ButtonType)yesButtonType, (Command)noCommand, (String)noButtonText, (ButtonType)noButtonType, (Command)cancelCommand, (String)cancelButtonText, (ButtonType)cancelButtonType);
        yesNoCancelPopup.setClosable(false);
        yesNoCancelPopup.show();
    }

    @Override
    public void showUsagesPopupForDeletion(String message, List<Path> usedByFiles, Command yesCommand, Command cancelCommand) {
        ShowUsagesPopup showUsagesPopup = ShowUsagesPopup.newUsagesPopupForDeletion(message, usedByFiles, yesCommand, cancelCommand);
        showUsagesPopup.setClosable(false);
        showUsagesPopup.show();
    }

    @Override
    public void showValidationPopupForDeletion(List<ValidationMessage> validationMessages, Command yesCommand, Command cancelCommand) {
        this.validationPopup.showDeleteValidationMessages(yesCommand, cancelCommand, validationMessages);
    }

    private int calculateButtonSize(String buttonLabel) {
        return 11 * buttonLabel.length() + 12 + 4;
    }

    private class BrowserSimpleTable<T>
    extends SimpleTable<T> {
        public BrowserSimpleTable(int pageSize) {
            this.dataGrid.setPageSize(pageSize);
        }
    }

    static enum ColumnId {
        NAME_COLUMN,
        LABEL_COLUMN,
        TYPE_COLUMN;

    }

    static interface DataObjectBrowserViewImplUIBinder
    extends UiBinder<Widget, DataObjectBrowserViewImpl> {
    }
}

