/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.handlers.jpadomain;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.command.AddPropertyCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.FieldTypeChangeCommand;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandler;
import org.kie.workbench.common.screens.datamodeller.client.handlers.jpadomain.command.AdjustFieldDefaultRelationsCommand;
import org.kie.workbench.common.screens.datamodeller.client.handlers.jpadomain.command.JPACommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ResourceOptions;
import org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.options.JPANewResourceOptions;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;

@ApplicationScoped
public class JPADomainHandler
implements DomainHandler {
    public static final String ENABLE_DATA_OBJECT_AUDIT = "enable-data-object-audit";
    @Inject
    private Instance<JPANewResourceOptions> newResourceOptions;
    @Inject
    private JPACommandBuilder commandBuilder;

    @Override
    public String getName() {
        return "JPA";
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public ResourceOptions getResourceOptions(boolean newInstance) {
        return (ResourceOptions)this.newResourceOptions.get();
    }

    @Override
    public void postCommandProcessing(DataModelCommand command) {
        if (command instanceof FieldTypeChangeCommand && (this.isPersistable(((FieldTypeChangeCommand)command).getDataObject()) || this.isRelationConfigured(((FieldTypeChangeCommand)command).getField()))) {
            AdjustFieldDefaultRelationsCommand postCommand = this.commandBuilder.buildAdjustFieldDefaultRelationsCommand((FieldTypeChangeCommand)command, this.getName(), ((FieldTypeChangeCommand)command).getField());
            postCommand.execute();
        } else if (command instanceof AddPropertyCommand && this.isPersistable(((AddPropertyCommand)command).getDataObject())) {
            AdjustFieldDefaultRelationsCommand postCommand = this.commandBuilder.buildAdjustFieldDefaultRelationsCommand((AddPropertyCommand)command, this.getName(), ((AddPropertyCommand)command).getProperty());
            postCommand.execute();
        }
    }

    public boolean isOptionEnabled(String option) {
        return ApplicationPreferences.getBooleanPref((String)("data-modeler-options." + option));
    }

    public boolean isDataObjectAuditEnabled() {
        return this.isOptionEnabled(ENABLE_DATA_OBJECT_AUDIT);
    }

    private boolean isPersistable(DataObject dataObject) {
        return dataObject.getAnnotation("javax.persistence.Entity") != null;
    }

    private boolean isRelationConfigured(ObjectProperty objectProperty) {
        return objectProperty.getAnnotation("javax.persistence.ManyToOne") != null || objectProperty.getAnnotation("javax.persistence.ManyToMany") != null || objectProperty.getAnnotation("javax.persistence.OneToOne") != null || objectProperty.getAnnotation("javax.persistence.OneToMany") != null || objectProperty.getAnnotation("javax.persistence.ElementCollection") != null;
    }
}

