/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.command;

import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelChangeNotifier;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.ValuePair;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;

public abstract class AbstractDataModelCommand
implements DataModelCommand {
    protected DataModelerContext context;
    protected String source;
    protected DataObject dataObject;
    protected String annotationClassName;
    protected String valuePair;
    protected Object newValue;
    protected boolean removeAnnotationIfValueIsNull;
    protected DataModelChangeNotifier notifier;
    protected List<ValuePair> valuePairs = new ArrayList<ValuePair>();

    public AbstractDataModelCommand(DataModelerContext context, String source, DataObject dataObject, String annotationClassName, String valuePair, Object newValue, boolean removeAnnotationIfValueIsNull, DataModelChangeNotifier notifier) {
        this.context = context;
        this.source = source;
        this.dataObject = dataObject;
        this.annotationClassName = annotationClassName;
        this.valuePair = valuePair;
        this.newValue = newValue;
        this.removeAnnotationIfValueIsNull = removeAnnotationIfValueIsNull;
        this.notifier = notifier;
    }

    public AbstractDataModelCommand(DataModelerContext context, String source, DataObject dataObject, DataModelChangeNotifier notifier) {
        this.context = context;
        this.source = source;
        this.dataObject = dataObject;
        this.notifier = notifier;
    }

    public AbstractDataModelCommand(DataModelerContext context, String source, DataObject dataObject, String annotationClassName, DataModelChangeNotifier notifier) {
        this.context = context;
        this.source = source;
        this.dataObject = dataObject;
        this.annotationClassName = annotationClassName;
        this.notifier = notifier;
    }

    public DataModelerContext getContext() {
        return this.context;
    }

    public void setContext(DataModelerContext context) {
        this.context = context;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    public String getAnnotationClassName() {
        return this.annotationClassName;
    }

    public void setAnnotationClassName(String annotationClassName) {
        this.annotationClassName = annotationClassName;
    }

    public String getValuePair() {
        return this.valuePair;
    }

    public void setValuePair(String valuePair) {
        this.valuePair = valuePair;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    public boolean isRemoveAnnotationIfValueIsNull() {
        return this.removeAnnotationIfValueIsNull;
    }

    public void setRemoveAnnotationIfValueIsNull(boolean removeAnnotationIfValueIsNull) {
        this.removeAnnotationIfValueIsNull = removeAnnotationIfValueIsNull;
    }

    public AbstractDataModelCommand withValuePair(ValuePair valuePair) {
        if (this.valuePairs == null) {
            this.valuePairs = new ArrayList<ValuePair>();
        }
        this.valuePairs.add(valuePair);
        return this;
    }

    public AbstractDataModelCommand withValuePair(String name, Object value) {
        return this.withValuePair(new ValuePair(name, value));
    }

    protected void notifyFieldChange(ChangeType changeType, DataModelerContext context, String source, DataObject dataObject, ObjectProperty field, String annotationClassName, String memberName, Object oldValue, Object newValue) {
        if (this.notifier != null) {
            this.notifier.notifyFieldChange(changeType, context, source, dataObject, field, annotationClassName, memberName, oldValue, newValue);
        }
    }

    protected void notifyObjectChange(ChangeType changeType, DataModelerContext context, String source, DataObject dataObject, String annotationClassName, String memberName, Object oldValue, Object newValue) {
        if (this.notifier != null) {
            this.notifier.notifyObjectChange(changeType, context, source, dataObject, annotationClassName, memberName, oldValue, newValue);
        }
    }

    protected void notifyChange(DataModelerEvent event) {
        if (this.notifier != null) {
            this.notifier.notifyChange(event);
        }
    }
}

