/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.command;

import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.AbstractDataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelChangeNotifier;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldCreatedEvent;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;

public class AddPropertyCommand
extends AbstractDataModelCommand {
    private String propertyName;
    private String propertyLabel;
    private String propertyType;
    private Boolean isMultiple;
    private ObjectProperty property;

    public AddPropertyCommand(DataModelerContext context, String source, DataObject dataObject, String propertyName, String propertyLabel, String propertyType, Boolean isMultiple, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, notifier);
        this.propertyName = propertyName;
        this.propertyLabel = propertyLabel;
        this.propertyType = propertyType;
        this.isMultiple = isMultiple;
    }

    @Override
    public void execute() {
        boolean multiple = this.isMultiple != false && this.getContext().getHelper().isPrimitiveType(this.propertyType) == false;
        this.property = new ObjectPropertyImpl(this.propertyName, this.propertyType, multiple);
        if (this.propertyLabel != null && !"".equals(this.propertyLabel)) {
            AnnotationImpl annotation = new AnnotationImpl(this.getContext().getAnnotationDefinitions().get("org.kie.api.definition.type.Label"));
            annotation.setValue("value", (Object)this.propertyLabel);
            this.property.addAnnotation((Annotation)annotation);
        }
        this.dataObject.addProperty(this.property);
        if (!this.property.isBaseType()) {
            this.getContext().getHelper().dataObjectReferenced(this.property.getClassName(), this.dataObject.getClassName());
        }
        this.notifyChange((DataModelerEvent)new DataObjectFieldCreatedEvent(this.getContext().getContextId(), this.getSource(), this.getDataObject(), this.property));
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyLabel() {
        return this.propertyLabel;
    }

    public void setPropertyLabel(String propertyLabel) {
        this.propertyLabel = propertyLabel;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }

    public Boolean getIsMultiple() {
        return this.isMultiple;
    }

    public void setIsMultiple(Boolean isMultiple) {
        this.isMultiple = isMultiple;
    }

    public ObjectProperty getProperty() {
        return this.property;
    }
}

