/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.command;

import java.util.List;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.AbstractDataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelChangeNotifier;
import org.kie.workbench.common.screens.datamodeller.client.command.ValuePair;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;

public class DataObjectAddAnnotationCommand
extends AbstractDataModelCommand {
    private Annotation annotation;

    public DataObjectAddAnnotationCommand(DataModelerContext context, String source, DataObject dataObject, String annotationClassName, List<ValuePair> valuePairs, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, notifier);
        this.annotationClassName = annotationClassName;
        this.valuePairs = valuePairs;
    }

    public DataObjectAddAnnotationCommand(DataModelerContext context, String source, DataObject dataObject, String annotationClassName, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, notifier);
        this.annotationClassName = annotationClassName;
    }

    public DataObjectAddAnnotationCommand(DataModelerContext context, String source, DataObject dataObject, Annotation annotation, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, notifier);
        this.annotation = annotation;
    }

    @Override
    public void execute() {
        if (this.annotation == null) {
            this.annotation = new AnnotationImpl(this.context.getAnnotationDefinition(this.annotationClassName));
            if (this.valuePairs != null) {
                for (ValuePair valuePair : this.valuePairs) {
                    this.annotation.setValue(valuePair.getName(), valuePair.getValue());
                }
            }
        }
        this.dataObject.addAnnotation(this.annotation);
        this.notifyObjectChange(ChangeType.TYPE_ANNOTATION_ADD_CHANGE, this.context, this.source, this.dataObject, this.annotation.getClassName(), null, null, null);
    }
}

