/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.command;

import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.AbstractDataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelChangeNotifier;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;

public class DataObjectAnnotationValueChangeCommand
extends AbstractDataModelCommand {
    public DataObjectAnnotationValueChangeCommand(DataModelerContext context, String source, DataObject dataObject, String annotationClassName, String valuePair, Object newValue, boolean removeIfNull, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, annotationClassName, valuePair, newValue, removeIfNull, notifier);
    }

    @Override
    public void execute() {
        Object oldValue = null;
        Annotation annotation = this.dataObject.getAnnotation(this.annotationClassName);
        if (annotation != null) {
            oldValue = annotation.getValue(this.valuePair);
            if (this.newValue != null && !this.newValue.equals(oldValue)) {
                annotation.setValue(this.valuePair, this.newValue);
                this.notifyObjectChange(ChangeType.TYPE_ANNOTATION_VALUE_CHANGE, this.context, this.source, this.dataObject, this.annotationClassName, this.valuePair, oldValue, this.newValue);
            } else if (this.newValue == null && oldValue != null) {
                if (this.removeAnnotationIfValueIsNull) {
                    this.dataObject.removeAnnotation(this.annotationClassName);
                    this.notifyObjectChange(ChangeType.TYPE_ANNOTATION_REMOVE_CHANGE, this.context, this.source, this.dataObject, this.annotationClassName, this.valuePair, oldValue, this.newValue);
                } else {
                    annotation.setValue(this.valuePair, this.newValue);
                    this.notifyObjectChange(ChangeType.TYPE_ANNOTATION_VALUE_CHANGE, this.context, this.source, this.dataObject, this.annotationClassName, this.valuePair, oldValue, this.newValue);
                }
            }
        } else if (this.newValue != null) {
            annotation = new AnnotationImpl(this.context.getAnnotationDefinitions().get(this.annotationClassName));
            annotation.setValue(this.valuePair, this.newValue);
            this.dataObject.addAnnotation(annotation);
            this.notifyObjectChange(ChangeType.TYPE_ANNOTATION_ADD_CHANGE, this.context, this.source, this.dataObject, this.annotationClassName, this.valuePair, oldValue, this.newValue);
        }
    }
}

