/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.command;

import java.util.List;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.AbstractDataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelChangeNotifier;
import org.kie.workbench.common.screens.datamodeller.client.command.ValuePair;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;

public class FieldAddAnnotationCommand
extends AbstractDataModelCommand {
    private ObjectProperty field;
    private Annotation annotation;

    public FieldAddAnnotationCommand(DataModelerContext context, String source, DataObject dataObject, ObjectProperty field, String annotationClassName, List<ValuePair> valuePairs, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, notifier);
        this.annotationClassName = annotationClassName;
        this.field = field;
        this.valuePairs = valuePairs;
    }

    public FieldAddAnnotationCommand(DataModelerContext context, String source, DataObject dataObject, ObjectProperty field, String annotationClassName, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, notifier);
        this.annotationClassName = annotationClassName;
        this.field = field;
    }

    public FieldAddAnnotationCommand(DataModelerContext context, String source, DataObject dataObject, ObjectProperty field, Annotation annotation, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, notifier);
        this.annotation = annotation;
        this.field = field;
    }

    @Override
    public void execute() {
        if (this.annotation == null) {
            this.annotation = new AnnotationImpl(this.context.getAnnotationDefinition(this.annotationClassName));
            if (this.valuePairs != null) {
                for (ValuePair valuePair : this.valuePairs) {
                    this.annotation.setValue(valuePair.getName(), valuePair.getValue());
                }
            }
        }
        this.field.addAnnotation(this.annotation);
        this.notifyFieldChange(ChangeType.FIELD_ANNOTATION_ADD_CHANGE, this.context, this.source, this.dataObject, this.field, this.annotation.getClassName(), null, null, null);
    }
}

